/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.handler;

import com.pingidentity.locale.TemplateBannerMessage;
import com.pingidentity.localidentity.LocalIdentityAdapter;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.localidentity.common.EmailCommunicationUtils;
import com.pingidentity.localidentity.common.EmailFieldUtils;
import com.pingidentity.localidentity.common.EmailTemplateRendererUtils;
import com.pingidentity.localidentity.handler.BaseLipHandler;
import com.pingidentity.sdk.template.TemplateRendererUtilException;
import com.unboundid.ldap.sdk.DN;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.SendEmailVerification;
import org.sourceid.util.log.AttributeMap;

public class SendEmailHandler
extends BaseLipHandler {
    private static final Log log = LogFactory.getLog(SendEmailHandler.class);

    public void handle(HttpServletRequest req, HttpServletResponse resp, LocalIdentityProfile lip, LocalIdentityDTO<DN> dto, AttributeMap attributeMap) {
        Objects.requireNonNull(lip, "lip");
        Objects.requireNonNull(dto, "dto");
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        Map attributesForMapping = dto.getAttributesForMapping();
        templateData.put("userAttributes", attributesForMapping);
        if (EmailFieldUtils.isEmailStatusVerified(lip, dto)) {
            try {
                EmailTemplateRendererUtils.renderEmailVerificationErrorPage(req, resp, lip, "already.verified.title", "already.verified", templateData);
            }
            catch (TemplateRendererUtilException e) {
                log.error((Object)"Error rendering the general error page template.");
            }
            return;
        }
        try {
            EmailCommunicationUtils.sendEmailVerification(req, resp, lip, dto);
            if (LocalIdentityUtils.isOtpEmailVerificationType((LocalIdentityProfile)lip)) {
                TemplateBannerMessage bannerMessage = null;
                if (LocalIdentityAdapter.isResendAction((HttpServletRequest)req)) {
                    String emailValue = SendEmailVerification.getEmail((LocalIdentityProfile)lip, (Map)attributesForMapping);
                    bannerMessage = new TemplateBannerMessage("local.identity.email.verification.otp.resentNotification", new String[]{emailValue}, TemplateBannerMessage.TemplateMessageType.SUCCESS);
                } else if (LocalIdentityAdapter.isCancelAction((HttpServletRequest)req)) {
                    EmailTemplateRendererUtils.renderEmailVerificationErrorPage(req, resp, lip, "title", "emailVerificationFailed", templateData);
                    return;
                }
                EmailTemplateRendererUtils.renderEmailVerificationOtpPage(req, resp, SendEmailVerification.getEmail((LocalIdentityProfile)lip, (Map)attributesForMapping), lip, bannerMessage, templateData);
            } else {
                EmailTemplateRendererUtils.renderEmailSentPage(req, resp, lip, templateData);
            }
        }
        catch (TemplateRendererUtilException ex) {
            log.error((Object)"Error rendering the Email Verification Sent template.");
        }
        catch (IOException e) {
            log.error((Object)"Error sending the verification email.");
        }
    }
}

