/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.auth.login;

import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class WebAuthNUtil {
    public static final String WEB_AUTHN_SOURCE_NAME = "FIDO";

    private static boolean isAndroid(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return userAgent.toLowerCase().contains("android");
    }

    private static boolean isWindows(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return userAgent.toLowerCase().contains("windows");
    }

    private static boolean isMac(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return userAgent.toLowerCase().contains("mac");
    }

    private static boolean isIos(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        String userAgentLowerCase = userAgent.toLowerCase();
        return userAgentLowerCase.contains("iphone") || userAgentLowerCase.contains("ipad") || userAgentLowerCase.contains("ipod");
    }

    public static String getSourceName(HttpServletRequest req) {
        String sourceName = "Biometrics";
        String userAgent = req.getHeader("User-Agent");
        if (WebAuthNUtil.isAndroid(userAgent)) {
            sourceName = "Biometrics";
        } else if (WebAuthNUtil.isWindows(userAgent)) {
            sourceName = "Windows Hello";
        } else if (WebAuthNUtil.isIos(userAgent)) {
            sourceName = "Face ID";
        } else if (WebAuthNUtil.isMac(userAgent)) {
            sourceName = "Touch ID";
        }
        return sourceName;
    }

    public static List<String> filterWebAuthNSource(HttpServletRequest req, List<String> authSourceStrings) {
        boolean containsFIDO = authSourceStrings.removeIf(source -> WEB_AUTHN_SOURCE_NAME.equals(source));
        if (containsFIDO) {
            authSourceStrings.add(WebAuthNUtil.getSourceName(req));
        }
        return authSourceStrings;
    }
}

