/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection;

import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.NoOpAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class LeafNodeVisitor
implements TraversalVisitor<AuthnSelectionAction> {
    private final List<Tree.Node<AuthnSelectionAction>> apcNodes = new LinkedList<Tree.Node<AuthnSelectionAction>>();
    private final List<Tree.Node<AuthnSelectionAction>> lipNodes = new LinkedList<Tree.Node<AuthnSelectionAction>>();
    private final List<Tree.Node<AuthnSelectionAction>> doneNodes = new LinkedList<Tree.Node<AuthnSelectionAction>>();
    private final List<Tree.Node<AuthnSelectionAction>> continueNodes = new LinkedList<Tree.Node<AuthnSelectionAction>>();
    private final List<Tree.Node<AuthnSelectionAction>> restartNodes = new LinkedList<Tree.Node<AuthnSelectionAction>>();
    private final List<Tree.Node<AuthnSelectionAction>> terminatingFragments = new LinkedList<Tree.Node<AuthnSelectionAction>>();

    public boolean continueTraversal() {
        return true;
    }

    public void visit(AuthnSelectionAction action, Tree.Node<AuthnSelectionAction> currentNode) {
        if (action instanceof ApcMappingAction) {
            this.apcNodes.add(currentNode);
        } else if (action instanceof FragmentAction) {
            Optional<Tree.Node> doneNodes = currentNode.getChildren().stream().filter(node -> node.getData() instanceof NoOpAction && ((NoOpAction)node.getData()).getType().equals((Object)NoOpAction.Type.DONE)).findAny();
            if (doneNodes.isPresent()) {
                this.terminatingFragments.add(currentNode);
            }
        } else if (action instanceof LocalIdentityMappingAction) {
            this.apcNodes.add(currentNode);
            this.lipNodes.add(currentNode);
        } else if (action instanceof NoOpAction) {
            if (((NoOpAction)action).getType() == NoOpAction.Type.DONE) {
                this.doneNodes.add(currentNode);
            } else if (((NoOpAction)action).getType() == NoOpAction.Type.CONTINUE) {
                this.continueNodes.add(currentNode);
            } else if (((NoOpAction)action).getType() == NoOpAction.Type.RESTART) {
                this.restartNodes.add(currentNode);
            }
        }
    }

    public List<Tree.Node<AuthnSelectionAction>> getDoneNodes() {
        return this.doneNodes;
    }

    public List<Tree.Node<AuthnSelectionAction>> getContinueNodes() {
        return this.continueNodes;
    }

    public List<Tree.Node<AuthnSelectionAction>> getApcNodes() {
        return this.apcNodes;
    }

    public List<Tree.Node<AuthnSelectionAction>> getLipNodes() {
        return this.lipNodes;
    }

    public List<Tree.Node<AuthnSelectionAction>> getRestartNodes() {
        return this.restartNodes;
    }

    public List<Tree.Node<AuthnSelectionAction>> getTerminatingFragments() {
        return this.terminatingFragments;
    }
}

