/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.c2ccontract;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.VirtualServerIdsReferencer;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class C2cContractAttributeMapping
extends AttributeMapping
implements VirtualServerIdsReferencer,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final C2cContractManager c2cManager = MgmtFactory.getC2cContractManager();
    private String contractId;
    private boolean restrictVirtualServerIds;
    private List<String> restrictedVirtualServerIds = Collections.emptyList();

    public String getContractId() {
        return this.contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    @Override
    public boolean isRestrictVirtualServerIds() {
        return this.restrictVirtualServerIds;
    }

    @Override
    public void setRestrictVirtualServerIds(boolean restrictVirtualServerIds) {
        this.restrictVirtualServerIds = restrictVirtualServerIds;
    }

    @Override
    public List<String> getRestrictedVirtualServerIds() {
        return this.restrictedVirtualServerIds;
    }

    @Override
    public void setRestrictedVirtualServerIds(List<String> restrictedVirtualServerIds) {
        this.restrictedVirtualServerIds = restrictedVirtualServerIds;
    }

    public AttributeMap executeMapping(AttributeMap srcAttributes, AttributeMap contextAttributes) throws AttrLookupException, AuthorizationException {
        C2cContract contract = c2cManager.getContract(this.contractId);
        Set<String> allAttributeNames = contract.getAllAttributeNames();
        AttributeMap attributeMap = super.executeMapping(srcAttributes, allAttributeNames, contextAttributes);
        if (attributeMap.isEmpty()) {
            throw new ProcessRuntimeException("Connection contract attribute mapping produced empty result.");
        }
        return attributeMap;
    }
}

