/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.captcha;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.util.json.JsonUtils;

public class CaptchaServerSideRequestHelper {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String SECRET_PARAM = "secret";
    private static final String RESPONSE_PARAM = "response";
    private static final String TOKEN_PARAM = "token";
    private static final String SITE_KEY_PARAM = "siteKey";
    private static final String USER_AGENT_PARAM = "userAgent";
    private static final String USER_IP_ADDRESS_PARAM = "userIpAddress";
    private static final String EXPECTED_ACTION_PARAM = "expectedAction";
    private static final String SITE_VERIFY_URL = "https://www.google.com/recaptcha/api/siteverify";
    private static final String ENTERPRISE_SITE_VERIFY_URL = "https://recaptchaenterprise.googleapis.com/v1/projects/%s/assessments?key=%s";
    private final String captchaResponse;
    private final String secretKey;
    public static final String G_RECAPTCHA_RESPONSE = "g-recaptcha-response";

    public CaptchaServerSideRequestHelper(String captchaResponse, String secretKey) {
        this.captchaResponse = captchaResponse;
        this.secretKey = secretKey;
    }

    public Map<String, Object> makeValidationRequest() throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Validating reCAPTCHA.");
        }
        try {
            HttpPost httpPost = new HttpPost(SITE_VERIFY_URL);
            LinkedList<BasicNameValuePair> params = new LinkedList<BasicNameValuePair>();
            params.add(new BasicNameValuePair(SECRET_PARAM, this.secretKey));
            params.add(new BasicNameValuePair(RESPONSE_PARAM, this.captchaResponse));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = this.doRequest((HttpRequestBase)httpPost);
            HttpEntity respEntity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)respEntity, (Charset)Consts.UTF_8);
            return JsonUtils.getInstance().readToMap(responseString);
        }
        catch (JsonProcessingException e) {
            this.log.debug((Object)("Error validating reCAPTCHA. Unable to parse response: " + e.getMessage()));
            throw e;
        }
        catch (IOException e) {
            this.log.debug((Object)"Error validating reCAPTCHA. Unable to connect to https://www.google.com/recaptcha/api/siteverify");
            throw e;
        }
    }

    public Map<String, Object> makeEnterpriseValidationRequest(String projectId, String token, String siteKey, String userAgent, String userIpAddress, String expectedAction, boolean continueAfterFail, String fallbackPolicyDecisionValue) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Validating Enterprise reCAPTCHA.");
        }
        try {
            String projectIdEncoded = URLEncoder.encode(projectId, StandardCharsets.UTF_8);
            String secretKeyEncoded = URLEncoder.encode(this.secretKey, StandardCharsets.UTF_8);
            HttpPost httpPost = new HttpPost(String.format(ENTERPRISE_SITE_VERIFY_URL, projectIdEncoded, secretKeyEncoded));
            JSONObject event = new JSONObject();
            event.put((Object)TOKEN_PARAM, (Object)token);
            event.put((Object)SITE_KEY_PARAM, (Object)siteKey);
            event.put((Object)USER_AGENT_PARAM, (Object)userAgent);
            event.put((Object)USER_IP_ADDRESS_PARAM, (Object)userIpAddress);
            event.put((Object)EXPECTED_ACTION_PARAM, (Object)expectedAction);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"event", (Object)event);
            StringEntity entity = new StringEntity(jsonObj.toString(), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = this.doRequest((HttpRequestBase)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                HttpEntity respEntity;
                this.log.debug((Object)("Error validating Enterprise ReCAPTCHA. HTTP status code: " + statusCode));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("CAPTCHA response: " + response));
                }
                if ((respEntity = response.getEntity()) != null) {
                    EntityUtils.consumeQuietly((HttpEntity)respEntity);
                }
                if (continueAfterFail) {
                    this.log.debug((Object)"Error occurred with ReCAPTCHA Enterprise service and 'Failure Mode' is set to 'Continuing with fallback policy decision'");
                    return JsonUtils.getInstance().readToMap("{\"failureMode\": \"Continue with fallback policy decision\", \"score\": \"" + fallbackPolicyDecisionValue + "\"}");
                }
                this.log.debug((Object)"Error occurred with ReCAPTCHA Enterprise service and 'Failure Mode' is set to 'Fail'");
                return null;
            }
            HttpEntity respEntity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)respEntity, (Charset)Consts.UTF_8);
            return JsonUtils.getInstance().readToMap(responseString);
        }
        catch (UnsupportedEncodingException e) {
            this.log.debug((Object)("Error encoding Enterprise reCAPTCHA URL: " + e.getMessage()));
            throw e;
        }
        catch (JsonProcessingException e) {
            this.log.debug((Object)("Error validating Enterprise reCAPTCHA. Unable to parse response: " + e.getMessage()));
            throw e;
        }
        catch (IOException e) {
            this.log.debug((Object)("Error validating Enterprise reCAPTCHA. An IOException has occurred: " + e.getMessage()));
            throw e;
        }
    }

    private HttpResponse doRequest(HttpRequestBase request) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending " + request.getMethod() + " request to " + request.getURI()));
        }
        try {
            CloseableHttpClient client = HttpConnectionPoolingManager.getInstance().getDefaultClient();
            return client.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            this.log.debug((Object)("Error sending " + request.getMethod() + " request to " + request.getURI() + ": " + e.getMessage()));
            throw e;
        }
    }
}

