/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.captcha;

import com.pingidentity.captcha.CaptchaServerSideRequestHelper;
import com.pingidentity.captcha.ReCaptchaV2InvisiblePluginHelper;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.captchaprovider.CaptchaProviderDescriptor;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.util.log.AttributeMap;

public class ReCaptchaV2InvisiblePlugin
implements CaptchaProvider {
    public static final String TYPE = "reCAPTCHA v2 Invisible";
    private static final String CAPTCHA_CHALLENGE_TIMESTAMP_CONTRACT_ATTRIBUTE = "captchaChallengeTime";
    public static final String SITE_KEY_ATTRIBUTE = "siteKey";
    private static final String CAPTCHA_RESPONSE = "captchaResponse";
    private static final String SUCCESS_STATUS_RESPONSE = "success";
    private static final String CHALLENGE_TS_RESPONSE = "challenge_ts";
    private final Log log = LogFactory.getLog(this.getClass());
    private final PluginDescriptor pluginDescriptor;
    private Configuration configuration;

    public ReCaptchaV2InvisiblePlugin() {
        HashSet<String> attributeContract = new HashSet<String>(Collections.singleton(CAPTCHA_CHALLENGE_TIMESTAMP_CONTRACT_ATTRIBUTE));
        this.pluginDescriptor = new CaptchaProviderDescriptor(TYPE, (Plugin)this, attributeContract, ReCaptchaV2InvisiblePluginHelper.createGuiConfigDescriptor(), VersionUtil.getVersion());
    }

    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public String getJavaScriptFileName() {
        return StringUtils.defaultIfEmpty((String)this.configuration.getFieldValue("JavaScript File Name"), (String)"recaptcha-v2-invisible.js");
    }

    public Map<String, Object> getCaptchaAttributes(CaptchaContext captchaContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(SITE_KEY_ATTRIBUTE, this.configuration.getFieldValue("Site Key"));
        return attributes;
    }

    public CaptchaResult validateCaptcha(CaptchaContext captchaContext) {
        String captchaResponse = this.getCaptchaResponse(captchaContext);
        if (StringUtils.isBlank((String)captchaResponse)) {
            this.log.debug((Object)"No CAPTCHA response returned.");
            return CaptchaResult.createInvalidResult(null);
        }
        try {
            CaptchaServerSideRequestHelper captchaServerSideRequestHelper = new CaptchaServerSideRequestHelper(captchaResponse, this.configuration.getFieldValue("Secret Key"));
            Map<String, Object> response = captchaServerSideRequestHelper.makeValidationRequest();
            AttributeMap captchaResult = new AttributeMap();
            captchaResult.put(CAPTCHA_CHALLENGE_TIMESTAMP_CONTRACT_ATTRIBUTE, AttrValueSupport.make((Object)response.get(CHALLENGE_TS_RESPONSE)));
            boolean success = Boolean.TRUE.equals(response.get(SUCCESS_STATUS_RESPONSE));
            if (!success) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("reCAPTCHA response: " + response));
                }
                return CaptchaResult.createInvalidResult((AttributeMap)captchaResult);
            }
            return CaptchaResult.createValidResult((AttributeMap)captchaResult);
        }
        catch (IOException e) {
            this.log.debug((Object)"Error validating captcha", (Throwable)e);
            return CaptchaResult.createInvalidResult(null);
        }
    }

    private String getCaptchaResponse(CaptchaContext captchaContext) {
        HttpServletRequest request;
        AuthnApiSupport apiSupport = AuthnApiSupport.getDefault();
        if (apiSupport.isApiRequest(request = captchaContext.getRequest()) && request.getMethod().equals("POST")) {
            try {
                Map requestBody = apiSupport.deserializeAsMap(request);
                Object captchaResponseFromBody = requestBody.get(CAPTCHA_RESPONSE);
                if (captchaResponseFromBody instanceof String) {
                    return (String)captchaResponseFromBody;
                }
                this.log.debug((Object)"CAPTCHA response not of expected type.");
                return null;
            }
            catch (IOException e) {
                this.log.debug((Object)"Unable to deserialize authN API response", (Throwable)e);
                return null;
            }
        }
        return captchaContext.getRequest().getParameter("g-recaptcha-response");
    }
}

