/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.captcha;

import com.pingidentity.sdk.GuiConfigDescriptor;
import java.util.Collections;
import java.util.LinkedList;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.CaptchaSettings;

public class ReCaptchaV2InvisiblePluginHelper {
    private static final String DESCRIPTION = "Configure the server to use reCAPTCHA v2 Invisible.";
    static final String SITE_KEY_NAME = "Site Key";
    private static final String SITE_KEY_DESC = "The site key assigned to your account by Google.";
    static final String SECRET_KEY_NAME = "Secret Key";
    private static final String SECRET_KEY_DESC = "The secret key assigned to your account by Google for communication between PingFederate and reCAPTCHA.";
    static final String DEFAULT_JAVASCRIPT_FILENAME = "recaptcha-v2-invisible.js";
    static final String JAVASCRIPT_FILENAME_NAME = "JavaScript File Name";
    private static final String JAVASCRIPT_FILE_NAME_DESC = "The JavaScript file name to be loaded for reCAPTCHA. The default value is: recaptcha-v2-invisible.js";

    private ReCaptchaV2InvisiblePluginHelper() {
    }

    public static GuiConfigDescriptor createGuiConfigDescriptor() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor(DESCRIPTION);
        TextFieldDescriptor siteKey = new TextFieldDescriptor(SITE_KEY_NAME, SITE_KEY_DESC);
        siteKey.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)siteKey);
        TextFieldDescriptor secretKey = new TextFieldDescriptor(SECRET_KEY_NAME, SECRET_KEY_DESC, true);
        secretKey.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)secretKey);
        TextFieldDescriptor javaScriptFileName = new TextFieldDescriptor(JAVASCRIPT_FILENAME_NAME, JAVASCRIPT_FILE_NAME_DESC);
        javaScriptFileName.setDefaultValue(DEFAULT_JAVASCRIPT_FILENAME);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)javaScriptFileName);
        return guiConfigDescriptor;
    }

    public static Configuration toConfiguration(CaptchaSettings captchaSettings) {
        if (captchaSettings == null) {
            return new Configuration();
        }
        LinkedList<Field> fieldList = new LinkedList<Field>();
        fieldList.add(new Field(SITE_KEY_NAME, captchaSettings.getSiteKey()));
        fieldList.add(new Field(SECRET_KEY_NAME, captchaSettings.getSecretKey()));
        fieldList.add(new Field(JAVASCRIPT_FILENAME_NAME, DEFAULT_JAVASCRIPT_FILENAME));
        return new Configuration(fieldList, Collections.emptyList(), Collections.emptyList());
    }

    public static CaptchaSettings toCaptchaSettings(Configuration configuration) {
        CaptchaSettings captchaSettings = new CaptchaSettings();
        captchaSettings.setSiteKey(configuration.getFieldValue(SITE_KEY_NAME));
        captchaSettings.setSecretKey(configuration.getFieldValue(SECRET_KEY_NAME));
        return captchaSettings;
    }
}

