/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.event.impl;

import com.pingidentity.common.event.Event;
import com.pingidentity.common.event.EventListener;
import com.pingidentity.common.event.EventService;
import com.pingidentity.common.event.EventType;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ChangePasswordEmailNotificationEventListener
implements EventListener {
    private static ChangePasswordEmailNotificationEventListener instance = new ChangePasswordEmailNotificationEventListener();
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String FIRST_NAME = "FIRST_NAME";
    private static final String USERNAME_PARAM = "USERNAME";
    private static final String TRANSACTION_ID = "TransactionId";
    private static final String ENTITY_ID = "entityId";
    private static final String EXTENDED_PROPERTIES = "extendedProperties";
    private static final String USER_ATTRIBUTES = "userAttributes";

    private ChangePasswordEmailNotificationEventListener() {
        EventService.getService().registerEventListener(EventType.PASSWORD_CHANGE, this);
    }

    @Override
    public void onEvent(Event event) {
        if (event.getEventType().equals((Object)EventType.PASSWORD_CHANGE) && event.getEventParams() != null) {
            String firstName = this.getAttributeValue(event.getEventParams(), "givenName");
            String emailAddress = this.getAttributeValue(event.getEventParams(), "mail");
            String templateName = this.getAttributeValue(event.getEventParams(), "template_name");
            String uname = this.getAttributeValue(event.getEventParams(), "username");
            Locale locale = (Locale)event.getEventParams().get("locale");
            String adapterId = (String)event.getEventParams().get("adapterId");
            String pcvId = (String)event.getEventParams().get("pcvId");
            String notificationPublisherId = (String)event.getEventParams().get("notificationPublisher");
            String transactionId = (String)event.getEventParams().get(TRANSACTION_ID);
            String entityId = (String)event.getEventParams().get(ENTITY_ID);
            Object extendedProperties = event.getEventParams().get(EXTENDED_PROPERTIES);
            Object userAttributes = event.getEventParams().get(USER_ATTRIBUTES);
            if (StringUtils.isBlank((String)emailAddress)) {
                this.log.debug((Object)("Unable to send " + event.getEventType().getEventName() + " email notification to user '" + uname + "' as the email address is unavailable."));
            } else if (StringUtils.isBlank((String)templateName)) {
                this.log.error((Object)(" Unable to send email for " + event.getEventType().getEventName() + " event to " + uname + " for " + emailAddress + ". Template name unavailable."));
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (StringUtils.isBlank((String)firstName)) {
                    params.put(FIRST_NAME, "");
                } else {
                    params.put(FIRST_NAME, " " + firstName);
                }
                params.put("ADAPTER_ID", adapterId);
                params.put("PCV_ID", pcvId);
                params.put(USERNAME_PARAM, uname);
                params.put(TRANSACTION_ID, transactionId);
                params.put(ENTITY_ID, entityId);
                params.put(EXTENDED_PROPERTIES, extendedProperties);
                params.put(USER_ATTRIBUTES, userAttributes);
                if (emailAddress.contains(",")) {
                    String email = emailAddress.split(",")[0];
                    this.sendEmail(email, templateName, params, locale, notificationPublisherId);
                } else {
                    this.sendEmail(emailAddress, templateName, params, locale, notificationPublisherId);
                }
            }
        }
    }

    private void sendEmail(String emailAddress, String templateName, Map<String, Object> params, Locale locale, String notificationPublisherId) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("com.pingidentity.notification.config.destination.address", emailAddress);
        config.put("com.pingidentity.notification.config.template.name", templateName);
        config.put("com.pingidentity.notification.config.locale", locale.toLanguageTag());
        MgmtFactory.getNotificationDispatcherManager().dispatchNotification(notificationPublisherId, NotificationEventType.PASSWORD_CHANGED.toString(), params, config);
    }

    private String getAttributeValue(Map<String, Object> params, String attributeName) {
        if (params.get(attributeName) != null) {
            return ((AttributeValue)params.get(attributeName)).getValue();
        }
        return "";
    }

    public static EventListener getListener() {
        return instance;
    }
}

