/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.security;

import com.pingidentity.common.security.AccountLockingService;
import java.io.Serializable;

public interface LockingService {
    public void logFailedLogin(String var1);

    public void logFailedPassword(String var1);

    public void logMaliciousAction(String var1);

    public boolean isLocked(String var1);

    public boolean isLockedWithMaxMaliciousActions(String var1);

    public boolean isLocked(String var1, int var2, int var3);

    public boolean isLocked(IsLockedRequest var1);

    public void clearFailedLogins(String var1);

    public void clearMaliciousActions(String var1);

    public static class IsLockedRequest
    implements Serializable {
        private String key;
        private FailedLoginType loginType;
        private boolean useDefaultLimits;
        private int maxFailedLogins;
        private int lockoutPeriod;

        public IsLockedRequest(String key, FailedLoginType loginType, boolean useDefaultLimits, int maxFailedLogins, int lockoutPeriod) {
            this.key = AccountLockingService.normalizeKey(key);
            this.loginType = loginType;
            this.useDefaultLimits = useDefaultLimits;
            this.maxFailedLogins = maxFailedLogins;
            this.lockoutPeriod = lockoutPeriod;
        }

        public String getKey() {
            return this.key;
        }

        public FailedLoginType getLoginType() {
            return this.loginType;
        }

        public boolean isUseDefaultLimits() {
            return this.useDefaultLimits;
        }

        public int getMaxFailedLogins() {
            return this.maxFailedLogins;
        }

        public int getLockoutPeriod() {
            return this.lockoutPeriod;
        }

        public static class Builder {
            private String key;
            private FailedLoginType loginType;
            private int maxFailedLogins = 0;
            private int lockoutPeriod = 0;

            public Builder(String key) {
                this.key = key;
            }

            public Builder loginType(FailedLoginType loginType) {
                this.loginType = loginType;
                return this;
            }

            public Builder maxFailedLogins(int maxFailedLogins) {
                this.maxFailedLogins = maxFailedLogins;
                return this;
            }

            public Builder lockoutPeriod(int lockoutPeriod) {
                this.lockoutPeriod = lockoutPeriod;
                return this;
            }

            public IsLockedRequest build() {
                boolean useDefaultLimits = this.maxFailedLogins == 0 && this.lockoutPeriod == 0;
                return new IsLockedRequest(this.key, this.loginType, useDefaultLimits, this.maxFailedLogins, this.lockoutPeriod);
            }
        }
    }

    public static enum FailedLoginType {
        USERNAME,
        PASSWORD;

    }
}

