/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.io.File;
import java.util.List;
import java.util.TimerTask;

public abstract class AbstractFileWatcher
extends TimerTask {
    private List<File> _files;
    private long _lastModified;

    public AbstractFileWatcher(List<File> files) {
        this._files = files;
        this._lastModified = this.getLatestLastModified();
    }

    @Override
    public void run() {
        long lastLastModified = this.getLatestLastModified();
        if (this._lastModified != lastLastModified) {
            this._lastModified = lastLastModified;
            this.onModified();
        }
    }

    protected abstract void onModified();

    protected long getLatestLastModified() {
        long result = 0L;
        for (File file : this._files) {
            if (file.lastModified() <= result) continue;
            result = file.lastModified();
        }
        return result;
    }
}

