/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.sdk.PluginFipsStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;

public final class AdapterUtils {
    private static final Log log = LogFactory.getLog(AdapterUtils.class);
    private static final String COMPOSITE_ADAPTER_CLASS = "com.pingidentity.pf.adapters.composite.CompositeAdapter";
    private static ConfigStore compositeAdapterConfigStore = ConfigStoreFarm.getConfig("com.pingidentity.pf.adapters.composite.CompositeAdapter");
    private static final String PLUGIN_FIPS_CONFIG = "plugin-fips-config";
    private static final String KEY_PLUGIN_FIPS_STATUS = "plugin-fips-status";
    private static ConfigStore pluginFipsInfoConfigStore = ConfigStoreFarm.getConfig("plugin-fips-config");
    public static final String HTML_FORM_IDP_ADAPTER_TYPE_DESCRIPTION = "HTML Form IdP Adapter";

    private AdapterUtils() {
    }

    public static boolean adapterNeedsPathRandomization(String adapterFullClassName) {
        List<String> defaultValue = Arrays.asList("IWAAuthenticationAdapter", "KerberosAuthenticationAdapter");
        List<String> adaptersWithPathRandomization = compositeAdapterConfigStore.getListValue("AdaptersWithPathRandomization", defaultValue);
        return adaptersWithPathRandomization.stream().anyMatch(adapterFullClassName::contains);
    }

    public static boolean adapterNeedsPathRandomization(IdpAuthnAdapterInstance idpAuthnAdapterInstance) {
        String adapterFullClassName = idpAuthnAdapterInstance.getDescriptor().getAdapterClassName();
        return AdapterUtils.adapterNeedsPathRandomization(adapterFullClassName);
    }

    public static boolean isHtmlFormAdapter(IdpAuthnAdapterInstance idpAuthnAdapter) {
        return Optional.ofNullable(idpAuthnAdapter).map(IdpAuthnAdapterInstance::getDescriptor).filter(idpAuthnAdapterDescriptor -> HTML_FORM_IDP_ADAPTER_TYPE_DESCRIPTION.equals(idpAuthnAdapterDescriptor.getType())).isPresent();
    }

    public static PluginFipsStatus getPluginFipsStatus(String className, Map<String, Object> pluginMetadata) {
        Map fipsStatusMap;
        if (pluginMetadata.containsKey("FipsStatus")) {
            Object fipsStatusObj = pluginMetadata.get("FipsStatus");
            if (fipsStatusObj instanceof PluginFipsStatus) {
                return (PluginFipsStatus)fipsStatusObj;
            }
            if (fipsStatusObj instanceof String) {
                try {
                    return PluginFipsStatus.valueOf((String)((String)fipsStatusObj));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            log.debug((Object)("Plugin " + className + " has invalid value for metadata key FipsStatus: " + fipsStatusObj));
        }
        if ((fipsStatusMap = pluginFipsInfoConfigStore.getMapValue(KEY_PLUGIN_FIPS_STATUS, Collections.emptyMap())).containsKey(className)) {
            String fipsStatusStr = (String)fipsStatusMap.get(className);
            try {
                return PluginFipsStatus.valueOf((String)fipsStatusStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)("Invalid FIPS status for " + className + " in plugin-fips-config.xml: " + fipsStatusStr));
            }
        }
        return PluginFipsStatus.NOT_ASSESSED;
    }
}

