/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.io.Serializable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Cache<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<K, V> delegate;
    private Map<K, Long> timestampsByKey;
    private SortedMap<Long, Collection<K>> keysByTimestamp;
    private long expiryPeriodMillis;
    private boolean expireByAccessOrder = false;
    private int maxSize = Integer.MAX_VALUE;
    private Clock clock;

    public Cache(long expiryPeriodMillis) {
        this.initialize(expiryPeriodMillis, Integer.MAX_VALUE, 1024, 0.75f, false);
    }

    public Cache(long expiryPeriodMillis, int maxSize) {
        this.initialize(expiryPeriodMillis, maxSize, 1024, 0.75f, false);
    }

    public Cache(long expiryPeriodMillis, int maxSize, int initialCapacity) {
        this.initialize(expiryPeriodMillis, maxSize, initialCapacity, 0.75f, false);
    }

    public Cache(long expiryPeriodMillis, int maxSize, int initialCapacity, float loadFactor) {
        this.initialize(expiryPeriodMillis, maxSize, initialCapacity, loadFactor, false);
    }

    public Cache(long expiryPeriodMillis, int maxSize, int initialCapacity, float loadFactor, boolean expireByAccessOrder) {
        this.initialize(expiryPeriodMillis, maxSize, initialCapacity, loadFactor, expireByAccessOrder);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + (this.expireByAccessOrder ? 1231 : 1237);
        result = 31 * result + (int)(this.expiryPeriodMillis ^ this.expiryPeriodMillis >>> 32);
        result = 31 * result + (this.keysByTimestamp == null ? 0 : this.keysByTimestamp.hashCode());
        result = 31 * result + this.maxSize;
        result = 31 * result + (this.timestampsByKey == null ? 0 : this.timestampsByKey.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cache other = (Cache)obj;
        if (this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate)) {
            return false;
        }
        if (this.expireByAccessOrder != other.expireByAccessOrder) {
            return false;
        }
        if (this.expiryPeriodMillis != other.expiryPeriodMillis) {
            return false;
        }
        if (this.keysByTimestamp == null ? other.keysByTimestamp != null : !this.keysByTimestamp.equals(other.keysByTimestamp)) {
            return false;
        }
        if (this.maxSize != other.maxSize) {
            return false;
        }
        return !(this.timestampsByKey == null ? other.timestampsByKey != null : !this.timestampsByKey.equals(other.timestampsByKey));
    }

    protected void initialize(long expiryPeriodMillis, int maxSize, int initialCapacity, float loadFactor, boolean expireByAccessOrder) {
        this.delegate = new HashMap(initialCapacity, loadFactor);
        this.timestampsByKey = new HashMap<K, Long>(initialCapacity, loadFactor);
        this.keysByTimestamp = new TreeMap<Long, Collection<K>>();
        this.expiryPeriodMillis = expiryPeriodMillis;
        this.maxSize = maxSize;
        this.expireByAccessOrder = expireByAccessOrder;
        this.clock = Clock.systemDefaultZone();
    }

    public void setClock(Clock clock) {
        if (!(clock instanceof Serializable)) {
            throw new RuntimeException("The clock must be serializable");
        }
        this.clock = clock;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.get(key, false);
    }

    public V getIfNotExpired(K key) {
        return this.get(key, true);
    }

    public boolean tryPutWithTimestamp(K key, V value, long timestamp) {
        long currentTimeMillis = this.getCurrentTimeMillis();
        if (this.isExpired(timestamp, currentTimeMillis)) {
            return false;
        }
        if (!this.delegate.containsKey(key) && this.delegate.size() >= this.maxSize && timestamp <= this.keysByTimestamp.firstKey()) {
            return false;
        }
        this.addEntry(key, value, timestamp, true);
        this.checkPurgeEntries(currentTimeMillis);
        return true;
    }

    public long getTimestampForKey(K key) {
        Long timestamp = this.timestampsByKey.get(key);
        if (timestamp == null) {
            return 0L;
        }
        return timestamp;
    }

    public Entry<K, V> getEntry(K key) {
        V value = this.delegate.get(key);
        if (value == null && !this.delegate.containsKey(key)) {
            return null;
        }
        Long timestamp = this.timestampsByKey.get(key);
        return new Entry<K, V>(key, value, timestamp != null ? timestamp : 0L);
    }

    @Override
    public V put(K key, V value) {
        V result = this.addEntry(key, value, this.getCurrentTimeMillis(), false);
        this.checkPurgeEntries();
        return result;
    }

    @Override
    public V remove(Object key) {
        return this.removeEntry(key, false, this.getCurrentTimeMillis());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        long currentTimeMillis = this.getCurrentTimeMillis();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.addEntry(entry.getKey(), entry.getValue(), currentTimeMillis, false);
        }
        this.checkPurgeEntries();
    }

    @Override
    public void clear() {
        this.timestampsByKey.clear();
        this.keysByTimestamp.clear();
        this.delegate.clear();
        this.onClear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.delegate.entrySet());
    }

    protected void onClear() {
    }

    protected void onEntryPurged(K key, V value, boolean expired, long timestamp) {
    }

    protected V addEntry(K key, V value, long timestamp, boolean forceUpdateTimestamp) {
        if (forceUpdateTimestamp || this.expireByAccessOrder || !this.delegate.containsKey(key)) {
            this.updateTimestampForKey(key, timestamp);
        }
        V result = this.delegate.put(key, value);
        this.onEntryUpdated(key, value);
        return result;
    }

    protected void onEntryUpdated(K key, V value) {
    }

    protected V removeEntry(Object key, boolean purge, long currentTime) {
        boolean exists = this.delegate.containsKey(key);
        Long timestamp = this.removeTimestampForKey(key);
        V value = this.delegate.remove(key);
        if (exists && purge) {
            this.onEntryPurged(key, value, this.isExpired(timestamp, currentTime), timestamp);
        }
        if (exists) {
            this.onEntryRemoved(key, value);
        }
        return value;
    }

    protected void onEntryRemoved(K key, V value) {
    }

    protected void checkPurgeEntries() {
        this.checkPurgeEntries(this.getCurrentTimeMillis());
    }

    protected void checkPurgeEntries(long currentTime) {
        ArrayList<K> keysToRemove = new ArrayList<K>();
        Iterator<Map.Entry<Long, Collection<K>>> iterator = this.keysByTimestamp.entrySet().iterator();
        boolean done = false;
        block0: while (iterator.hasNext() && !done) {
            Map.Entry<Long, Collection<K>> entry = iterator.next();
            if (this.isExpired(entry.getKey(), currentTime)) {
                keysToRemove.addAll(entry.getValue());
                continue;
            }
            for (K key : entry.getValue()) {
                if (this.delegate.size() - keysToRemove.size() > this.maxSize) {
                    keysToRemove.add(key);
                    continue;
                }
                done = true;
                continue block0;
            }
        }
        for (Object key : keysToRemove) {
            this.removeEntry(key, true, currentTime);
        }
    }

    protected long getCurrentTimeMillis() {
        return this.clock.millis();
    }

    protected void updateTimestampForKey(K key, long timestamp) {
        Long timestampObj = timestamp;
        this.removeTimestampForKey(key);
        this.timestampsByKey.put(key, timestampObj);
        ArrayList<K> keys = (ArrayList<K>)this.keysByTimestamp.get(timestampObj);
        if (keys == null) {
            keys = new ArrayList<K>(2);
            this.keysByTimestamp.put(timestampObj, keys);
        }
        keys.add(key);
    }

    protected Long removeTimestampForKey(K key) {
        Long timestamp = this.timestampsByKey.remove(key);
        if (timestamp != null) {
            Collection keys = (Collection)this.keysByTimestamp.get(timestamp);
            if (keys != null) {
                keys.remove(key);
                if (keys.isEmpty()) {
                    this.keysByTimestamp.remove(timestamp);
                }
            }
            return timestamp;
        }
        return null;
    }

    protected int getTimestampsByKeySize() {
        return this.timestampsByKey.size();
    }

    protected int getKeysByTimstampSize() {
        return this.keysByTimestamp.size();
    }

    protected int getDeepKeysByTimestampSize() {
        return this.keysByTimestamp.values().stream().mapToInt(Collection::size).sum();
    }

    private V get(K key, boolean checkExpiry) {
        long currentTimeMillis;
        long timestamp;
        V value = this.delegate.get(key);
        if (value == null && !this.delegate.containsKey(key)) {
            return null;
        }
        if (checkExpiry && this.isExpired(timestamp = this.getTimestampForKey(key), currentTimeMillis = this.getCurrentTimeMillis())) {
            return null;
        }
        if (this.expireByAccessOrder) {
            this.updateTimestampForKey(key, this.getCurrentTimeMillis());
        }
        return value;
    }

    private boolean isExpired(long timestamp, long currentTimeMillis) {
        return this.hasExpiry() && timestamp + this.expiryPeriodMillis < currentTimeMillis;
    }

    private boolean hasExpiry() {
        return this.expiryPeriodMillis > -1L;
    }

    public static class Entry<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private K key;
        private V value;
        private long timestamp;

        public Entry(K key, V value, long timestamp) {
            this.key = key;
            this.value = value;
            this.timestamp = timestamp;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

