/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.monitoring.metrics.Meters;
import java.time.Clock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachePurgeBeforeExpiryTracker {
    private static final Log log = LogFactory.getLog(CachePurgeBeforeExpiryTracker.class);
    private static final int MILLIS_PER_MINUTE = 60000;
    private long expiryPeriodMillis;
    private String cacheName;
    private String counterId;
    private String remedyMessage;
    private float logIntervalMins = 15.0f;
    private long lastLogTimeMillis = 0L;
    private int numberOfEntriesPurged = 0;
    private double cumulativeTimeToExpiryMillis = 0.0;
    private Clock clock = Clock.systemDefaultZone();

    public CachePurgeBeforeExpiryTracker(long expiryPeriodMillis, String cacheName, String remedyMessage, float logIntervalMins) {
        this.expiryPeriodMillis = expiryPeriodMillis;
        this.cacheName = cacheName;
        this.remedyMessage = remedyMessage;
        this.logIntervalMins = logIntervalMins;
    }

    public CachePurgeBeforeExpiryTracker(long expiryPeriodMillis, String cacheName, String remedyMessage, float logIntervalMins, String counterId) {
        this(expiryPeriodMillis, cacheName, remedyMessage, logIntervalMins);
        this.counterId = counterId;
    }

    public void trackEntryPurgedBeforeExpiry(long timestamp) {
        this.cumulativeTimeToExpiryMillis += (double)this.getTimeToExpiryMillis(timestamp, this.clock.millis());
        ++this.numberOfEntriesPurged;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.cacheName + ": purged an entry before it had expired"));
        }
        if (this.counterId != null) {
            Meters.getCounter(this.counterId, new String[0]).increment();
        }
    }

    public void checkLogEntriesPurgedBeforeExpiry() {
        long lastLoggingInterval;
        long loggingIntervalMillis;
        long currentTime = this.clock.millis();
        long currentLoggingInterval = currentTime / (loggingIntervalMillis = (long)(this.logIntervalMins * 60000.0f));
        if (currentLoggingInterval != (lastLoggingInterval = this.lastLogTimeMillis / loggingIntervalMillis)) {
            if (this.numberOfEntriesPurged > 0 && currentLoggingInterval == lastLoggingInterval + 1L) {
                double averageTimeToExpiryMins = this.cumulativeTimeToExpiryMillis / (double)this.numberOfEntriesPurged / 60000.0;
                this.logEntriesPurgedBeforeExpiry(this.numberOfEntriesPurged, averageTimeToExpiryMins);
            }
            this.lastLogTimeMillis = currentTime;
            this.numberOfEntriesPurged = 0;
            this.cumulativeTimeToExpiryMillis = 0.0;
        }
    }

    protected void setClock(Clock clock) {
        this.clock = clock;
    }

    protected void logEntriesPurgedBeforeExpiry(int entriesPurged, double averageTimeToExpiryMins) {
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("%s: in the previous %s minute interval, %s entries were purged before they had expired. The average time until expiry was %.1f minutes.", this.cacheName, this.formatLogInterval(this.logIntervalMins), entriesPurged, averageTimeToExpiryMins));
            if (this.remedyMessage != null) {
                builder.append(" " + this.remedyMessage);
            }
            log.info((Object)builder.toString());
        }
    }

    private long getTimeToExpiryMillis(long timestamp, long currentTimeMillis) {
        return timestamp + this.expiryPeriodMillis - currentTimeMillis;
    }

    private String formatLogInterval(float logInterval) {
        if (logInterval == (float)((int)logInterval)) {
            return Integer.toString((int)logInterval);
        }
        return Float.toString(logInterval);
    }
}

