/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.crypto.HashedPassword;
import com.unboundid.util.StaticUtils;
import java.util.Arrays;
import java.util.Date;
import org.sourceid.common.IDGenerator;

public final class CodeGenerationUtil {
    private CodeGenerationUtil() {
    }

    public static boolean isExpectedPassword(char[] password, String encodedText) {
        try {
            HashedPassword hashedPassword = HashedPassword.fromEncodedText(encodedText);
            boolean bl = hashedPassword.checkSecret(new String(password));
            return bl;
        }
        catch (Exception e) {
            throw new AssertionError("Error while hashing a password: " + e.getMessage(), e);
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    public static GeneratedCode generateOtp(int codeLength, String validCharacterSet) {
        String code = IDGenerator.rndAlphaNumericSpecialChars(codeLength, validCharacterSet);
        return CodeGenerationUtil.getGeneratedCode(code);
    }

    public static GeneratedCode generateSmsCode(int codeLength) {
        String code = IDGenerator.rndNumeric(codeLength);
        return CodeGenerationUtil.getGeneratedCode(code);
    }

    private static GeneratedCode getGeneratedCode(String code) {
        HashedPassword hashedPassword = HashedPassword.fromClearText(code);
        String encodedText = hashedPassword.toEncodedText();
        return new GeneratedCode(code, encodedText, StaticUtils.encodeGeneralizedTime((Date)new Date()));
    }

    public static class GeneratedCode {
        private final String code;
        private final String encodedCode;
        private final String timeGenerated;

        private GeneratedCode(String code, String encodedCode, String timeGenerated) {
            this.code = code;
            this.encodedCode = encodedCode;
            this.timeGenerated = timeGenerated;
        }

        public String getCode() {
            return this.code;
        }

        public String getEncodedCode() {
            return this.encodedCode;
        }

        public String getTimeGenerated() {
            return this.timeGenerated;
        }
    }
}

