/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.sdk.GuiConfigDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.HashedField;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.conf.internal.ConfigOverrideMetadata;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthorizationDetailProcessorInstance;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdentityStoreProvisionerInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConfigurablePluginInstance;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.SecretManagerInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;

public class ConfigurationUtil {
    private static final ConfigStore config = ConfigStoreFarm.getConfig(ConfigurationUtil.class.getName());
    private static Function<FieldDescriptor, Field> toDefaultField = descriptor -> {
        String fieldValue = null;
        if (descriptor.getDefaultForLegacyConfig() != null) {
            fieldValue = descriptor.getDefaultForLegacyConfig();
        } else if (descriptor.getDefaultValue() != null) {
            fieldValue = descriptor.getDefaultValue();
        }
        if (StringUtils.isBlank((String)fieldValue) && descriptor instanceof CheckBoxFieldDescriptor) {
            fieldValue = Boolean.FALSE.toString();
        }
        if (descriptor instanceof HashedTextFieldDescriptor) {
            return new HashedField(descriptor.getName(), null, fieldValue);
        }
        return new Field(descriptor.getName(), fieldValue);
    };

    public static Configuration createRuntimeCompositeConfiguration(ConfigurablePluginInstance childInstance) {
        return ConfigurationUtil.createCompositeConfiguration(childInstance, ConfigurationUtil.determinePluginManager(childInstance), true);
    }

    public static Configuration createAdminCompositeConfiguration(ConfigurablePluginInstance childInstance) {
        return ConfigurationUtil.createAdminCompositeConfiguration(childInstance, ConfigurationUtil.determinePluginManager(childInstance));
    }

    public static Configuration createAdminCompositeConfiguration(ConfigurablePluginInstance childInstance, PluginManager<?, ?> pluginMgr) {
        return ConfigurationUtil.createCompositeConfiguration(childInstance, pluginMgr, false);
    }

    private static Configuration createCompositeConfiguration(ConfigurablePluginInstance childInstance, PluginManager<?, ?> pluginMgr, boolean isRunTimeCompositeConfiguration) {
        boolean configureFieldDefaultsForChildInstances = config.getBooleanValue("applyFieldDefaultsToChildInstancesAtRuntime", true);
        LinkedList<ConfigurablePluginInstance> ancestors = ConfigurationUtil.getAncestors(childInstance, pluginMgr);
        if (ancestors.size() <= 1 && isRunTimeCompositeConfiguration) {
            return childInstance.getConfiguration();
        }
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        LinkedHashMap<String, Field> advancedFields = new LinkedHashMap<String, Field>();
        LinkedHashMap<String, Table> tables = new LinkedHashMap<String, Table>();
        Set<String> extendedAttrNames = null;
        Set<Object> multiValuedAttributes = new HashSet();
        for (ConfigurablePluginInstance instance : ancestors) {
            Configuration instanceConfig = instance.getConfiguration();
            for (Field field : instanceConfig.getFields()) {
                fields.put(field.getName(), field);
            }
            for (Field field : instanceConfig.getAdvancedFields().getFields()) {
                advancedFields.put(field.getName(), field);
            }
            if (instanceConfig.getTables() != null) {
                for (Table table : instanceConfig.getTables()) {
                    LinkedList rows = new LinkedList();
                    table.getRows().forEach(row -> rows.add(new Row(row.getFields(), row.isDefaultRow())));
                    tables.put(table.getName(), new Table(table.getName(), rows));
                }
            }
            if (instance.getExtendedContractAttributes() != null) {
                extendedAttrNames = instance.getExtendedContractAttributes();
            }
            if (instance.getMultiValuedContractAttributes() == null) continue;
            multiValuedAttributes = instance.getMultiValuedContractAttributes();
        }
        if (configureFieldDefaultsForChildInstances || !isRunTimeCompositeConfiguration) {
            ConfigurablePluginInstance instance = (ConfigurablePluginInstance)ancestors.get(0);
            ConfigurationUtil.addMissingFields(instance, fields, advancedFields);
            ConfigurationUtil.addMissingTableFields(instance, tables);
        }
        Configuration compositeConfig = new Configuration(new ArrayList(fields.values()), new ArrayList(tables.values()), new ArrayList(advancedFields.values()));
        compositeConfig.setId(childInstance.getId());
        if (extendedAttrNames != null) {
            compositeConfig.setAdditionalAttrNames(extendedAttrNames);
        }
        compositeConfig.setMultiValuedAttributes(multiValuedAttributes);
        return compositeConfig;
    }

    private static void addMissingFields(ConfigurablePluginInstance instance, Map<String, Field> fields, Map<String, Field> advancedFields) {
        fields.putAll(instance.getGuiDescriptor().getFields().stream().filter(descriptor -> !fields.containsKey(descriptor.getName())).map(toDefaultField).collect(Collectors.toMap(Field::getName, Function.identity())));
        advancedFields.putAll(instance.getGuiDescriptor().getAdvancedFields().stream().filter(descriptor -> !advancedFields.containsKey(descriptor.getName())).map(toDefaultField).collect(Collectors.toMap(Field::getName, Function.identity())));
    }

    private static void addMissingTableFields(ConfigurablePluginInstance instance, Map<String, Table> tables) {
        instance.getGuiDescriptor().getTables().stream().filter(tableDescriptor -> tables.get(tableDescriptor.getName()) != null).forEach(tableDescriptor -> {
            Table table = (Table)tables.get(tableDescriptor.getName());
            tableDescriptor.getRowFields().forEach(fieldDescriptor -> table.getRows().forEach(row -> {
                boolean doesFieldExist = row.getFields().stream().anyMatch(field -> field.getName().equals(fieldDescriptor.getName()));
                if (!doesFieldExist) {
                    row.addField(toDefaultField.apply((FieldDescriptor)fieldDescriptor));
                }
            }));
        });
        instance.getGuiDescriptor().getTables().stream().filter(tableDescriptor -> tables.get(tableDescriptor.getName()) == null).forEach(tableDescriptor -> tables.put(tableDescriptor.getName(), new Table(tableDescriptor.getName(), new ArrayList())));
    }

    public static AttributeContract findEffectiveAttributeContract(ConfigurablePluginInstance childInstance, Set<String> immutableAttrs) {
        return ConfigurationUtil.findEffectiveAttributeContract(childInstance, immutableAttrs, ConfigurationUtil.determinePluginManager(childInstance));
    }

    public static AttributeContract findEffectiveAttributeContract(IdentityStoreProvisionerInstance childInstance, Set<String> immutableAttrs, ExtendedAttributesReader extAttrsReader) {
        return ConfigurationUtil.findEffectiveAttributeContract(childInstance, immutableAttrs, ConfigurationUtil.determinePluginManager(childInstance), extAttrsReader);
    }

    public static AttributeContract findEffectiveAttributeContract(ConfigurablePluginInstance childInstance, Set<String> immutableAttrs, PluginManager<?, ?> pluginMgr) {
        return ConfigurationUtil.findEffectiveAttributeContract(childInstance, immutableAttrs, pluginMgr, new ExtendedAttributesReader());
    }

    public static AttributeContract findEffectiveAttributeContract(ConfigurablePluginInstance childInstance, Set<String> immutableAttrs, PluginManager<?, ?> pluginMgr, ExtendedAttributesReader extAttrsReader) {
        LinkedList<ConfigurablePluginInstance> ancestors = ConfigurationUtil.getAncestors(childInstance, pluginMgr);
        AttributeContract attrContract = new AttributeContract(immutableAttrs);
        Set<String> mutableAttrs = null;
        Iterator<ConfigurablePluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            ConfigurablePluginInstance instance = reverseIt.next();
            Set<String> extAttrs = extAttrsReader.getExtendedAttributes(instance);
            if (extAttrs == null) continue;
            mutableAttrs = extAttrs;
            break;
        }
        if (mutableAttrs != null) {
            attrContract.setMutableAttributeNames(mutableAttrs);
        }
        return attrContract;
    }

    public static AttributeMapping findEffectiveAttributeMapForAdapter(IdpAuthnAdapterInstance instance) {
        return ConfigurationUtil.findAdapterWithEffectiveAttributeMap(instance).getAttributeMapping();
    }

    public static IdpAuthnAdapterInstance findAdapterWithEffectiveAttributeMap(IdpAuthnAdapterInstance adapter) {
        return ConfigurationUtil.findAdapterWithEffectiveAttributeMap(adapter, ConfigurationUtil.determinePluginManager(adapter));
    }

    public static IdpAuthnAdapterInstance findAdapterWithEffectiveAttributeMap(IdpAuthnAdapterInstance adapter, PluginManager<?, IdpAuthnAdapterInstance> adapterManager) {
        if (adapter.isInheritingAttributeMapping()) {
            String parentId = adapter.getParentId();
            return ConfigurationUtil.findAdapterWithEffectiveAttributeMap(adapterManager.getInstance(parentId), adapterManager);
        }
        return adapter;
    }

    public static <T extends ConfigurablePluginInstance> LinkedList<T> getAncestors(T childInstance, PluginManager<?, T> pluginMgr) {
        String parentId = childInstance.getParentId();
        LinkedList<T> ancestors = new LinkedList<T>();
        ancestors.add(childInstance);
        while (parentId != null && pluginMgr != null) {
            T parentInstance = pluginMgr.getInstance(parentId);
            if (parentInstance == null) {
                throw new IllegalStateException("Can't find plugin instance with the id: " + parentId);
            }
            parentId = parentInstance.getParentId();
            ancestors.addFirst(parentInstance);
        }
        return ancestors;
    }

    public static <T extends ConfigurablePluginInstance> List<String> getAncestorIDs(T childInstance, PluginManager<?, ?> pluginMgr) {
        ArrayList<String> ancestorIDs = new ArrayList<String>();
        LinkedList<ConfigurablePluginInstance> ancestors = ConfigurationUtil.getAncestors(childInstance, pluginMgr);
        for (ConfigurablePluginInstance ancestor : ancestors) {
            ancestorIDs.add(ancestor.getId());
        }
        return ancestorIDs;
    }

    private static <T extends ConfigurablePluginInstance> PluginManager<?, T> determinePluginManager(T childInstance) {
        if (childInstance instanceof IdpAuthnAdapterInstance) {
            return MgmtFactory.getIdpAdapterManager();
        }
        if (childInstance instanceof AuthnAdapterInstance) {
            return MgmtFactory.getSpAdapterManager();
        }
        if (childInstance instanceof TokenGeneratorInstance) {
            return MgmtFactory.getTokenGeneratorManager();
        }
        if (childInstance instanceof TokenProcessorInstance) {
            return MgmtFactory.getTokenProcessorManager();
        }
        if (childInstance instanceof PasswordCredentialValidatorInstance) {
            return MgmtFactory.getCredentialValidatorManager();
        }
        if (childInstance instanceof IdentityStoreProvisionerInstance) {
            return MgmtFactory.getIdentityStoreProvisionerManager();
        }
        if (childInstance instanceof BearerAccessTokenMgmtPluginInstance) {
            return MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        }
        if (childInstance instanceof SecretManagerInstance) {
            return MgmtFactory.getSecretManagerPluginManager();
        }
        if (childInstance instanceof AuthorizationDetailProcessorInstance) {
            return MgmtFactory.getAuthorizationDetailProcessorsPluginManager();
        }
        return null;
    }

    public static ConfigOverrideMetadata createConfigOverrideMetadata(Configuration currentConfig, Configuration compositeConfig, GuiConfigDescriptor guiDescriptor) {
        String fieldName;
        HashSet<String> overrideFieldSet = new HashSet<String>();
        HashSet<String> overrideAdvancedFieldSet = new HashSet<String>();
        HashSet<String> overrideTableSet = new HashSet<String>();
        for (Field field : currentConfig.getFields()) {
            overrideFieldSet.add(field.getName());
        }
        for (Field advancedField : currentConfig.getAdvancedFields().getFields()) {
            overrideAdvancedFieldSet.add(advancedField.getName());
        }
        if (currentConfig.getTables() != null) {
            for (Table table : currentConfig.getTables()) {
                overrideTableSet.add(table.getName());
            }
        }
        HashSet<String> configuredFieldSet = new HashSet<String>();
        HashSet<String> configuredAdvancedFieldSet = new HashSet<String>();
        HashSet<String> configuredTableSet = new HashSet<String>();
        for (Field field : compositeConfig.getFields()) {
            configuredFieldSet.add(field.getName());
        }
        for (Field advancedField : compositeConfig.getAdvancedFields().getFields()) {
            configuredAdvancedFieldSet.add(advancedField.getName());
        }
        if (compositeConfig.getTables() != null) {
            for (Table table : compositeConfig.getTables()) {
                configuredTableSet.add(table.getName());
            }
        }
        for (FieldDescriptor fieldDescriptor : guiDescriptor.getFields()) {
            fieldName = fieldDescriptor.getName();
            if (configuredFieldSet.contains(fieldName)) continue;
            overrideFieldSet.add(fieldName);
        }
        for (FieldDescriptor advFieldDescriptor : guiDescriptor.getAdvancedFields()) {
            fieldName = advFieldDescriptor.getName();
            if (configuredAdvancedFieldSet.contains(fieldName)) continue;
            overrideAdvancedFieldSet.add(fieldName);
        }
        for (TableDescriptor tableDescriptor : guiDescriptor.getTables()) {
            String tableName = tableDescriptor.getName();
            if (configuredTableSet.contains(tableName)) continue;
            overrideFieldSet.add(tableName);
        }
        return new ConfigOverrideMetadata(overrideFieldSet, overrideAdvancedFieldSet, overrideTableSet);
    }

    public static List<String> findEffectiveUniqueKeyFields(IdpAuthnAdapterInstance childInstance) {
        return ConfigurationUtil.findEffectiveUniqueKeyFields(childInstance, ConfigurationUtil.determinePluginManager(childInstance));
    }

    public static List<String> findEffectiveUniqueKeyFields(IdpAuthnAdapterInstance childInstance, PluginManager<?, IdpAuthnAdapterInstance> pluginMgr) {
        LinkedList<IdpAuthnAdapterInstance> ancestors = ConfigurationUtil.getAncestors(childInstance, pluginMgr);
        List<String> uniqueKeyFields = new LinkedList<String>();
        Iterator<IdpAuthnAdapterInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            IdpAuthnAdapterInstance instance = reverseIt.next();
            if (instance.isInheritingAttributeSettings()) continue;
            uniqueKeyFields = instance.getOwnUniqueKeyFields();
            break;
        }
        return uniqueKeyFields;
    }

    public static Set<String> findEffectiveMaskedFields(IdpConfigurablePluginInstance childInstance) {
        return ConfigurationUtil.findEffectiveMaskedFields(childInstance, ConfigurationUtil.determinePluginManager(childInstance));
    }

    public static Set<String> findEffectiveMaskedFields(IdpConfigurablePluginInstance childInstance, PluginManager<?, IdpConfigurablePluginInstance> pluginMgr) {
        LinkedList<IdpConfigurablePluginInstance> ancestors = ConfigurationUtil.getAncestors(childInstance, pluginMgr);
        Set<String> maskedFields = new HashSet<String>();
        Iterator<IdpConfigurablePluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            IdpConfigurablePluginInstance instance = reverseIt.next();
            if (instance.isInheritingAttributeSettings()) continue;
            maskedFields = instance.getOwnMaskedFields();
            break;
        }
        return maskedFields;
    }

    public static boolean findEffectiveMaskOgnlValues(IdpConfigurablePluginInstance childInstance) {
        return ConfigurationUtil.findEffectiveMaskedOgnlValue(childInstance, ConfigurationUtil.determinePluginManager(childInstance));
    }

    public static boolean findEffectiveMaskedOgnlValue(IdpConfigurablePluginInstance childInstance, PluginManager<?, IdpConfigurablePluginInstance> pluginMgr) {
        LinkedList<IdpConfigurablePluginInstance> ancestors = ConfigurationUtil.getAncestors(childInstance, pluginMgr);
        boolean maskOgnlValues = false;
        Iterator<IdpConfigurablePluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            IdpConfigurablePluginInstance instance = reverseIt.next();
            if (instance.isInheritingAttributeSettings()) continue;
            maskOgnlValues = instance.getOwnMaskOgnlValues();
            break;
        }
        return maskOgnlValues;
    }

    public static String findEffectiveUniqueUserKeyField(IdpAuthnAdapterInstance childInstance, PluginManager<?, IdpAuthnAdapterInstance> pluginMgr) {
        LinkedList<IdpAuthnAdapterInstance> ancestors = ConfigurationUtil.getAncestors(childInstance, pluginMgr);
        String uniqueUserKeyField = null;
        Iterator<IdpAuthnAdapterInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            IdpAuthnAdapterInstance instance = reverseIt.next();
            if (instance.isInheritingAttributeSettings()) continue;
            uniqueUserKeyField = instance.getUniqueUserKeyAttribute();
            break;
        }
        return uniqueUserKeyField;
    }

    public static String findEffectiveUniqueUserKeyField(IdpAuthnAdapterInstance childInstance) {
        return ConfigurationUtil.findEffectiveUniqueUserKeyField(childInstance, ConfigurationUtil.determinePluginManager(childInstance));
    }

    public static String findEffectiveApplicationName(AuthnAdapterInstance authnAdapterInstance) {
        PluginManager<?, AuthnAdapterInstance> pluginManager = ConfigurationUtil.determinePluginManager(authnAdapterInstance);
        if (pluginManager != null) {
            LinkedList<AuthnAdapterInstance> ancestors = ConfigurationUtil.getAncestors(authnAdapterInstance, pluginManager);
            Iterator<AuthnAdapterInstance> reverseIt = ancestors.descendingIterator();
            while (reverseIt.hasNext()) {
                AuthnAdapterInstance next = reverseIt.next();
                if (!StringUtils.isNotBlank((String)next.getApplicationName())) continue;
                return next.getApplicationName();
            }
        }
        return null;
    }

    public static String findEffectiveApplicationIconUrlStr(AuthnAdapterInstance authnAdapterInstance) {
        PluginManager<?, AuthnAdapterInstance> pluginManager = ConfigurationUtil.determinePluginManager(authnAdapterInstance);
        if (pluginManager != null) {
            LinkedList<AuthnAdapterInstance> ancestors = ConfigurationUtil.getAncestors(authnAdapterInstance, pluginManager);
            Iterator<AuthnAdapterInstance> reverseIt = ancestors.descendingIterator();
            while (reverseIt.hasNext()) {
                AuthnAdapterInstance next = reverseIt.next();
                if (next.getApplicationIconUrl() == null) continue;
                return next.getApplicationIconUrl().toExternalForm();
            }
        }
        return null;
    }

    public static Set<String> findEffectiveMultiValuedAttributes(ConfigurablePluginInstance childInstance) {
        LinkedList<ConfigurablePluginInstance> ancestors = ConfigurationUtil.getAncestors(childInstance, ConfigurationUtil.determinePluginManager(childInstance));
        Iterator<ConfigurablePluginInstance> reverseIt = ancestors.descendingIterator();
        Set<String> multiValuedAttrs = new HashSet<String>();
        while (reverseIt.hasNext()) {
            ConfigurablePluginInstance instance = reverseIt.next();
            if (instance.isInheritingExtendedContractAttributes()) continue;
            multiValuedAttrs = instance.getOwnMultiValuedContractAttributes();
            break;
        }
        return multiValuedAttrs;
    }

    public static Configuration sanitize(Configuration config) {
        LinkedList<Field> fields = new LinkedList<Field>();
        LinkedHashMap<String, Field> advancedFields = new LinkedHashMap<String, Field>();
        LinkedList tables = new LinkedList(config.getTables());
        Set extendedAttrNames = config.getAdditionalAttrNames();
        Set maskedAtts = config.getMaskedAttrNames();
        if (config.getAdvancedFields() != null) {
            for (Field advancedField : config.getAdvancedFields().getFields()) {
                advancedFields.put(advancedField.getName(), advancedField);
            }
        }
        for (Field field : config.getFields()) {
            if (advancedFields.containsKey(field.getName())) continue;
            fields.add(field);
        }
        advancedFields.remove("com.pingidentity.plugin.instanceid");
        Configuration result = new Configuration(fields, tables, new ArrayList(advancedFields.values()));
        result.setId(config.getId());
        result.setAdditionalAttrNames(extendedAttrNames);
        result.setMaskedAttrNames(maskedAtts);
        return result;
    }

    public static Configuration prepareForPlugin(Configuration config) {
        LinkedList<Field> fields = new LinkedList<Field>();
        LinkedHashMap<String, Field> advancedFields = new LinkedHashMap<String, Field>();
        LinkedList tables = new LinkedList(config.getTables());
        Set extendedAttrNames = config.getAdditionalAttrNames();
        Set maskedAtts = config.getMaskedAttrNames();
        HashSet<String> seenFields = new HashSet<String>();
        for (Field field : config.getFields()) {
            fields.add(field);
            seenFields.add(field.getName());
        }
        if (config.getAdvancedFields() != null) {
            for (Field advancedField : config.getAdvancedFields().getFields()) {
                advancedFields.put(advancedField.getName(), advancedField);
                if (seenFields.contains(advancedField.getName())) continue;
                fields.add(advancedField);
            }
        }
        Configuration result = new Configuration(fields, tables, new ArrayList(advancedFields.values()));
        result.setId(config.getId());
        result.setAdditionalAttrNames(extendedAttrNames);
        result.setMaskedAttrNames(maskedAtts);
        return result;
    }

    public static List<String> sortSet(Set<String> stringset) {
        LinkedList<String> l = new LinkedList<String>(stringset);
        Collections.sort(l, String.CASE_INSENSITIVE_ORDER);
        return l;
    }

    public static class ExtendedIdentityStoreGroupAttrsReader
    extends ExtendedAttributesReader {
        @Override
        public Set<String> getExtendedAttributes(ConfigurablePluginInstance instance) {
            return ((IdentityStoreProvisionerInstance)instance).getExtendedGroupContractAttributes();
        }
    }

    public static class ExtendedAttributesReader {
        public Set<String> getExtendedAttributes(ConfigurablePluginInstance instance) {
            return instance.getExtendedContractAttributes();
        }
    }
}

