/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.adapter.state.SessionStateSupport;

public class CrossSiteRequestForgeryHelper {
    public static final String CSRF_TOKEN_PARAM_NAME = "cSRFToken";
    private static final String CSRF_TOKEN_ATTRIBUTE_NAME = "CrossSiteRequestForgeryHelper.token";
    private static final int CSRF_TOKEN_LENGTH = 22;
    private static final Log log = LogFactory.getLog(CrossSiteRequestForgeryHelper.class);
    private static SessionStateSupport sessionStateSupport = new SessionStateSupport();

    private CrossSiteRequestForgeryHelper() {
    }

    public static String getCSRFToken(HttpServletRequest request, HttpServletResponse response) {
        String cSRFToken = (String)sessionStateSupport.getAttribute(CSRF_TOKEN_ATTRIBUTE_NAME, request, response);
        if (StringUtils.isBlank((String)cSRFToken)) {
            cSRFToken = CrossSiteRequestForgeryHelper.generateAndStoreCSRFToken(request, response);
        }
        return cSRFToken;
    }

    public static String generateAndStoreCSRFToken(HttpServletRequest request, HttpServletResponse response) {
        SessionStateSupport sessionStateSupport = new SessionStateSupport();
        String cSRFToken = IDGenerator.rndAlphaNumeric(22);
        sessionStateSupport.setAttribute(CSRF_TOKEN_ATTRIBUTE_NAME, (Object)cSRFToken, request, response, true);
        return cSRFToken;
    }

    public static String validateCSRFToken(HttpServletRequest request, HttpServletResponse response) {
        String cSRFToken = (String)sessionStateSupport.getAttribute(CSRF_TOKEN_ATTRIBUTE_NAME, request, response);
        String cSRFTokenForm = request.getParameter(CSRF_TOKEN_PARAM_NAME);
        return CrossSiteRequestForgeryHelper.validateCSRFToken(cSRFToken, cSRFTokenForm).getValue();
    }

    public static ValidationStatus validateCSRFToken(String sessionCSRFToken, String requestCSRFToken) {
        if (!StringUtils.isAlphanumeric((String)requestCSRFToken)) {
            log.error((Object)"CSRF token is either not found in the request or not alphanumeric.");
            return ValidationStatus.newInvalidInstance("invalid CSRF token");
        }
        if (sessionCSRFToken == null) {
            log.error((Object)"The CSRF token was missing from the session state.");
            return ValidationStatus.newInvalidInstance("session CSRF token not found");
        }
        if (!requestCSRFToken.equals(sessionCSRFToken)) {
            log.error((Object)"The CSRF token present in the request did not match with the CSRF token stored in session.");
            return ValidationStatus.newInvalidInstance("CSRF tokens don't match");
        }
        return ValidationStatus.newValidInstance(sessionCSRFToken);
    }

    public static final class ValidationStatus {
        private final boolean valid;
        private final String value;
        private final String errorMessage;

        private ValidationStatus(boolean valid, String value, String errorMessage) {
            this.valid = valid;
            this.value = value;
            this.errorMessage = errorMessage;
        }

        private static ValidationStatus newValidInstance(String value) {
            return new ValidationStatus(true, value, null);
        }

        private static ValidationStatus newInvalidInstance(String errorMessage) {
            return new ValidationStatus(false, null, errorMessage);
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getValue() {
            return this.value;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidationStatus that = (ValidationStatus)o;
            if (this.valid != that.valid) {
                return false;
            }
            if (!Objects.equals(this.value, that.value)) {
                return false;
            }
            return Objects.equals(this.errorMessage, that.errorMessage);
        }

        public int hashCode() {
            int result = this.valid ? 1 : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
            return result;
        }
    }
}

