/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.crypto.Password;

public interface FieldObfuscator {
    public static final FieldObfuscator REAL = new FieldObfuscator(){

        @Override
        public String obfuscate(String clearText) {
            if (clearText != null) {
                return Obfuscator.obfuscate(clearText);
            }
            return null;
        }

        @Override
        public String deobfuscate(String obfuText) {
            if (obfuText != null) {
                return Obfuscator.deobfuscate(obfuText);
            }
            return null;
        }
    };
    public static final FieldObfuscator NULL = new FieldObfuscator(){

        @Override
        public String obfuscate(String clearText) {
            return clearText;
        }

        @Override
        public String deobfuscate(String obfuText) {
            return obfuText;
        }
    };
    public static final FieldObfuscator PwdObfuscator = new FieldObfuscator(){

        @Override
        public String obfuscate(String clearText) {
            String obfuscatedPassword = null;
            if (clearText != null) {
                obfuscatedPassword = Password.obfuscateAndEncode(clearText);
            }
            return obfuscatedPassword;
        }

        @Override
        public String deobfuscate(String obfuText) {
            String decoded = null;
            if (obfuText != null) {
                Password pwd = new Password(obfuText);
                decoded = pwd.getStrValue();
            }
            return decoded;
        }
    };

    public String obfuscate(String var1);

    public String deobfuscate(String var1);
}

