/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.net.URI;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class HierarchicalUriComparison {
    public static int compare(URI left, URI right, boolean useRawPath) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null || right == null) {
            return -1;
        }
        if (left.equals(right)) {
            return 0;
        }
        if (left.isOpaque()) {
            return -1;
        }
        String thisScheme = left.getScheme();
        String thatScheme = right.getScheme();
        if (thisScheme != null && (thatScheme == null || !thisScheme.equals(thatScheme)) || thisScheme == null && thatScheme != null) {
            return -1;
        }
        if (left.getHost() == null || !left.getHost().equalsIgnoreCase(right.getHost())) {
            return -1;
        }
        if (HierarchicalUriComparison.getPort(left) != HierarchicalUriComparison.getPort(right)) {
            return -1;
        }
        String leftPath = StringUtils.defaultString((String)(useRawPath ? left.getRawPath() : left.getPath()));
        String rightPath = StringUtils.defaultString((String)(useRawPath ? right.getRawPath() : right.getPath()));
        StringTokenizer thisPathST = new StringTokenizer(leftPath, "/");
        StringTokenizer thatPathST = new StringTokenizer(rightPath, "/");
        int diff = 0;
        while (thisPathST.hasMoreTokens()) {
            String pathElement = thisPathST.nextToken();
            if (!thatPathST.hasMoreTokens()) {
                ++diff;
                continue;
            }
            String thatPathElement = thatPathST.nextToken();
            if (pathElement.equals(thatPathElement)) continue;
            return -1;
        }
        while (thatPathST.hasMoreTokens()) {
            thatPathST.nextToken();
            --diff;
        }
        return diff;
    }

    private static int getPort(URI thisUri) {
        int thisPort = thisUri.getPort();
        if (thisPort >= 0) {
            return thisPort;
        }
        if ("http".equals(thisUri.getScheme())) {
            return 80;
        }
        if ("https".equals(thisUri.getScheme())) {
            return 443;
        }
        if ("ftp".equals(thisUri.getScheme())) {
            return 21;
        }
        return thisPort;
    }
}

