/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.ldap.LDAPUtil;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.naming.NamingException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import sun.security.util.HostnameChecker;

public class HostnameValidation {
    public static void validate(String hostname, X509Certificate x509Certificate) throws CertificateException {
        HostnameChecker checker = HostnameChecker.getInstance((byte)1);
        try {
            checker.match(hostname, x509Certificate);
        }
        catch (CertificateException e) {
            String message = HostnameValidation.getExMsg(x509Certificate, hostname);
            throw new CertificateException(message, e);
        }
    }

    public static void validate(String hostname, int port) throws CertificateException {
        X509Certificate certificate;
        Socket socket = null;
        try {
            SSLSocketFactory socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            socket = (SSLSocket)socketFactory.createSocket(hostname, port);
            SSLSession session = ((SSLSocket)socket).getSession();
            certificate = (X509Certificate)session.getPeerCertificates()[0];
        }
        catch (IOException e) {
            throw new CertificateException("Cannot validate SSL hostname for: " + hostname + ":" + port);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        HostnameValidation.validate(hostname, certificate);
    }

    public static void validateLdapsHostname(String serverUrls) throws NamingException {
        ConfigStore configStore = ConfigStoreFarm.getConfig(HostnameValidation.class);
        boolean validateLdapsHostname = configStore.getBooleanValue("ValidateLdapsHostname", false);
        if (validateLdapsHostname) {
            for (String serverUrl : LDAPUtil.splitServerUrls(serverUrls)) {
                try {
                    URI ldapUri = new URI(serverUrl);
                    if (!"ldaps".equalsIgnoreCase(ldapUri.getScheme())) continue;
                    HostnameValidation.validate(ldapUri.getHost(), ldapUri.getPort());
                }
                catch (URISyntaxException e) {
                    NamingException ne = new NamingException("Invalid LDAP URL: " + serverUrl);
                    ne.setRootCause(e);
                    throw ne;
                }
                catch (CertificateException e) {
                    NamingException ne = new NamingException("LDAPS hostname validation failed: " + serverUrl);
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        }
    }

    private static String getExMsg(X509Certificate x509Certificate, String hostname) {
        Principal dn = x509Certificate.getSubjectDN();
        return "hostname (" + hostname + ") mismatch for SubjectDN: " + dn;
    }
}

