/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.timers.DSEventTimer;
import com.pingidentity.common.util.timers.jdbc.TimedCallableStatement;
import com.pingidentity.common.util.timers.jdbc.TimedPreparedStatement;
import com.pingidentity.common.util.timers.jdbc.TimedStatement;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Stack;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.JdbcDataSource;

public class JDBCHelper
implements AutoCloseable {
    private String dataSourceName = "";
    private Connection connection;
    private ResultSet resultSet;
    private PreparedStatement preparedStatement;
    private Statement statement;
    private CallableStatement callableStatement;
    private Stack<AutoCloseable> resourcesToFree = new Stack();
    private ServiceInformation serviceInformation;

    protected JDBCHelper() {
    }

    @Deprecated
    public JDBCHelper(String dataSourceName) throws NamingException, SQLException {
        this(dataSourceName, null);
    }

    public JDBCHelper(String dataSourceName, ServiceInformation serviceInformation) throws NamingException, SQLException {
        InitialContext initialContext = new InitialContext();
        DataSource dataSource = (DataSource)initialContext.lookup(dataSourceName);
        this.dataSourceName = dataSourceName;
        this.serviceInformation = serviceInformation;
        if ("PFIndexDS".equals(dataSourceName) || "PFDefaultDS".equals(dataSourceName)) {
            this.connection = dataSource.getConnection();
        } else {
            try (DSEventTimer ignored = DSEventTimer.getJdbcInstance(dataSourceName, "obtain-connection", serviceInformation);){
                this.connection = dataSource.getConnection();
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(dataSourceName);
                throw e;
            }
        }
        this.connection.setAutoCommit(true);
    }

    public JDBCHelper(Connection connection) throws SQLException {
        this.connection = connection;
        connection.setAutoCommit(true);
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    protected void finalize() throws Throwable {
        this.cleanUp();
        super.finalize();
    }

    public void cleanUp() {
        while (!this.resourcesToFree.isEmpty()) {
            AutoCloseable resource = this.resourcesToFree.pop();
            try {
                resource.close();
            }
            catch (Exception exception) {}
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        PreparedStatement tmpPreparedStatement = this.connection.prepareStatement(sql, 1004, 1007);
        this.preparedStatement = new TimedPreparedStatement(tmpPreparedStatement, this.dataSourceName, this.serviceInformation);
        this.resourcesToFree.push(this.preparedStatement);
        return this.preparedStatement;
    }

    public PreparedStatement getPreparedStatement(String sql, boolean flag) throws SQLException {
        PreparedStatement tmpPreparedStatement = this.connection.prepareStatement(sql, 1);
        this.preparedStatement = new TimedPreparedStatement(tmpPreparedStatement, this.dataSourceName, this.serviceInformation);
        this.resourcesToFree.push(this.preparedStatement);
        return this.preparedStatement;
    }

    public CallableStatement getCallableStatement(String sql) throws SQLException {
        CallableStatement tmpCallableStatement = this.connection.prepareCall(sql);
        this.callableStatement = new TimedCallableStatement(tmpCallableStatement, this.dataSourceName, this.serviceInformation);
        this.resourcesToFree.push(this.callableStatement);
        return this.callableStatement;
    }

    public boolean execute(String sql) throws SQLException {
        Statement tmpStatement = this.connection.createStatement();
        this.statement = new TimedStatement(tmpStatement, this.dataSourceName, this.serviceInformation);
        this.resourcesToFree.push(this.statement);
        this.statement.setQueryTimeout(10);
        return this.statement.execute(sql);
    }

    public ResultSet getResultSet() throws SQLException {
        this.resultSet = this.preparedStatement.executeQuery();
        this.resourcesToFree.push(this.resultSet);
        return this.resultSet;
    }

    public ResultSet getResultSet(String sql) throws SQLException {
        Statement tmpStatement = this.connection.createStatement();
        this.statement = new TimedStatement(tmpStatement, this.dataSourceName, this.serviceInformation);
        this.resourcesToFree.push(this.statement);
        this.statement.setQueryTimeout(10);
        this.resultSet = this.statement.executeQuery(sql);
        this.resourcesToFree.push(this.resultSet);
        return this.resultSet;
    }

    public boolean isOracle() throws SQLException {
        String productName = this.connection.getMetaData().getDatabaseProductName();
        return productName != null && productName.contains("Oracle");
    }

    public boolean isSqlServer() throws SQLException {
        String productName = this.connection.getMetaData().getDatabaseProductName();
        return productName != null && productName.contains("SQL Server");
    }

    public boolean isMySql() throws SQLException {
        String productName = this.connection.getMetaData().getDatabaseProductName();
        return productName != null && productName.contains("MySQL");
    }

    public boolean isHypersonicHql() throws SQLException {
        String productName = this.connection.getMetaData().getDatabaseProductName();
        return productName != null && productName.contains("HSQL");
    }

    public boolean isPostgres() throws SQLException {
        String productName = this.connection.getMetaData().getDatabaseProductName();
        return productName != null && productName.contains("PostgreSQL");
    }

    public ResultSet getSchemas() throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        this.resultSet = dbMetaData.getSchemas();
        this.resourcesToFree.push(this.resultSet);
        return this.resultSet;
    }

    public ResultSet getTables() throws SQLException {
        return this.getTables(null);
    }

    public ResultSet getTablesByTableType(String ... tableTypes) throws SQLException {
        return this.getTables(null, tableTypes);
    }

    public ResultSet getTablesByTableType(String tableSchemaPattern, String ... tableTypes) throws SQLException {
        return this.getTables(tableSchemaPattern, tableTypes);
    }

    public ResultSet getTables(String tableSchemaPattern) throws SQLException {
        return this.getTables(tableSchemaPattern, null);
    }

    private ResultSet getTables(String tableSchemaPattern, String ... tableTypes) throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        this.resultSet = dbMetaData.getTables(null, tableSchemaPattern, null, tableTypes);
        this.resourcesToFree.push(this.resultSet);
        return this.resultSet;
    }

    public ResultSet getColumns(String tableNamePattern) throws SQLException {
        return this.getColumns(null, tableNamePattern);
    }

    public ResultSet getColumns(String tableSchemaPattern, String tableNamePattern) throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        this.resultSet = dbMetaData.getColumns(null, tableSchemaPattern, tableNamePattern, null);
        this.resourcesToFree.push(this.resultSet);
        return this.resultSet;
    }

    public ResultSet getColumnPrivileges(String schema, String table, String columnName) throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        this.resultSet = dbMetaData.getColumnPrivileges(null, schema, table, columnName);
        this.resourcesToFree.push(this.resultSet);
        return this.resultSet;
    }

    public ResultSet getColumnType(String schema, String table, String columnName) throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        this.resultSet = dbMetaData.getTypeInfo();
        this.resourcesToFree.push(this.resultSet);
        return this.resultSet;
    }

    public ResultSet getStoredProceduresForSchema(String schema) throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        this.resultSet = dbMetaData.getProcedures(null, schema, null);
        this.resourcesToFree.push(this.resultSet);
        return this.resultSet;
    }

    public ResultSet getStoredProcedureColumns(String schema, String storedProcedureName) throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        this.resultSet = dbMetaData.getProcedureColumns(null, schema, storedProcedureName, null);
        this.resourcesToFree.push(this.resultSet);
        return this.resultSet;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public static void testConnection(JdbcDataSource jds, ServiceInformation serviceInformation) throws SecretManagerException, NamingException, SQLException {
        Log log = LogFactory.getLog(JDBCHelper.class);
        try (DSEventTimer ignored = DSEventTimer.getJdbcInstance(jds.getJndiName(), "test-connection", serviceInformation);){
            InitialContext initialContext = new InitialContext();
            DataSource dataSource = (DataSource)initialContext.lookup(jds.getJndiName());
            try (Connection conn = dataSource.getConnection();
                 Statement stmt = conn.createStatement();){
                if (StringUtils.isEmpty((String)jds.getCheckValidConnectionSql())) {
                    if (jds.isOracleDriver() || jds.isMySqlDriver()) {
                        stmt.execute("SELECT 1 from dual");
                    } else if (jds.isPostgresDriver()) {
                        stmt.execute("SELECT 1");
                    } else if (jds.isSqlServerDriver()) {
                        stmt.execute("SELECT GETDATE()");
                    }
                } else {
                    stmt.execute(jds.getCheckValidConnectionSql());
                }
                log.info((Object)("JDBC Connection: " + jds.getDescription() + " Successfully connected to the data store."));
            }
            catch (SQLException e) {
                log.error((Object)("JDBC Connection: " + jds.getDescription() + " Failed to connect to the data store."));
                log.error((Object)e.getMessage());
                for (Throwable exception = e.getCause(); exception != null; exception = exception.getCause()) {
                    if (!(exception instanceof SecretManagerException)) continue;
                    throw new SecretManagerException((Throwable)e);
                }
                throw e;
            }
        }
        catch (NamingException ne) {
            log.error((Object)ne.getMessage());
            throw ne;
        }
    }
}

