/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.security.KerberosCallbackHandler;
import com.pingidentity.common.security.KerberosConfigurationProvider;
import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.KerberosConfigUtil;
import com.pingidentity.common.util.KerberosResult;
import com.pingidentity.common.util.KerberosTokenUtil;
import com.pingidentity.common.util.KerberosUtil;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.saml20.domain.KerberosContext;
import org.sourceid.saml20.domain.KerberosKeySet;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.KerberosRealmsSettings;
import org.sourceid.saml20.domain.mgmt.JaasLoginConfigurationManager;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.KerberosContextManager;

public class KerberosUtilActiveDirectoryImpl
implements KerberosUtil {
    private static final Log log = LogFactory.getLog(KerberosUtil.class);
    private final KerberosRealmManager kerberosRealmManager;
    private final JaasLoginConfigurationManager jaasLoginConfigurationManager;
    private KerberosContext kerberosContext;
    private GSSContext secContext;
    private Set<KerberosKey> tokenKeySet;

    public KerberosUtilActiveDirectoryImpl(KerberosRealm kerberosRealm, boolean useCache) {
        this(MgmtFactory.getJaasLoginConfigurationManager(), MgmtFactory.getKerberosRealmManager(), kerberosRealm, useCache);
    }

    public KerberosUtilActiveDirectoryImpl(JaasLoginConfigurationManager jaasLoginConfigurationManager, KerberosRealmManager kerberosRealmManager, KerberosRealm kerberosRealm, boolean useCache) {
        this.jaasLoginConfigurationManager = jaasLoginConfigurationManager;
        this.kerberosRealmManager = kerberosRealmManager;
        if (useCache) {
            this.initKerberosContext(kerberosRealm);
        } else {
            this.setKerberosContext(kerberosRealm);
        }
    }

    private void initKerberosContext(KerberosRealm kerberosRealm) {
        KerberosContextManager kerberosContextManager = KerberosContextManager.getManager();
        if (kerberosContextManager.isKerberosContextRegistered(kerberosRealm.getKerberosRealmName())) {
            this.kerberosContext = kerberosContextManager.getKerberosContext(kerberosRealm.getKerberosRealmName());
        }
        if (this.kerberosContext == null) {
            this.setKerberosContext(kerberosRealm);
        }
    }

    private void setKerberosContext(KerberosRealm kerberosRealm) {
        this.kerberosContext = new KerberosContext(kerberosRealm);
        String username = this.capitalizeDomainName(kerberosRealm.getKerberosUsername() + "@" + kerberosRealm.getKerberosRealmName());
        this.kerberosContext.setKerberosCallbackHandler(new KerberosCallbackHandler(username, kerberosRealm.getKerberosPassword()));
    }

    @Override
    public void testKerberosRealm(KerberosRealmsSettings kerberosRealmsSettings, boolean updateKrb5Conf) throws KerberosException {
        KerberosConfigUtil.setKrb5ConfSystemProperty();
        AppConfigurationEntry[] origAppConfigurationEntry = null;
        if (updateKrb5Conf) {
            origAppConfigurationEntry = this.jaasLoginConfigurationManager.getAppConfigurationEntry(this.kerberosContext.getKerberosRealm().getKerberosRealmName());
            if (this.kerberosContext.getKerberosRealm().getKeyDistributionCenters() == null || this.kerberosContext.getKerberosRealm().getKeyDistributionCenters().isEmpty()) {
                throw new KerberosException("No KDCs are configured");
            }
            ArrayList<KerberosRealm> kerberosRealms = new ArrayList<KerberosRealm>();
            for (Object kdc : this.kerberosContext.getKerberosRealm().getKeyDistributionCenters()) {
                KerberosRealm copiedRealm = new KerberosRealm(this.kerberosContext.getKerberosRealm());
                copiedRealm.setKeyDistributionCenters(Collections.singletonList(kdc));
                kerberosRealms.add(copiedRealm);
            }
            if (KerberosConfigUtil.getKrb5ConfFile().exists()) {
                KerberosConfigUtil.backupKrb5ConfFile("original");
            }
            KerberosRealm currentRealm = null;
            try {
                Object kdc;
                kdc = kerberosRealms.iterator();
                while (kdc.hasNext()) {
                    KerberosRealm kerberosRealm;
                    currentRealm = kerberosRealm = (KerberosRealm)kdc.next();
                    List<KerberosRealm> filteredRealms = this.kerberosRealmManager.getKerberosRealms().stream().filter(realm -> !realm.getKerberosRealmName().equals(kerberosRealm.getKerberosRealmName())).collect(Collectors.toList());
                    filteredRealms.add(kerberosRealm);
                    KerberosConfigUtil.updateKrb5Conf(filteredRealms, kerberosRealmsSettings);
                    KerberosConfigurationProvider kerberosConfigurationProvider = new KerberosConfigurationProvider(kerberosRealm.getKerberosRealmName(), kerberosRealmsSettings.getDebugLogOutput());
                    this.jaasLoginConfigurationManager.addAppConfigurationEntry(kerberosRealm.getKerberosRealmName(), kerberosConfigurationProvider.getAppConfigurationEntry(kerberosRealm.getKerberosRealmName()));
                    this.connect();
                }
            }
            catch (KerberosException ex) {
                log.error((Object)("Failed to connect to Kerberos realm " + currentRealm.getKerberosRealmName() + " with KDC: [" + currentRealm.getKeyDistributionCenter() + "]"));
                throw ex;
            }
            finally {
                if (updateKrb5Conf) {
                    if (origAppConfigurationEntry == null) {
                        this.jaasLoginConfigurationManager.removeAppConfigurationEntry(this.kerberosContext.getKerberosRealm().getKerberosRealmName());
                    } else {
                        this.jaasLoginConfigurationManager.addAppConfigurationEntry(this.kerberosContext.getKerberosRealm().getKerberosRealmName(), origAppConfigurationEntry);
                    }
                    if (KerberosConfigUtil.getKrb5ConfFile("original").exists()) {
                        KerberosConfigUtil.restoreKrb5ConfFile("original");
                    }
                }
            }
        }
    }

    @Override
    public Set<KerberosKey> getCurrentKeys() {
        return this.kerberosContext.getLoginContextKeySet();
    }

    private void connect() throws KerberosException {
        try {
            this.establishLoginContext();
            this.establishSecurityContext(this.kerberosContext.getLoginContextKeySet());
        }
        catch (KerberosException | PrivilegedActionException | LoginException | FipsUnapprovedOperationError | GSSException e) {
            throw new KerberosException(e);
        }
    }

    private String capitalizeDomainName(String username) {
        String domain;
        if (StringUtils.indexOf((String)username, (char)'@') >= 0 && !(domain = StringUtils.substring((String)username, (int)StringUtils.indexOf((String)username, (char)'@'))).equals(domain.toUpperCase())) {
            username = StringUtils.chomp((String)username, (String)domain);
            username = username.concat(domain.toUpperCase());
        }
        return username;
    }

    private String extractServerDomainName(LoginContext lc) throws KerberosException {
        Subject subject = lc.getSubject();
        Set<KerberosPrincipal> principals = subject.getPrincipals(KerberosPrincipal.class);
        Iterator<KerberosPrincipal> iter = principals.iterator();
        if (!iter.hasNext()) {
            throw new KerberosException("Unable to obtain KDC login information");
        }
        return iter.next().getName();
    }

    private void establishLoginContext() throws LoginException, FipsUnapprovedOperationError {
        if (this.kerberosContext != null) {
            String kerberosRealmName = this.kerberosContext.getKerberosRealm().getKerberosRealmName();
            KerberosCallbackHandler kerberosCallbackHandler = this.kerberosContext.getKerberosCallbackHandler();
            LoginContext loginContext = new LoginContext(kerberosRealmName, kerberosCallbackHandler);
            loginContext.login();
            this.kerberosContext.setLoginContext(loginContext);
        }
    }

    private GSSContext establishSecurityContext(Set<KerberosKey> keySet) throws PrivilegedActionException, GSSException, KerberosException {
        Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
        String serverNameRealm = this.extractServerDomainName(this.kerberosContext.getLoginContext());
        GSSManager gssManager = GSSManager.getInstance();
        GSSName srvName = gssManager.createName(serverNameRealm, null);
        PrivilegedExceptionAction<Object> objectPrivilegedExceptionAction = () -> gssManager.createCredential(srvName, Integer.MAX_VALUE, krb5Mechanism, 2);
        Subject contextSubject = this.kerberosContext.getLoginContext().getSubject();
        Subject subject = new Subject(false, contextSubject.getPrincipals(), Collections.emptySet(), keySet);
        GSSCredential serverCreds = (GSSCredential)Subject.doAs(subject, objectPrivilegedExceptionAction);
        GSSContext context = gssManager.createContext(serverCreds);
        context.requestMutualAuth(false);
        return context;
    }

    private GSSContext prepareGSSContext(byte[] token) throws LoginException, PrivilegedActionException, GSSException, FipsUnapprovedOperationError, KerberosException {
        if (this.secContext != null) {
            return this.secContext;
        }
        if (!this.kerberosContext.checkLoginContext()) {
            this.kerberosContext.logout();
            this.establishLoginContext();
            KerberosContextManager kerberosContextManager = KerberosContextManager.getManager();
            kerberosContextManager.addKerberosContext(this.kerberosContext);
        }
        GSSException firstGSSException = null;
        List<Set<KerberosKey>> keySets = this.gatherKeySets(this.kerberosContext);
        for (Set<KerberosKey> keySet : keySets) {
            GSSContext tmpSecContext = this.establishSecurityContext(keySet);
            if (tmpSecContext == null) continue;
            try {
                tmpSecContext.acceptSecContext(token, 0, token.length);
                if (!tmpSecContext.isEstablished()) {
                    throw new KerberosException("Additional work needs to be done to the Kerberos token");
                }
                this.tokenKeySet = keySet;
                this.secContext = tmpSecContext;
                break;
            }
            catch (GSSException e) {
                if (firstGSSException == null) {
                    firstGSSException = e;
                }
                log.debug((Object)("Error accepting security context from token: " + ExceptionUtil.toStringWithCauses(e)));
            }
        }
        if (this.secContext != null) {
            return this.secContext;
        }
        if (firstGSSException != null) {
            throw firstGSSException;
        }
        return null;
    }

    private List<Set<KerberosKey>> gatherKeySets(KerberosContext context) {
        ArrayList<Set<KerberosKey>> keySets = new ArrayList<Set<KerberosKey>>();
        Set<KerberosKey> contextKeySet = context.getLoginContext().getSubject().getPrivateCredentials(KerberosKey.class);
        keySets.add(contextKeySet);
        for (KerberosKeySet kerberosKeySet : context.getKerberosRealm().getValidKeySets(Instant.now())) {
            if (keySets.contains(kerberosKeySet.getKeys())) continue;
            keySets.add(kerberosKeySet.getKeys());
        }
        return keySets;
    }

    @Override
    public KerberosResult validateTicketAndExtractSids(byte[] kerberosToken) throws KerberosException {
        String principal = this.validateTicket(kerberosToken);
        String objectSid = null;
        Set<String> sids = null;
        if (principal != null) {
            KerberosTokenUtil.KerberosSids kerberosSids = this.extractSids(kerberosToken);
            objectSid = kerberosSids.getObjectSid();
            sids = kerberosSids.getSids();
        }
        return new KerberosResult(principal, objectSid, sids);
    }

    private String validateTicket(byte[] token) throws KerberosException {
        String principal = null;
        try {
            this.secContext = this.prepareGSSContext(token);
            if (this.secContext != null) {
                principal = this.secContext.getSrcName().toString();
            }
            return principal;
        }
        catch (PrivilegedActionException | LoginException | FipsUnapprovedOperationError | GSSException e) {
            String message = "Error validating Kerberos token";
            log.debug((Object)message, e);
            log.error((Object)(message + ": " + ExceptionUtil.toStringWithCauses(e)));
            throw new KerberosException(e);
        }
    }

    private KerberosTokenUtil.KerberosSids extractSids(byte[] token) throws KerberosException {
        try {
            this.secContext = this.prepareGSSContext(token);
            if (this.secContext != null) {
                return KerberosTokenUtil.extractSids(token, this.tokenKeySet);
            }
        }
        catch (PrivilegedActionException | LoginException | FipsUnapprovedOperationError | GSSException e) {
            log.warn((Object)("Couldn't extract SIDs from Kerberos token. " + e.getMessage()));
        }
        return new KerberosTokenUtil.KerberosSids(null, Collections.emptySet());
    }
}

