/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.KerberosResult;
import com.pingidentity.common.util.KerberosUtil;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import com.pingidentity.pingonev2.PingOneGateway;
import com.pingidentity.pingonev2.ValidateKerberosTicketResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.KerberosRealmsSettings;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;

public class KerberosUtilLdapGatewayImpl
implements KerberosUtil {
    private static final Log log = LogFactory.getLog(KerberosUtilLdapGatewayImpl.class);
    private final KerberosRealm kerberosRealm;

    public KerberosUtilLdapGatewayImpl(KerberosRealm kerberosRealm) {
        this.kerberosRealm = kerberosRealm;
    }

    @Override
    public void testKerberosRealm(KerberosRealmsSettings kerberosRealmsSettings, boolean updateKrb5Conf) throws KerberosException {
        block6: {
            try {
                LdapDataSource ldapDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(this.kerberosRealm.getLdapGatewayDatastoreId());
                PingOneConnectionsManager connectionsMgr = MgmtFactory.getPingOneConnectionsManager();
                PingOneConnection pingOneConnection = connectionsMgr.getConnection(ldapDataSource.getConnectionInfo().getPingOneConnection());
                List gateway = pingOneConnection.getGateways(ldapDataSource.getConnectionInfo().getPingOneEnvironment(), false).stream().filter(pingOneGateway -> pingOneGateway.getId().equals(ldapDataSource.getConnectionInfo().getPingOneGateway())).collect(Collectors.toList());
                if (!gateway.isEmpty()) {
                    PingOneGateway pingOneGateway2 = (PingOneGateway)gateway.get(0);
                    if (!pingOneGateway2.isEnabled()) {
                        throw new KerberosException("LDAP Gateway is not enabled.");
                    }
                    if (!pingOneGateway2.isKerberosAuthenticationEnabled()) {
                        throw new KerberosException("Kerberos Authentication is not enabled at the LDAP Gateway.");
                    }
                    String kerberosAlerts = pingOneGateway2.getCurrentAlerts().stream().filter(alert -> alert.getSeverityInt() == 0).map(alert -> alert.getCategory() + " - " + alert.getDetail()).collect(Collectors.joining("; "));
                    if (!kerberosAlerts.isEmpty()) {
                        throw new KerberosException(kerberosAlerts);
                    }
                    break block6;
                }
                throw new KerberosException("Unable to find PingOne LDAP Gateway Data Store.");
            }
            catch (InvalidGatewayCredentialException | IOException e) {
                String message = "Problem getting gateways from PingOne.";
                log.debug((Object)message, (Throwable)e);
                throw new KerberosException(message, e);
            }
        }
    }

    @Override
    public KerberosResult validateTicketAndExtractSids(byte[] kerberosToken) throws KerberosException {
        ValidateKerberosTicketResponse response;
        LdapDataSource ldapDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(this.kerberosRealm.getLdapGatewayDatastoreId());
        PingOneConnectionsManager connectionsMgr = MgmtFactory.getPingOneConnectionsManager();
        PingOneConnection pingOneConnection = connectionsMgr.getConnection(ldapDataSource.getConnectionInfo().getPingOneConnection());
        try {
            response = pingOneConnection.validateKerberosTicket(kerberosToken, ldapDataSource.getConnectionInfo().getPingOneEnvironment(), ldapDataSource.getConnectionInfo().getPingOneGateway());
        }
        catch (InvalidGatewayCredentialException | IOException e) {
            log.error((Object)"Problem with PingOne request.");
            throw new KerberosException(e);
        }
        return new KerberosResult(response.getUsername() + "@" + response.getDomain(), response.getObjectSid(), response.getSids());
    }

    @Override
    public Set<KerberosKey> getCurrentKeys() {
        return Collections.emptySet();
    }
}

