/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.KerberosResult;
import com.pingidentity.common.util.KerberosTokenUtil;
import com.pingidentity.common.util.KerberosUtil;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.KerberosKeySet;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.KerberosRealmsSettings;

public class KerberosUtilLocalValidationImpl
implements KerberosUtil {
    private static final String CONFIG_LIST_ALLOWED_ENCRYPTION_TYPES = "allowedEncryptionTypes";
    private static final List<String> CONFIG_LIST_ALLOWED_ENCRYPTION_TYPES_DEFAULT = List.of("aes256-cts-hmac-sha1-96", "aes128-cts-hmac-sha1-96", "aes256-cts-hmac-sha384-192", "aes128-cts-hmac-sha256-128");
    private static final Log log = LogFactory.getLog(KerberosUtilLocalValidationImpl.class);
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("com.pingidentity.common.util.KerberosUtilLocalValidationImpl");
    private final KerberosRealm kerberosRealm;
    private final List<String> allowedEncryptionTypes;

    public KerberosUtilLocalValidationImpl(KerberosRealm kerberosRealm) {
        this.kerberosRealm = kerberosRealm;
        this.allowedEncryptionTypes = configStore.getListValue(CONFIG_LIST_ALLOWED_ENCRYPTION_TYPES, CONFIG_LIST_ALLOWED_ENCRYPTION_TYPES_DEFAULT);
    }

    @Override
    public void testKerberosRealm(KerberosRealmsSettings kerberosRealmsSettings, boolean updateKrb5Conf) throws KerberosException {
    }

    @Override
    public KerberosResult validateTicketAndExtractSids(byte[] kerberosToken) throws KerberosException {
        List<Set<KerberosKey>> keySets = this.getAllKeys();
        KerberosException firstKerberosException = null;
        for (Set<KerberosKey> keySet : keySets) {
            try {
                return this.validateToken(kerberosToken, keySet);
            }
            catch (KerberosException e) {
                if (firstKerberosException != null) continue;
                firstKerberosException = e;
            }
        }
        if (firstKerberosException != null) {
            log.error((Object)("Could not validate Kerberos token. " + ExceptionUtil.toStringWithCauses(firstKerberosException)));
            throw firstKerberosException;
        }
        throw new KerberosException("Unexpected. Could not validate Kerberos token.");
    }

    @Override
    public Set<KerberosKey> getCurrentKeys() {
        KerberosPrincipal kerberosPrincipal = this.getKerberosPrincipal();
        Set<KerberosKey> keys = this.allowedEncryptionTypes.stream().map(algorithm -> new KerberosKey(kerberosPrincipal, this.kerberosRealm.getKerberosPassword().toCharArray(), (String)algorithm)).collect(Collectors.toSet());
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (KerberosKey key : keys) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(key.getKeyType());
            }
            log.debug((Object)("Key types used for local validation: [" + sb + "]"));
        }
        return keys;
    }

    private KerberosResult validateToken(byte[] kerberosToken, Set<KerberosKey> keySet) throws KerberosException {
        GSSContext gssContext = null;
        try {
            gssContext = this.establishSecurityContext(keySet);
            gssContext.acceptSecContext(kerberosToken, 0, kerberosToken.length);
            if (!gssContext.isEstablished()) {
                log.debug((Object)"Kerberos security context is not established.");
                throw new KerberosException("Kerberos security context is not established");
            }
            String principalName = gssContext.getSrcName().toString();
            KerberosTokenUtil.KerberosSids sids = KerberosTokenUtil.extractSids(kerberosToken, keySet);
            KerberosResult kerberosResult = new KerberosResult(principalName, sids.getObjectSid(), sids.getSids());
            return kerberosResult;
        }
        catch (GSSException e) {
            log.debug((Object)("Error validating Kerberos token: " + ExceptionUtil.toStringWithCauses(e)));
            throw new KerberosException("Error validating Kerberos token", e);
        }
        finally {
            try {
                if (gssContext != null) {
                    gssContext.dispose();
                }
            }
            catch (GSSException e) {
                log.debug((Object)("Error disposing Kerberos security context: " + ExceptionUtil.toStringWithCauses(e)));
            }
        }
    }

    private GSSContext establishSecurityContext(Set<KerberosKey> keySet) throws KerberosException {
        try {
            Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
            GSSManager gssManager = GSSManager.getInstance();
            KerberosPrincipal kerberosPrincipal = this.getKerberosPrincipal();
            GSSName srvName = gssManager.createName(kerberosPrincipal.getName(), null);
            PrivilegedExceptionAction<Object> objectPrivilegedExceptionAction = () -> gssManager.createCredential(srvName, Integer.MAX_VALUE, krb5Mechanism, 2);
            Subject subject = new Subject(false, Collections.singleton(kerberosPrincipal), Collections.emptySet(), keySet);
            GSSCredential serverCreds = (GSSCredential)Subject.doAs(subject, objectPrivilegedExceptionAction);
            GSSContext context = gssManager.createContext(serverCreds);
            context.requestMutualAuth(false);
            return context;
        }
        catch (PrivilegedActionException | GSSException e) {
            log.debug((Object)("Error establishing security context: " + ExceptionUtil.toStringWithCauses(e)));
            throw new KerberosException("Error establishing security context", e);
        }
    }

    private List<Set<KerberosKey>> getAllKeys() {
        ArrayList<Set<KerberosKey>> keySets = new ArrayList<Set<KerberosKey>>();
        keySets.add(this.getCurrentKeys());
        for (KerberosKeySet kerberosKeySet : this.kerberosRealm.getValidKeySets(Instant.now())) {
            if (keySets.contains(kerberosKeySet.getKeys())) continue;
            keySets.add(kerberosKeySet.getKeys());
        }
        return keySets;
    }

    private KerberosPrincipal getKerberosPrincipal() {
        return new KerberosPrincipal(this.kerberosRealm.getKerberosUsername() + "@" + this.kerberosRealm.getKerberosRealmName().toUpperCase(), 1);
    }
}

