/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.common.CryptoUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class Obfuscator {
    private static final Log log = LogFactory.getLog(Obfuscator.class);

    private Obfuscator() {
    }

    @Deprecated
    public static String obfuscate(String clearText, String algorithm) {
        return CryptoUtil.obfuscate((String)clearText, (String)algorithm);
    }

    public static String obfuscate(String clearText) {
        return Obfuscator.obfuscate(clearText, false);
    }

    public static String obfuscate(String clearText, boolean compress) {
        JsonWebKey jwk = (JsonWebKey)MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys().get(0);
        return CryptoUtil.obfuscate((String)clearText, (JsonWebKey)jwk, (boolean)compress);
    }

    public static String obfuscateBinary(byte[] clearText, boolean compress) {
        JsonWebKey jwk = (JsonWebKey)MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys().get(0);
        return CryptoUtil.obfuscateBinary((byte[])clearText, (JsonWebKey)jwk, (boolean)compress);
    }

    public static String obfuscateBinary(byte[] clearText) {
        JsonWebKey jwk = (JsonWebKey)MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys().get(0);
        return CryptoUtil.obfuscateBinary((byte[])clearText, (JsonWebKey)jwk);
    }

    public static String deobfuscate(String obfuscatedText) {
        String algorithm = MgmtFactory.getJCEManager().getLegacyEncryptionAlgorithm();
        return Obfuscator.deobfuscate(obfuscatedText, algorithm);
    }

    public static String deobfuscate(String obfuscatedText, String legacyAlgorithm) {
        try {
            String deobfuscated = CryptoUtil.jweDeobfuscate((String)obfuscatedText, (JsonWebKeySet)MgmtFactory.getMasterKeySet().getJsonWebKeySet());
            if (deobfuscated != null) {
                return deobfuscated;
            }
        }
        catch (JoseException joseException) {
            // empty catch block
        }
        return CryptoUtil.deobfuscate((String)obfuscatedText, (String)legacyAlgorithm);
    }

    public static byte[] deobfuscateBinary(String obfuscatedText) {
        return CryptoUtil.jweDeobfuscateBinary((String)obfuscatedText, (JsonWebKeySet)MgmtFactory.getMasterKeySet().getJsonWebKeySet());
    }
}

