/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.CodeGenerationUtil;
import com.pingidentity.common.util.TimeUtil;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.util.log.AttributeMap;

public class OtpUtils {
    private final SessionStateSupport session = new SessionStateSupport();
    private static final Log logger = LogFactory.getLog(OtpUtils.class);
    public static final String FORM_OTP_CODE_NAME = "oneTimePasscode";
    public static final String OTP_ATTR_MAP_KEY = "otpMapKey";
    public static final String OTP_ATTR_CODE_KEY = "otpMapCodeKey";
    public static final String OTP_ATTR_TIME_KEY = "otpMapTimeKey";
    public static final String OTP_ATTR_ID_KEY = "otpMapUserIdKey";
    private static final String ATTR_KEY_COUNT = "otpAttemptCount";

    public AttributeMap getStoredOtpAttributes(HttpServletRequest req, HttpServletResponse resp) {
        return (AttributeMap)this.session.getAttribute(OTP_ATTR_MAP_KEY, req, resp);
    }

    public String setStoredOtpAttributes(HttpServletRequest req, HttpServletResponse resp, int codeLength, String allowedCharacterSet, String identifier) {
        CodeGenerationUtil.GeneratedCode generatedCode = CodeGenerationUtil.generateOtp(codeLength, allowedCharacterSet);
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.put(OTP_ATTR_CODE_KEY, generatedCode.getEncodedCode());
        attributeMap.put(OTP_ATTR_TIME_KEY, generatedCode.getTimeGenerated());
        attributeMap.put(OTP_ATTR_ID_KEY, identifier);
        this.session.setAttribute(OTP_ATTR_MAP_KEY, (Object)attributeMap, req, resp, true);
        return generatedCode.getCode();
    }

    public int getOtpAttemptCount(HttpServletRequest req, HttpServletResponse resp) {
        int count = 0;
        Object savedCount = this.session.getAttribute(ATTR_KEY_COUNT, req, resp);
        if (savedCount != null) {
            try {
                count = (Integer)savedCount;
            }
            catch (Exception e) {
                logger.error((Object)"Error converting session count to integer", (Throwable)e);
                return Integer.MAX_VALUE;
            }
        }
        return count;
    }

    public void increaseOtpAttemptCount(HttpServletRequest req, HttpServletResponse resp) {
        int count = this.getOtpAttemptCount(req, resp);
        if (count < Integer.MAX_VALUE) {
            ++count;
        }
        this.session.removeAttribute(ATTR_KEY_COUNT, req, resp);
        this.session.setAttribute(ATTR_KEY_COUNT, (Object)count, req, resp, true);
    }

    public void removeAllOtpAttributes(HttpServletRequest req, HttpServletResponse resp) {
        this.session.removeAttribute(ATTR_KEY_COUNT, req, resp);
        this.session.removeAttribute(OTP_ATTR_MAP_KEY, req, resp);
    }

    public static String getOtp(HttpServletRequest req) {
        return req.getParameter(FORM_OTP_CODE_NAME);
    }

    public boolean isValidOtp(HttpServletRequest req, HttpServletResponse resp, String otpSubmitted, String identifier) {
        AttributeMap attributes = this.getStoredOtpAttributes(req, resp);
        if (attributes == null) {
            return false;
        }
        String storedOtp = attributes.getSingleValue(OTP_ATTR_CODE_KEY);
        if (otpSubmitted != null && storedOtp != null && CodeGenerationUtil.isExpectedPassword(otpSubmitted.toCharArray(), storedOtp)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Code Successfully Validated");
            }
            String storedUserIdentifier = attributes.getSingleValue(OTP_ATTR_ID_KEY);
            if (identifier == null || !identifier.equals(storedUserIdentifier)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"User Identifier Mismatch");
                }
                return false;
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Invalid Code");
        }
        return false;
    }

    public boolean isExpiredOtp(HttpServletRequest req, HttpServletResponse resp, Integer durationValid) {
        Date creationTime;
        AttributeMap attributes = this.getStoredOtpAttributes(req, resp);
        if (attributes == null) {
            return false;
        }
        String storedTime = attributes.getSingleValue(OTP_ATTR_TIME_KEY);
        try {
            creationTime = TimeUtil.decodeGeneralizedTime(storedTime);
        }
        catch (ParseException e) {
            logger.error((Object)"Error parsing Date for stored expiration, returning expired", (Throwable)e);
            return false;
        }
        Date now = new Date();
        long result = now.getTime() / 60000L - creationTime.getTime() / 60000L;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Number of minutes since token was generated: " + result));
        }
        return result > (long)durationValid.intValue();
    }
}

