/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.google.common.io.Files;
import com.pingidentity.pingcommons.util.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.request.IUploadFile;
import org.sourceid.common.Util;

public class SimpleFileUtil {
    private static final Log log = LogFactory.getLog(SimpleFileUtil.class);

    public static void writeFileSilent(File file, byte[] content) {
        try {
            SimpleFileUtil.writeFile(file, content);
        }
        catch (IOException e) {
            log.error((Object)("Cannot write file: " + file.getAbsolutePath()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] content) throws IOException {
        File parentFile = (file = file.getCanonicalFile()).getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Cannot create parent folder: " + parentFile.getAbsolutePath());
        }
        FileOutputStream fileOutputStream = null;
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Cannot create file: " + file.getAbsolutePath());
            }
            if (!file.isDirectory() && content != null && content.length > 0) {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(content);
            }
        }
        finally {
            Closer.close(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String pathToFile, byte[] content) throws IOException {
        File file = new File(pathToFile);
        File parentFile = (file = file.getCanonicalFile()).getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Cannot create parent folder: " + parentFile.getAbsolutePath());
        }
        FileOutputStream fileOutputStream = null;
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Cannot create file: " + file.getAbsolutePath());
            }
            if (!file.isDirectory() && content != null && content.length > 0) {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(content);
            }
        }
        finally {
            Closer.close(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) throws IOException {
        FileReader inStream = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            inStream = new FileReader(file);
            BufferedReader buffedIn = new BufferedReader(inStream);
            while ((line = buffedIn.readLine()) != null) {
                sb.append(line).append(Util.LINE_BREAK);
            }
            if (sb.length() > 0) {
                sb.delete(sb.lastIndexOf(Util.LINE_BREAK), sb.length());
            }
        }
        catch (Throwable throwable) {
            Closer.close(inStream);
            throw throwable;
        }
        Closer.close((Closeable)inStream);
        return sb.toString();
    }

    public static String readIUploadFileToString(IUploadFile file) throws IOException {
        int offset;
        String fileName = file.getFileName();
        long fileSize = file.getSize();
        InputStream stream = file.getStream();
        byte[] bytes = new byte[(int)fileSize];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = stream.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + fileName);
        }
        stream.close();
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String readFileToStringSilent(File file) {
        try {
            return SimpleFileUtil.readFileToString(file);
        }
        catch (IOException e) {
            log.error((Object)("Problem reading file " + file), (Throwable)e);
            return "";
        }
    }

    public static void deleteFile(String directory, String filename) {
        File f = new File(directory, filename);
        if (f.exists()) {
            if (f.delete()) {
                log.info((Object)("deleted file: " + f.getAbsolutePath()));
            } else {
                log.error((Object)("Cannot delete file: " + f.getAbsolutePath()));
            }
        } else {
            log.info((Object)("file " + f.getAbsolutePath() + " does not exist. Skipping."));
        }
    }

    public static void renameWithDateExt(File file) {
        String formatPattern = "MM-dd-yyyy.kk.mm.ss";
        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        String dateStr = format.format(new Date());
        File newName = new File(file.getAbsolutePath() + "." + dateStr);
        if (!file.renameTo(newName)) {
            log.error((Object)("Cannot rename file " + file.getAbsolutePath() + " to " + newName.getAbsolutePath()));
        }
    }

    public static void copyWithDateExt(File file) {
        String formatPattern = "MM-dd-yyyy.kk.mm.ss";
        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        String dateStr = format.format(new Date());
        File newName = new File(file.getAbsolutePath() + "." + dateStr);
        try {
            Files.copy((File)file, (File)newName);
        }
        catch (IOException e) {
            log.error((Object)("Cannot copy file " + file.getAbsolutePath() + " to " + newName.getAbsolutePath()));
        }
    }

    public static void deleteDirectoryFiles(String dirname) {
        SimpleFileUtil.deleteDirectoryFiles(dirname, false, null);
    }

    public static void deleteDirectoryFiles(String dirname, boolean deleteDirectory) {
        SimpleFileUtil.deleteDirectoryFiles(dirname, deleteDirectory, null);
    }

    public static void deleteDirectoryFiles(String dirname, boolean deleteDirectory, List<String> exceptions) {
        File clearDir = new File(dirname);
        if (clearDir.exists()) {
            boolean directoryContainsExceptions = false;
            String[] farr = clearDir.list();
            if (farr != null) {
                for (String aFarr : farr) {
                    File tmp = new File(clearDir, aFarr);
                    if (exceptions != null && exceptions.contains(tmp.getAbsolutePath())) {
                        directoryContainsExceptions = true;
                        continue;
                    }
                    log.trace((Object)("deleting file: " + tmp.getAbsolutePath() + " " + aFarr));
                    if (tmp.isDirectory()) {
                        SimpleFileUtil.deleteDirectoryFiles(tmp.getAbsolutePath(), true, exceptions);
                        continue;
                    }
                    if (tmp.delete()) {
                        log.trace((Object)("deleted file: " + tmp.getAbsolutePath()));
                        continue;
                    }
                    log.error((Object)("Cannot delete file: " + tmp.getAbsolutePath()));
                }
            }
            if (deleteDirectory && !directoryContainsExceptions) {
                if (clearDir.delete()) {
                    log.debug((Object)("deleted directory: " + clearDir.getAbsolutePath()));
                } else {
                    log.error((Object)("Cannot delete directory: " + clearDir.getAbsolutePath()));
                }
            }
        }
    }

    public static File createTempDirectory(String prefix) throws IOException {
        return SimpleFileUtil.createTempDirectory(prefix, null, null);
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return SimpleFileUtil.createTempDirectory(prefix, suffix, null);
    }

    public static File createTempDirectory(String prefix, String suffix, File parent) throws IOException {
        File tempDir = File.createTempFile(prefix, suffix, parent);
        if (!tempDir.delete()) {
            throw new IOException("Cannot delete temp file: " + tempDir.getAbsolutePath());
        }
        if (!tempDir.mkdir()) {
            throw new IOException("Cannot create temp directory: " + tempDir.getAbsolutePath());
        }
        return tempDir;
    }

    public static boolean fileExists(String pathToFile) {
        return new File(pathToFile).exists();
    }

    public static String getUniqueFileName(String pathToFile, String fileName) {
        int uniqueFactor = 1;
        String uniqueFileName = fileName + "." + Integer.toString(uniqueFactor);
        while (SimpleFileUtil.fileExists(pathToFile + uniqueFileName)) {
            uniqueFileName = fileName + "." + Integer.toString(++uniqueFactor);
        }
        return uniqueFileName;
    }
}

