/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class TinyHashSet<E>
extends HashSet<E> {
    private static final long serialVersionUID = 1L;
    private HashSet<Integer> hashSet;

    public TinyHashSet() {
        this.hashSet = new HashSet();
    }

    public TinyHashSet(Collection<? extends E> c) {
        this.hashSet = new HashSet(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public TinyHashSet(int initialCapacity, float loadFactor) {
        this.hashSet = new HashSet(initialCapacity, loadFactor);
    }

    public TinyHashSet(int initialCapacity) {
        this.hashSet = new HashSet(initialCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.hashSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hashSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.hashSet.contains(o.hashCode());
    }

    @Override
    public boolean add(E e) {
        return this.hashSet.add(e.hashCode());
    }

    @Override
    public boolean remove(Object o) {
        return this.hashSet.remove(o.hashCode());
    }

    @Override
    public void clear() {
        this.hashSet.clear();
    }

    @Override
    public Object clone() {
        TinyHashSet<E> newSet = new TinyHashSet<E>();
        newSet.hashSet = (HashSet)this.hashSet.clone();
        return newSet;
    }
}

