/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap;

import com.pingidentity.common.util.ldap.LDAPUtil;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.DurationArgument;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.datasource.info.LdapTypeNotFoundException;

public enum LDAPPasswordPolicy {
    AD_PSO_TYPE("msDS-MaximumPasswordAge", "msDS-PSOApplied", "msDS-PasswordSettings", "pwdLastSet"){

        @Override
        public Long passwordExpiryTime(String passwordExpiryValue, Attribute passwordChangedAttribute) {
            Long passwordExpiryTime = null;
            if (passwordExpiryValue != null && passwordChangedAttribute != null) {
                Date passwordChangedDate = LDAPUtil.convertAdTimestampToDate(passwordChangedAttribute.getValue());
                passwordExpiryTime = passwordChangedDate.getTime() + Long.parseLong(passwordExpiryValue) / -10000L;
            }
            return passwordExpiryTime;
        }
    }
    ,
    SUN_TYPE("pwdMaxAge", "passwordPolicySubentry", "*", "pwdChangedTime"){

        @Override
        public Long passwordExpiryTime(String passwordExpiryValue, Attribute passwordChangedAttribute) {
            Long passwordExpiryTime = null;
            if (passwordExpiryValue != null && passwordChangedAttribute != null) {
                Date passwordChangedDate = passwordChangedAttribute.getValueAsDate();
                passwordExpiryTime = passwordChangedDate.getTime() + Long.parseLong(passwordExpiryValue) * 1000L;
            }
            return passwordExpiryTime;
        }
    }
    ,
    OUD_TYPE("pwdMaxAge", "pwdPolicySubentry", "*", "pwdChangedTime"){

        @Override
        public Long passwordExpiryTime(String passwordExpiryValue, Attribute passwordChangedAttribute) {
            Long passwordExpiryTime = null;
            if (passwordExpiryValue != null && passwordChangedAttribute != null) {
                Date passwordChangedDate = passwordChangedAttribute.getValueAsDate();
                passwordExpiryTime = passwordChangedDate.getTime() + Long.parseLong(passwordExpiryValue) * 1000L;
            }
            return passwordExpiryTime;
        }
    }
    ,
    PING_DIRECTORY_ID_TYPE("ds-cfg-max-password-age", "ds-pwp-password-policy-dn", "ds-cfg-password-policy", "pwdChangedTime"){

        @Override
        public Long passwordExpiryTime(String passwordExpiryValue, Attribute passwordChangedAttribute) throws ArgumentException {
            Long passwordExpiryDuration;
            Long passwordExpiryTime = null;
            Date passwordChangedDate = passwordChangedAttribute.getValueAsDate();
            if (passwordExpiryValue != null && passwordChangedDate != null && (passwordExpiryDuration = Long.valueOf(DurationArgument.parseDuration((String)passwordExpiryValue, (TimeUnit)TimeUnit.MILLISECONDS))) != null) {
                passwordExpiryTime = passwordChangedDate.getTime() + passwordExpiryDuration;
            }
            return passwordExpiryTime;
        }
    }
    ,
    PING_DS_ID_TYPE("ds-cfg-max-password-age", "ds-pwp-password-policy-dn", "ds-cfg-password-policy", "pwdChangedTime"){

        @Override
        public Long passwordExpiryTime(String passwordExpiryValue, Attribute passwordChangedAttribute) throws ArgumentException {
            Long passwordExpiryDuration;
            Long passwordExpiryTime = null;
            Date passwordChangedDate = passwordChangedAttribute.getValueAsDate();
            if (passwordExpiryValue != null && passwordChangedDate != null && (passwordExpiryDuration = Long.valueOf(DurationArgument.parseDuration((String)passwordExpiryValue, (TimeUnit)TimeUnit.MILLISECONDS))) != null) {
                passwordExpiryTime = passwordChangedDate.getTime() + passwordExpiryDuration;
            }
            return passwordExpiryTime;
        }
    };

    String maxAgeAttributeName = null;
    String userPasswordPolicyDnAttributeName = null;
    String objectClassName = null;
    String passwordChangeTimeAttributeName = null;

    private LDAPPasswordPolicy(String maxAgeAttributeName, String userPasswordPolicyDnAttributeName, String objectClassName, String passwordChangeTimeAttributeName) {
        this.maxAgeAttributeName = maxAgeAttributeName;
        this.userPasswordPolicyDnAttributeName = userPasswordPolicyDnAttributeName;
        this.objectClassName = objectClassName;
        this.passwordChangeTimeAttributeName = passwordChangeTimeAttributeName;
    }

    public String getMaxAgeAttributeName() {
        return this.maxAgeAttributeName;
    }

    public String getUserPasswordPolicyDnAttributeName() {
        return this.userPasswordPolicyDnAttributeName;
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }

    public String getPasswordChangeTimeAttributeName() {
        return this.passwordChangeTimeAttributeName;
    }

    public static LDAPPasswordPolicy canonicalName(String ldapTypeName) {
        LdapInfo.LdapType ldapType = null;
        try {
            ldapType = LdapInfo.LdapType.canonicalName((String)ldapTypeName);
        }
        catch (LdapTypeNotFoundException e) {
            ldapType = LdapInfo.LdapType.Undefined;
        }
        if (ldapType != null) {
            switch (ldapType) {
                case ActiveDirectory: {
                    return AD_PSO_TYPE;
                }
                case SunDirectoryServer: {
                    return SUN_TYPE;
                }
                case OracleUnifiedDirectory: {
                    return OUD_TYPE;
                }
                case UnboundID: {
                    return PING_DIRECTORY_ID_TYPE;
                }
                case PingDirectory: {
                    return PING_DIRECTORY_ID_TYPE;
                }
                case PingDS: {
                    return PING_DS_ID_TYPE;
                }
            }
            return null;
        }
        return null;
    }

    public abstract Long passwordExpiryTime(String var1, Attribute var2) throws ArgumentException;

    public boolean returnsPwdExpiredControls(String controlValue) {
        return false;
    }
}

