/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap;

import com.pingidentity.common.util.ldap.SimplePaginationState;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class LDAPUtilOptions {
    private String searchBase;
    private String searchFilter;
    private int searchScope;
    private String[] attributes = new String[]{"*", "+"};
    private int count;
    private boolean sortReverseOrder;
    private List<String> sortBy = new ArrayList<String>();
    private int startIndex;
    private int resultsPerPage;
    private boolean retrieveLastElement = true;
    private SimplePaginationState paginationState;
    private boolean expectPasswordExpiryControl = false;
    private boolean enableServerSort = true;

    public LDAPUtilOptions(String searchBase, String searchFilter, int searchScope) {
        this.searchBase = searchBase;
        this.searchFilter = searchFilter;
        this.searchScope = searchScope;
    }

    public boolean isSortReverseOrder() {
        return this.sortReverseOrder;
    }

    public void setSortReverseOrder(boolean sortReverseOrder) {
        this.sortReverseOrder = sortReverseOrder;
    }

    public List<String> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public void setResultsPerPage(int count) {
        this.resultsPerPage = count;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public void setSearchScope(int searchScope) {
        this.searchScope = searchScope;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String[] attributes) {
        this.attributes = attributes;
    }

    public void addAttributes(String ... attribute) {
        this.attributes = (String[])ArrayUtils.addAll((Object[])this.attributes, (Object[])attribute);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isRetrieveLastElement() {
        return this.retrieveLastElement;
    }

    public void setRetrieveLastElement(boolean retrieveLastElement) {
        this.retrieveLastElement = retrieveLastElement;
    }

    public SimplePaginationState getPaginationState() {
        return this.paginationState;
    }

    public void setPaginationState(SimplePaginationState paginationState) {
        this.paginationState = paginationState;
    }

    public boolean isExpectPasswordExpiryControl() {
        return this.expectPasswordExpiryControl;
    }

    public void setExpectPasswordExpiryControl(boolean expectPasswordExpiryControl) {
        this.expectPasswordExpiryControl = expectPasswordExpiryControl;
    }

    public boolean isEnableServerSort() {
        return this.enableServerSort;
    }

    public void setEnableServerSort(boolean enableServerSort) {
        this.enableServerSort = enableServerSort;
    }
}

