/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap;

import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import org.sourceid.saml20.domain.mgmt.impl.SecretReferenceHelper;

public class SimpleBindPostConnectProcessor
implements PostConnectProcessor {
    private final String bindDN;
    private final String password;

    public SimpleBindPostConnectProcessor(String bindDN, String password) {
        this.bindDN = bindDN;
        this.password = password;
    }

    public void processPreAuthenticatedConnection(LDAPConnection ldapConnection) throws LDAPException {
        SecretReferenceHelper.Credentials credentials;
        try {
            SecretReferenceHelper secretReferenceHelper = new SecretReferenceHelper(this.password);
            credentials = secretReferenceHelper.getSecretInfo(this.bindDN);
        }
        catch (SecretManagerException e) {
            throw new LDAPException(ResultCode.INVALID_CREDENTIALS, (Throwable)e);
        }
        ldapConnection.bind((BindRequest)new SimpleBindRequest(credentials.getUsername(), credentials.getSecret()));
    }

    public void processPostAuthenticatedConnection(LDAPConnection ldapConnection) throws LDAPException {
    }
}

