/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.resiliency;

import com.pingidentity.common.util.BulkheadException;
import com.pingidentity.common.util.resiliency.BulkheadManager;
import com.pingidentity.common.util.resiliency.BulkheadMetricsMeter;
import com.pingidentity.common.util.resiliency.BulkheadNotificationService;
import com.pingidentity.common.util.resiliency.BulkheadStatus;
import com.pingidentity.common.util.resiliency.ResiliencyServiceReference;
import com.pingidentity.configservice.AutoReloadable;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class BulkheadManagerImpl
implements BulkheadManager,
AutoReloadable {
    public static final String BULKHEAD_MANAGER_ID = "Bulkhead";
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig(BulkheadManagerImpl.class);
    private static final String ENABLED = "Enabled";
    private static final String MAX_THREAD_POOL_USAGE = "MaxThreadPoolUsage";
    private static final String ENABLE_BACKOFF = "BackoffEnabled";
    private static final String HALF_OPEN_THREAD_POOL_USAGE = "BackOffThreadPoolUsage";
    private static final String HALF_OPEN_WAIT_DURATION = "BackOffDurationSeconds";
    private static final String THREAD_POOL_USAGE_WARNING_THRESHOLD = "ThreadPoolUsageWarningThreshold";
    private static final String NOTIFICATION_QUIET_PERIOD = "NotificationQuietPeriodMinutes";
    private static final Log log = LogFactory.getLog(BulkheadManagerImpl.class);
    private final Map<String, BulkheadStatus> bulkheadStatusMap = new ConcurrentHashMap<String, BulkheadStatus>();
    private BulkheadRegistry bulkheadRegistry;
    private MeterRegistry meterRegistry;
    private boolean enabled;
    private final boolean enableBackoff;
    private final Duration halfOpenWaitDuration;
    private BulkheadConfig backoffConfig;
    private BulkheadConfig closedConfig;
    private final Duration queitPeriodDuration;
    private Instant bulkheadWarning = Instant.MIN;
    private Instant bulkheadAlert = Instant.MIN;
    private int threadPoolUsageWarningCalls;

    public BulkheadManagerImpl() {
        this.enabled = configStore.getBooleanValue(ENABLED, false);
        this.enableBackoff = configStore.getBooleanValue(ENABLE_BACKOFF, false);
        this.halfOpenWaitDuration = Duration.ofSeconds(configStore.getIntValue(HALF_OPEN_WAIT_DURATION, 30));
        this.queitPeriodDuration = Duration.ofMinutes(configStore.getIntValue(NOTIFICATION_QUIET_PERIOD, 15));
        double maxThreadPoolUsage = configStore.getDoubleValue(MAX_THREAD_POOL_USAGE, 0.8);
        double halfOpenThreadPoolUsage = configStore.getDoubleValue(HALF_OPEN_THREAD_POOL_USAGE, 0.4);
        double threadPoolUsageWarningThreshold = configStore.getDoubleValue(THREAD_POOL_USAGE_WARNING_THRESHOLD, 0.7);
        String runtimeThreadsMax = System.getProperty("pf.runtime.threads.max");
        if (StringUtils.isNotEmpty((String)runtimeThreadsMax)) {
            try {
                int maxRuntimeThreads = Integer.parseInt(runtimeThreadsMax);
                int maxConcurrentCalls = (int)Math.floor((double)maxRuntimeThreads * maxThreadPoolUsage);
                int halfOpenMaxConcurrentCalls = (int)Math.floor((double)maxRuntimeThreads * halfOpenThreadPoolUsage);
                this.threadPoolUsageWarningCalls = (int)Math.floor((double)maxRuntimeThreads * threadPoolUsageWarningThreshold);
                this.closedConfig = BulkheadConfig.custom().maxConcurrentCalls(maxConcurrentCalls).maxWaitDuration(Duration.ofSeconds(0L)).build();
                this.backoffConfig = BulkheadConfig.custom().maxConcurrentCalls(halfOpenMaxConcurrentCalls).maxWaitDuration(Duration.ofSeconds(0L)).build();
            }
            catch (NumberFormatException e) {
                log.error((Object)"pf.runtime.threads.max is not a valid number. Bulkhead manager will not be enabled.");
                this.enabled = false;
            }
        } else {
            log.error((Object)"pf.runtime.threads.max is not set. Bulkhead manager will not be enabled.");
            this.enabled = false;
        }
        if (this.enabled) {
            this.initializeRegistries();
            BulkheadNotificationService.getInstance().start();
        }
    }

    private void initializeRegistries() {
        this.bulkheadRegistry = BulkheadRegistry.of((BulkheadConfig)this.closedConfig);
        BulkheadMetricsMeter bulkheadMetricsMeter = new BulkheadMetricsMeter(this.bulkheadRegistry, this.bulkheadStatusMap, this.backoffConfig);
        this.meterRegistry = new SimpleMeterRegistry();
        bulkheadMetricsMeter.bindTo(this.meterRegistry);
    }

    @Override
    public String getResiliencyManagerId() {
        return BULKHEAD_MANAGER_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResiliencyServiceReference initializeServiceInstance(String name) {
        Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(name, this.closedConfig);
        BulkheadStatus bulkheadStatus = this.bulkheadStatusMap.computeIfAbsent(bulkhead.getName(), k -> BulkheadStatus.CLOSED_STATE());
        if (this.enableBackoff && bulkheadStatus.getState() == BulkheadStatus.BulkheadState.HALF_OPEN) {
            if (bulkheadStatus.checkIfHalfOpenDurationElapsed()) {
                log.debug((Object)("Back off period has elapsed. Increasing bulkhead limits. Max thread usage: " + this.closedConfig.getMaxConcurrentCalls()));
                bulkheadStatus.transitionHalfOpenToClosed();
            } else if (this.getInUseCalls(bulkhead) >= this.backoffConfig.getMaxConcurrentCalls()) {
                Counter exceptionCounter = this.getBulkheadMeters().find("exception.count").tag("bulkhead", bulkhead.getName()).counter();
                if (exceptionCounter != null) {
                    exceptionCounter.increment();
                }
                throw new BulkheadException(bulkhead.getName());
            }
        }
        try {
            this.acquireBulkhead(bulkhead);
        }
        catch (BulkheadException e) {
            if (this.enableBackoff && bulkheadStatus.getState() == BulkheadStatus.BulkheadState.CLOSED) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adjusting bulkhead limits to Back off thread usage limit. Max thread usage: " + this.backoffConfig.getMaxConcurrentCalls()));
                }
                Bulkhead bulkhead2 = bulkhead;
                synchronized (bulkhead2) {
                    bulkheadStatus.transitionClosedToHalfOpen(this.halfOpenWaitDuration);
                }
            }
            throw e;
        }
        return new ResiliencyServiceReference(bulkhead.getName(), this.getResiliencyManagerId());
    }

    private void acquireBulkhead(Bulkhead bulkhead) {
        if (bulkhead.tryAcquirePermission()) {
            int maxConcurrentCalls = bulkhead.getMetrics().getMaxAllowedConcurrentCalls();
            int inUseCalls = this.getInUseCalls(bulkhead);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Acquired bulkhead " + bulkhead.getName() + ". Using " + inUseCalls + " of " + maxConcurrentCalls + " concurrent calls"));
            }
            if (this.checkSendBulkheadWarningNotification(inUseCalls, bulkhead.getName())) {
                this.sendBulkheadWarningNotification(bulkhead.getName(), inUseCalls, maxConcurrentCalls);
            }
        } else {
            log.error((Object)("Could not acquire bulkhead " + bulkhead.getName()));
            int maxConcurrentCalls = bulkhead.getMetrics().getMaxAllowedConcurrentCalls();
            int inUseCalls = this.getInUseCalls(bulkhead);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bulkhead " + bulkhead.getName() + ". Using " + inUseCalls + " of " + maxConcurrentCalls + " concurrent calls"));
            }
            if (this.checkSendBulkheadFullNotification(bulkhead.getName())) {
                this.sendBulkheadFullNotification(bulkhead.getName(), inUseCalls, maxConcurrentCalls);
            }
            throw new BulkheadException(bulkhead.getName());
        }
    }

    @Override
    public void cleanUpServiceInstance(String name) {
        log.debug((Object)("Releasing bulkhead " + name));
        Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(name);
        bulkhead.onComplete();
    }

    private boolean checkSendBulkheadFullNotification(String bulkheadName) {
        BulkheadStatus bulkheadStatus = this.bulkheadStatusMap.computeIfAbsent(bulkheadName, k -> BulkheadStatus.CLOSED_STATE());
        if (bulkheadStatus.getState() == BulkheadStatus.BulkheadState.HALF_OPEN) {
            return false;
        }
        Instant quietPeriodEnds = this.bulkheadAlert;
        if (quietPeriodEnds == null || Instant.now().isAfter(quietPeriodEnds)) {
            this.bulkheadAlert = quietPeriodEnds = Instant.now().plus(this.queitPeriodDuration);
            return true;
        }
        return false;
    }

    private boolean checkSendBulkheadWarningNotification(int inUseCalls, String bulkheadName) {
        BulkheadStatus bulkheadStatus = this.bulkheadStatusMap.computeIfAbsent(bulkheadName, k -> BulkheadStatus.CLOSED_STATE());
        if (bulkheadStatus.getState() == BulkheadStatus.BulkheadState.HALF_OPEN) {
            return false;
        }
        if (inUseCalls < this.threadPoolUsageWarningCalls) {
            return false;
        }
        Instant quietPeriodEnds = this.bulkheadWarning;
        if (quietPeriodEnds == null || Instant.now().isAfter(quietPeriodEnds)) {
            this.bulkheadWarning = quietPeriodEnds = Instant.now().plus(this.queitPeriodDuration);
            return true;
        }
        log.debug((Object)("Bulkhead warning threshold exceeded. Not sending notification as quiet period is not over yet. Ends at " + quietPeriodEnds));
        return false;
    }

    private void sendBulkheadFullNotification(String bulkheadName, int inUseCalls, int maxCalls) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("BULKHEAD_ID", bulkheadName);
        params.put("IN_USE_CALLS", inUseCalls);
        params.put("MAX_CALLS", maxCalls);
        BulkheadNotificationService.BulkheadNotificationEvent event = new BulkheadNotificationService.BulkheadNotificationEvent(bulkheadName, params);
        BulkheadNotificationService.getInstance().registerAlertEvent(event);
    }

    private void sendBulkheadWarningNotification(String bulkheadName, int inUseCalls, int maxCalls) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("BULKHEAD_ID", bulkheadName);
        params.put("IN_USE_CALLS", inUseCalls);
        params.put("MAX_CALLS", maxCalls);
        BulkheadNotificationService.BulkheadNotificationEvent event = new BulkheadNotificationService.BulkheadNotificationEvent(bulkheadName, params);
        BulkheadNotificationService.getInstance().registerWarning(event);
    }

    private int getInUseCalls(Bulkhead bulkhead) {
        int availableCalls = bulkhead.getMetrics().getAvailableConcurrentCalls();
        int maxConcurrentCalls = bulkhead.getMetrics().getMaxAllowedConcurrentCalls();
        return maxConcurrentCalls - availableCalls;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public MeterRegistry getBulkheadMeters() {
        return this.meterRegistry;
    }
}

