/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.resiliency;

import java.time.Duration;
import java.time.Instant;

public class BulkheadStatus {
    private BulkheadState state;
    private Instant bulkheadWaitDurationElapsedTime;

    public BulkheadStatus(BulkheadState state) {
        this.state = state;
    }

    public BulkheadState getState() {
        return this.state;
    }

    public static BulkheadStatus CLOSED_STATE() {
        return new BulkheadStatus(BulkheadState.CLOSED);
    }

    public void transitionClosedToHalfOpen(Duration waitDuration) {
        this.state = BulkheadState.HALF_OPEN;
        this.bulkheadWaitDurationElapsedTime = Instant.now().plus(waitDuration);
    }

    public void transitionHalfOpenToClosed() {
        this.state = BulkheadState.CLOSED;
    }

    public boolean checkIfHalfOpenDurationElapsed() {
        return Instant.now().isAfter(this.bulkheadWaitDurationElapsedTime);
    }

    public static enum BulkheadState {
        CLOSED,
        HALF_OPEN;

    }
}

