/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.resiliency;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.resiliency.BulkheadManager;
import com.pingidentity.common.util.resiliency.NoOpResiliencyManager;
import com.pingidentity.common.util.resiliency.ResiliencyManager;
import com.pingidentity.common.util.resiliency.ResiliencyManagerFactory;
import com.pingidentity.configservice.AutoReloadable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ResiliencyManagerFactoryImpl
implements ResiliencyManagerFactory,
AutoReloadable {
    private final Map<String, Supplier<ResiliencyManager>> resiliencyManagersMap = new HashMap<String, Supplier<ResiliencyManager>>();
    private final BulkheadManager bulkheadManager;

    public ResiliencyManagerFactoryImpl(BulkheadManager bulkheadManager) {
        this.bulkheadManager = bulkheadManager;
        String[] serviceNames = new String[]{"attribute-source", "connection-token", "http-request", "ldap-credential-validator", "data-source", "account-linking", "session-storage-manager", "client-manager", "access-grant-manager", "secret-manager", "kerberos.kdc.request", "connection.ars", "connection.jwks"};
        if (bulkheadManager.isEnabled()) {
            for (String serviceName : serviceNames) {
                this.resiliencyManagersMap.put(serviceName, () -> bulkheadManager);
            }
        }
    }

    @Override
    public ResiliencyManager getResiliencyManager(ServiceInformation serviceInformation) {
        if (serviceInformation != null) {
            return this.getResiliencyManager(serviceInformation.getServiceName());
        }
        return this.getDefault();
    }

    @Override
    public ResiliencyManager getResiliencyManager(String serviceName) {
        return this.resiliencyManagersMap.getOrDefault(serviceName, NoOpResiliencyManager::getInstance).get();
    }

    @Override
    public ResiliencyManager getResiliencyManagerById(String id) {
        if ("Bulkhead".equals(id)) {
            return this.bulkheadManager;
        }
        return this.getDefault();
    }

    @Override
    public ResiliencyManager getDefault() {
        return NoOpResiliencyManager.getInstance();
    }

    private static class ServiceNames {
        private static final String ATTRIBUTE_SOURCE = "attribute-source";
        private static final String CONNECTION_TOKEN = "connection-token";
        private static final String HTTP_REQUEST = "http-request";
        private static final String LDAP_CREDENTIAL_VALIDATOR = "ldap-credential-validator";
        private static final String DATA_SOURCE = "data-source";
        private static final String ACCOUNT_LINKING = "account-linking";
        private static final String SESSION_STORAGE_MANAGER = "session-storage-manager";
        private static final String CLIENT_MANAGER = "client-manager";
        private static final String ACCESS_GRANT_MANAGER = "access-grant-manager";
        private static final String SECRET_MANAGER = "secret-manager";
        private static final String KERBEROS_KDC_REQUEST = "kerberos.kdc.request";
        private static final String CONNECTION_ARS_ENDPOINT = "connection.ars";
        private static final String CONNECTION_JWKS_ENDPOINT = "connection.jwks";

        private ServiceNames() {
        }
    }
}

