/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.timers;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.ConnectionInfo;
import com.pingidentity.common.util.resiliency.ResiliencyManager;
import com.pingidentity.common.util.resiliency.ResiliencyServiceReference;
import com.pingidentity.common.util.timers.EventTimer;
import com.pingidentity.monitoring.metrics.MeterManager;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DSEventTimer
extends EventTimer {
    private static final String DATA_STORE_ID = "dataStoreId";
    private static final String DATA_STORE_NAME = "dataStoreName";
    private static final String DATA_STORE_TYPE = "dataStoreType";
    private static final String DATA_STORE_USED_BY = "dataStoreUsedBy";
    private static final String LDAP = "LDAP";
    private static final String OTHER = "OTHER";
    private static final String JDBC = "JDBC";
    public static final String TEST_CONNECTION_EVENT = "test-connection";
    public static final String CREATE_CONNECTION_POOL_EVENT = "create-connection-pool";
    public static final String CLOSE_CONNECTION_POOL_EVENT = "close-connection-pool";

    private DSEventTimer(String timerName, String eventType, Map<String, Object> attributes) {
        super(timerName, eventType, attributes);
    }

    public static DSEventTimer getJdbcInstance(String dataStoreName, String eventType, ServiceInformation serviceInformation) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(DATA_STORE_ID, dataStoreName);
        attributes.put(DATA_STORE_NAME, dataStoreName);
        attributes.put(DATA_STORE_TYPE, JDBC);
        if (serviceInformation != null) {
            attributes.put(DATA_STORE_USED_BY, serviceInformation.getServiceName());
        }
        ResiliencyManager resiliencyManager = resiliencyManagerFactory.getResiliencyManager(serviceInformation);
        ResiliencyServiceReference resiliencyServiceReference = resiliencyManager.initializeServiceInstance(dataStoreName);
        attributes.put("resiliencyServiceReference", resiliencyServiceReference);
        return new DSEventTimer(DSEventTimer.class.getSimpleName(), eventType, attributes);
    }

    public static DSEventTimer getLdapInstance(String dataStoreId, String dataStoreName, String eventType, ServiceInformation serviceInformation) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(DATA_STORE_ID, dataStoreId);
        attributes.put(DATA_STORE_NAME, dataStoreName);
        attributes.put(DATA_STORE_TYPE, LDAP);
        if (serviceInformation != null) {
            attributes.put(DATA_STORE_USED_BY, serviceInformation.getServiceName());
        }
        ResiliencyManager resiliencyManager = resiliencyManagerFactory.getResiliencyManager(serviceInformation);
        ResiliencyServiceReference resiliencyServiceReference = resiliencyManager.initializeServiceInstance(dataStoreId);
        attributes.put("resiliencyServiceReference", resiliencyServiceReference);
        return new DSEventTimer(DSEventTimer.class.getSimpleName(), eventType, attributes);
    }

    public static DSEventTimer getLdapInstance(ConnectionInfo connectionInfo, String eventType, ServiceInformation serviceInformation) {
        return DSEventTimer.getLdapInstance(connectionInfo.getId(), connectionInfo.getName(), eventType, serviceInformation);
    }

    public static DSEventTimer getOtherInstance(String dataStoreId, String dataStoreName, String eventType, ServiceInformation serviceInformation) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(DATA_STORE_ID, dataStoreId);
        attributes.put(DATA_STORE_NAME, dataStoreName);
        attributes.put(DATA_STORE_TYPE, OTHER);
        ResiliencyManager resiliencyManager = resiliencyManagerFactory.getResiliencyManager(serviceInformation);
        ResiliencyServiceReference resiliencyServiceReference = resiliencyManager.initializeServiceInstance(dataStoreId);
        attributes.put("resiliencyServiceReference", resiliencyServiceReference);
        return new DSEventTimer(DSEventTimer.class.getSimpleName(), eventType, attributes);
    }

    public static DSEventTimer getDynamoDBInstance(String eventType, ServiceInformation serviceInformation) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(DATA_STORE_TYPE, "dynamodb");
        String bulkheadId = "dynamodb-" + (serviceInformation != null ? serviceInformation.getServiceName() : "unknown");
        ResiliencyManager resiliencyManager = resiliencyManagerFactory.getResiliencyManager(serviceInformation);
        ResiliencyServiceReference resiliencyServiceReference = resiliencyManager.initializeServiceInstance(bulkheadId);
        attributes.put("resiliencyServiceReference", resiliencyServiceReference);
        return new DSEventTimer(DSEventTimer.class.getSimpleName(), eventType, attributes);
    }

    @Override
    public void close() {
        this.cleanupResiliencyServiceInstance();
        Duration duration = Duration.ofMillis(System.currentTimeMillis() - this.getStartTime());
        super.done(duration.toMillis());
        if (!TEST_CONNECTION_EVENT.equals(this.getEventType())) {
            String dataStoreType = this.getStringValueFromAttributes(DATA_STORE_TYPE);
            String dataStoreId = this.getStringValueFromAttributes(DATA_STORE_ID);
            MeterManager.getInstance().getDataStoreResponseTimeTimer(dataStoreType, dataStoreId).record(duration);
        }
    }

    public static void incrementJdbcErrors(String dataStoreId) {
        MeterManager.getInstance().getDataStoreErrorsCounter(JDBC, dataStoreId).increment();
    }

    public static void incrementLdapErrors(String dataStoreId) {
        MeterManager.getInstance().getDataStoreErrorsCounter(LDAP, dataStoreId).increment();
    }

    public static void incrementOtherErrors(String dataStoreId) {
        MeterManager.getInstance().getDataStoreErrorsCounter(OTHER, dataStoreId).increment();
    }
}

