/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.timers.jdbc;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.timers.DSEventTimer;
import com.pingidentity.common.util.timers.EventTimer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class TimedStatement
implements Statement {
    private final Statement ws;
    private final String dataStoreName;
    private final ServiceInformation serviceInformation;

    public TimedStatement(Statement statement, String dataStoreName, ServiceInformation serviceInformation) {
        this.ws = statement;
        this.dataStoreName = dataStoreName;
        this.serviceInformation = serviceInformation;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute-query", this.serviceInformation);
        try {
            ResultSet resultSet = this.ws.executeQuery(sql);
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute-update", this.serviceInformation);
        try {
            int n = this.ws.executeUpdate(sql);
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.ws.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.ws.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ws.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.ws.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.ws.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ws.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.ws.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.ws.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.ws.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.ws.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ws.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ws.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute", this.serviceInformation);
        try {
            boolean bl = this.ws.execute(sql);
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.ws.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.ws.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.ws.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ws.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.ws.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ws.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.ws.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.ws.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.ws.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ws.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ws.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute-batch", this.serviceInformation);
        try {
            int[] nArray = this.ws.executeBatch();
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return nArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ws.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.ws.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ws.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute-update", this.serviceInformation);
        try {
            int n = this.ws.executeUpdate(sql, autoGeneratedKeys);
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute-update", this.serviceInformation);
        try {
            int n = this.ws.executeUpdate(sql, columnIndexes);
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute-update", this.serviceInformation);
        try {
            int n = this.ws.executeUpdate(sql, columnNames);
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute", this.serviceInformation);
        try {
            boolean bl = this.ws.execute(sql, autoGeneratedKeys);
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute", this.serviceInformation);
        try {
            boolean bl = this.ws.execute(sql, columnIndexes);
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        DSEventTimer ignored = DSEventTimer.getJdbcInstance(this.dataStoreName, "execute", this.serviceInformation);
        try {
            boolean bl = this.ws.execute(sql, columnNames);
            if (ignored != null) {
                ((EventTimer)ignored).close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ((EventTimer)ignored).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                DSEventTimer.incrementJdbcErrors(this.dataStoreName);
                throw e;
            }
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.ws.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.ws.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ws.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.ws.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ws.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.ws.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ws.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ws.isWrapperFor(iface);
    }
}

