/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.xml;

import org.sourceid.common.IDGenerator;

public class XmlIDUtil {
    private static final char[] NCNAME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-_".toCharArray();
    private static final char[] NCNAME_FIRST_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_".toCharArray();
    private static final int DEFAULT_LENGTH = XmlIDUtil.calculateLength(Math.pow(2.0, 160.0));

    public static String createID() {
        return XmlIDUtil.createID(DEFAULT_LENGTH);
    }

    public static String createID(double minCollisionSpace) {
        return XmlIDUtil.createID(XmlIDUtil.calculateLength(minCollisionSpace));
    }

    public static String createID(int length) {
        return IDGenerator.rndStr(1, NCNAME_FIRST_CHARS) + IDGenerator.rndStr(length - 1, NCNAME_CHARS);
    }

    static int calculateLength(double minCollisionSpace) {
        if (minCollisionSpace < 1.0) {
            return 1;
        }
        double val = Math.log(minCollisionSpace / (double)NCNAME_FIRST_CHARS.length) / Math.log(NCNAME_CHARS.length);
        return (int)Math.ceil(val) + 1;
    }
}

