/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;

public class XmlUtils {
    public static void prettyPrint(Element xmlElement, Writer writer) {
        try {
            Transformer transformer = XmlUtils.getTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            DOMSource source = new DOMSource(xmlElement);
            transformer.transform(source, new StreamResult(writer));
        }
        catch (Exception e) {
            try {
                writer.write(e.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String prettyPrint(Element xmlElement) {
        StringWriter writer = new StringWriter();
        XmlUtils.prettyPrint(xmlElement, writer);
        return writer.toString();
    }

    public static byte[] element2bytes(Element docXml) throws Exception {
        String PROPERTY_QUALIFIED_NAME = "{http://xml.apache.org/xslt}indent-amount";
        String PROPERTY_VALUE = "4";
        try {
            Transformer transformer = XmlUtils.getTransformer();
            transformer.setOutputProperty(PROPERTY_QUALIFIED_NAME, PROPERTY_VALUE);
            DOMSource source = new DOMSource(docXml);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            transformer.transform(source, new StreamResult(os));
            return os.toByteArray();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private static Transformer getTransformer() throws TransformerConfigurationException, IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        return tFactory.newTransformer();
    }

    public static String prettyPrint(String xml) {
        StreamSource source = new StreamSource(new StringReader(xml));
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = XmlUtils.getTransformer();
            transformer.transform(source, new StreamResult(writer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }
}

