/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice;

import com.pingidentity.configservice.ReloadRegisterable;
import com.pingidentity.configservice.Reloadable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadRegistry
implements ReloadRegisterable {
    private static final Log log = LogFactory.getLog(ReloadRegistry.class);
    private Collection<WeakReference<Reloadable>> reloadables = new LinkedList<WeakReference<Reloadable>>();
    private final boolean logReloads;

    public ReloadRegistry() {
        this(false);
    }

    public ReloadRegistry(boolean logReloads) {
        this.logReloads = logReloads;
    }

    @Override
    public synchronized void registerForReloadEvents(Reloadable reloadable) {
        WeakReference<Reloadable> wr = new WeakReference<Reloadable>(reloadable);
        this.reloadables.add(wr);
    }

    public synchronized void unregisterForReloadEvents(Reloadable toRemove) {
        if (toRemove == null) {
            return;
        }
        this.reloadables.removeIf(ref -> toRemove.equals(ref.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        ArrayList<Reloadable> toReload = new ArrayList<Reloadable>();
        ReloadRegistry reloadRegistry = this;
        synchronized (reloadRegistry) {
            Iterator<WeakReference<Reloadable>> i = this.reloadables.iterator();
            while (i.hasNext()) {
                WeakReference<Reloadable> wrr = i.next();
                Reloadable reloadable = (Reloadable)wrr.get();
                if (reloadable != null) {
                    toReload.add(reloadable);
                    continue;
                }
                i.remove();
            }
        }
        for (Reloadable reloadable : toReload) {
            if (this.logReloads) {
                log.debug((Object)("Calling reload on " + reloadable));
            }
            reloadable.reload();
            if (!this.logReloads) continue;
            log.debug((Object)("Finished reloading " + reloadable));
        }
    }
}

