/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.configservice.XmlLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.config.ConfigurationException;

public abstract class AbstractXmlLoader
implements XmlLoader {
    protected Log log = LogFactory.getLog(this.getClass());

    protected abstract XmlObject loadRawXml(String var1, String var2);

    public abstract void saveRawXml(String var1, String var2, XmlObject var3, XmlOptions var4);

    @Override
    public XmlObject load(String directory, String filename) {
        XmlObject o = this.loadRawXml(directory, filename);
        this.validate(directory, filename, o);
        return o;
    }

    @Override
    public void save(String directory, String filename, XmlObject doc) {
        XmlOptions options = XmlBeansUtil.getXmlOptions();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            doc.save((OutputStream)outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            this.load(inputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to save the XMLObject", e);
        }
        this.saveRawXml(directory, filename, doc, options);
    }

    protected void validate(String directory, String filename, XmlObject xmlObject) {
        try {
            XmlBeansUtil.validate(xmlObject);
        }
        catch (InvalidXmlException e) {
            this.log.error((Object)(directory + File.separator + filename + " is not valid."), (Throwable)e);
        }
    }
}

