/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.configservice.impl.ConfigStoreRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigStoreLocation;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.config.impl.xml.ConfigDocument;
import org.sourceid.config.impl.xml.ConfigType;
import org.sourceid.config.impl.xml.ItemType;
import org.sourceid.config.impl.xml.ListType;
import org.sourceid.config.impl.xml.MapType;

public class ConfigStoreImpl
implements ConfigStore,
AutoReloadable {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final ConfigStoreRegistry configRegistry = ConfigStoreRegistry.getInstance();
    private final XmlLoader xmlLoader = GlobalRegistry.getService(XmlLoader.class);
    protected Map<String, Object> configMap;
    protected ConfigDocument configDoc;
    protected String configFileName;
    protected ConfigStoreLocation location;
    public static final String XML_SUFFIX = ".xml";
    private boolean batchUpdateInProgress = false;
    private List<DeferredUpdate> deferredUpdates = new ArrayList<DeferredUpdate>();

    public ConfigStoreImpl(ConfigStoreLocation location, String name) {
        this.location = location;
        this.configFileName = name + XML_SUFFIX;
        this.parseDoc();
    }

    private synchronized Object getValue(String keyname) {
        return this.configMap.get(keyname);
    }

    private synchronized boolean containsKey(String keyname) {
        return this.configMap.containsKey(keyname);
    }

    @Override
    public String getStringValue(String keyname) throws NoSuchValueException {
        Object o = this.getValue(keyname);
        if (o != null && !(o instanceof List) && !(o instanceof Map)) {
            configRegistry.registerEntry(this, this.configFileName, keyname, o);
            return o.toString();
        }
        String message = "Unable to locate configuration string value for: " + keyname + " in " + this.configFileName;
        throw new NoSuchValueException(message + " whole map: " + this.configMap);
    }

    @Override
    public String getStringValue(String keyname, String defaultValue) {
        Object o = this.getValue(keyname);
        String retV = o != null && !(o instanceof List) && !(o instanceof Map) ? o.toString() : defaultValue;
        configRegistry.registerEntry(this, this.configFileName, keyname, retV);
        return retV;
    }

    @Override
    public int getIntValue(String keyname) throws NoSuchValueException {
        Object o = this.getValue(keyname);
        String msg = "Unable to locate int configuration value for: " + keyname + " in " + this.configFileName;
        if (o != null) {
            try {
                int val = Integer.parseInt(o.toString());
                configRegistry.registerEntry(this, this.configFileName, keyname, val);
                return val;
            }
            catch (ClassCastException | NullPointerException | NumberFormatException e) {
                throw new NoSuchValueException(msg, e);
            }
        }
        throw new NoSuchValueException(msg);
    }

    @Override
    public int getIntValue(String keyname, int defaultValue) {
        int retV = defaultValue;
        if (this.containsKey(keyname)) {
            try {
                retV = this.getIntValue(keyname);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
        }
        configRegistry.registerEntry(this, this.configFileName, keyname, retV);
        return retV;
    }

    @Override
    public long getLongValue(String keyname) throws NoSuchValueException {
        Object o = this.getValue(keyname);
        String msg = "Unable to locate int configuration value for: " + keyname + " in " + this.configFileName;
        if (o != null) {
            try {
                long val = Long.parseLong(o.toString());
                configRegistry.registerEntry(this, this.configFileName, keyname, val);
                return val;
            }
            catch (ClassCastException | NullPointerException | NumberFormatException e) {
                throw new NoSuchValueException(msg, e);
            }
        }
        throw new NoSuchValueException(msg);
    }

    @Override
    public long getLongValue(String keyname, long defaultValue) {
        long retV = defaultValue;
        if (this.containsKey(keyname)) {
            try {
                retV = this.getLongValue(keyname);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
        }
        configRegistry.registerEntry(this, this.configFileName, keyname, retV);
        return retV;
    }

    @Override
    public double getDoubleValue(String keyname) throws NoSuchValueException {
        Object o = this.getValue(keyname);
        String msg = "Unable to locate int configuration value for: " + keyname + " in " + this.configFileName;
        if (o != null) {
            try {
                double val = Double.parseDouble(o.toString());
                configRegistry.registerEntry(this, this.configFileName, keyname, val);
                return val;
            }
            catch (ClassCastException | NullPointerException | NumberFormatException e) {
                throw new NoSuchValueException(msg, e);
            }
        }
        throw new NoSuchValueException(msg);
    }

    @Override
    public double getDoubleValue(String keyname, double defaultValue) {
        double retV = defaultValue;
        if (this.containsKey(keyname)) {
            try {
                retV = this.getDoubleValue(keyname);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
        }
        configRegistry.registerEntry(this, this.configFileName, keyname, retV);
        return retV;
    }

    @Override
    public boolean getBooleanValue(String keyname) throws NoSuchValueException {
        boolean retV;
        Object value = this.getValue(keyname);
        try {
            retV = Boolean.parseBoolean(value.toString());
        }
        catch (Exception e) {
            String msg = "Unable to locate boolean configuration value for: " + keyname + " in " + this.configFileName;
            throw new NoSuchValueException(msg, e);
        }
        configRegistry.registerEntry(this, this.configFileName, keyname, retV);
        return retV;
    }

    @Override
    public boolean getBooleanValue(String keyname, boolean defaultValue) {
        boolean retV = defaultValue;
        Object value = this.getValue(keyname);
        if (value != null) {
            retV = Boolean.parseBoolean(value.toString());
        }
        configRegistry.registerEntry(this, this.configFileName, keyname, retV);
        return retV;
    }

    @Override
    public Map getMapValue(String keyname) throws NoSuchValueException {
        Object o = this.getValue(keyname);
        if (o instanceof Map) {
            configRegistry.registerEntry(this, this.configFileName, keyname, o);
            return (Map)o;
        }
        String message = "Unable to locate configuration map value for: " + keyname + " in " + this.configFileName;
        throw new NoSuchValueException(message);
    }

    @Override
    public Map getMapValue(String keyname, Map defaultValue) {
        Object o = this.getValue(keyname);
        Map value = o instanceof Map ? (Map)o : defaultValue;
        configRegistry.registerEntry(this, this.configFileName, keyname, value);
        return value;
    }

    @Override
    public boolean isMapValue(String keyname) {
        Object o = this.getValue(keyname);
        return o instanceof Map;
    }

    @Override
    public List<String> getListValue(String keyname) throws NoSuchValueException {
        Object o = this.getValue(keyname);
        if (o instanceof List) {
            configRegistry.registerEntry(this, this.configFileName, keyname, o);
            return (List)o;
        }
        String message = "Unable to locate configuration list value for: " + keyname + " in " + this.configFileName;
        throw new NoSuchValueException(message);
    }

    @Override
    public List<String> getListValue(String keyname, List<String> defaultValue) {
        Object o = this.getValue(keyname);
        List retList = o instanceof List ? (List)o : defaultValue;
        configRegistry.registerEntry(this, this.configFileName, keyname, retList);
        return retList;
    }

    @Override
    public boolean isListValue(String keyname) {
        Object o = this.getValue(keyname);
        return o instanceof List;
    }

    private static boolean isNotEmptyFile(String filename) {
        boolean retV = false;
        File file = new File(filename);
        if (file.exists() && file.length() > 0L) {
            retV = true;
        }
        return retV;
    }

    protected synchronized void parseDoc() {
        String configStoreDir = this.location.getDirectory();
        String fullFileName = configStoreDir + File.separator + this.configFileName;
        if (this.xmlLoader != null && this.xmlLoader.xmlExists(configStoreDir, this.configFileName) && ConfigStoreImpl.isNotEmptyFile(fullFileName)) {
            MapType[] maps;
            ItemType[] items;
            this.log.debug((Object)("Loading config file: " + fullFileName));
            ConfigDocument newDoc = (ConfigDocument)this.xmlLoader.load(configStoreDir, this.configFileName);
            ConfigType cfg = newDoc.getConfig();
            LinkedHashMap<String, Object> newConfigMap = new LinkedHashMap<String, Object>();
            for (ItemType item : items = cfg.getItemArray()) {
                newConfigMap.put(item.getName(), item.getStringValue());
                configRegistry.registerEntry(this, this.configFileName, item.getName(), item.getStringValue());
            }
            for (MapType mapType : maps = cfg.getMapArray()) {
                ItemType[] mapItems;
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                String mapName = mapType.getName();
                for (ItemType item : mapItems = mapType.getItemArray()) {
                    map.put(item.getName(), item.getStringValue());
                }
                newConfigMap.put(mapName, map);
                configRegistry.registerEntry(this, this.configFileName, mapName, map);
            }
            for (MapType mapType : cfg.getListArray()) {
                List<String> list = Arrays.asList(mapType.getListItemArray());
                String listName = mapType.getName();
                newConfigMap.put(listName, list);
                configRegistry.registerEntry(this, this.configFileName, listName, list);
            }
            this.configMap = newConfigMap;
            this.configDoc = newDoc;
        } else {
            if (this.xmlLoader == null) {
                this.log.warn((Object)"XmlLoader is not configured.");
            }
            this.configMap = new LinkedHashMap<String, Object>();
            this.configDoc = ConfigDocument.Factory.newInstance();
            this.configDoc.addNewConfig();
        }
    }

    @Override
    public void setStringValue(String keyname, String value) {
        this.setValue(keyname, value);
    }

    @Override
    public void setMapValue(String keyname, Map value) {
        this.setValue(keyname, value);
    }

    @Override
    public void setIntValue(String keyname, int value) {
        this.setValue(keyname, value);
    }

    @Override
    public void setBooleanValue(String keyname, boolean value) {
        this.setValue(keyname, value);
    }

    @Override
    public void setLongValue(String keyname, long value) {
        this.setValue(keyname, value);
    }

    @Override
    public void setDoubleValue(String keyname, double value) {
        this.setValue(keyname, value);
    }

    @Override
    public void setListValue(String keyname, List<String> value) {
        this.setValue(keyname, value);
    }

    @Override
    public synchronized void startBatchUpdate() {
        this.batchUpdateInProgress = true;
    }

    @Override
    public synchronized void commitBatchUpdate() {
        for (DeferredUpdate deferred : this.deferredUpdates) {
            deferred.doIt();
        }
        this.saveFile();
        this.deferredUpdates = new ArrayList<DeferredUpdate>();
        this.batchUpdateInProgress = false;
    }

    @Override
    public synchronized void cancelBatchUpdate() {
        this.deferredUpdates = new ArrayList<DeferredUpdate>();
        this.batchUpdateInProgress = false;
    }

    @Override
    public synchronized void clearValue(String keyname) {
        if (this.getValue(keyname) != null) {
            this.setValue(keyname, null);
        }
    }

    private synchronized void setValue(final String keyname, final Object value) {
        if (this.batchUpdateInProgress) {
            this.deferredUpdates.add(new DeferredUpdate(){

                @Override
                public void doIt() {
                    ConfigStoreImpl.this.realSetValue(keyname, value);
                }
            });
        } else {
            this.realSetValue(keyname, value);
            this.saveFile();
        }
    }

    private synchronized void realSetValue(String keyname, Object value) {
        configRegistry.registerEntry(this, this.configFileName, keyname, value);
        if (value != null) {
            this.configMap.put(keyname, value);
        } else {
            this.configMap.remove(keyname);
        }
        this.setDocValue(keyname, value);
    }

    private synchronized void saveFile() {
        String configStoreDir = this.location.getDirectory();
        this.xmlLoader.save(configStoreDir, this.configFileName, (XmlObject)this.configDoc);
    }

    private synchronized void setDocValue(String keyName, Object value) {
        ConfigType cfgType = this.configDoc.getConfig();
        if (value == null) {
            ItemType[] items = cfgType.getItemArray();
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].getName().equals(keyName)) continue;
                cfgType.removeItem(i);
            }
            MapType[] maps = cfgType.getMapArray();
            for (int i = 0; i < maps.length; ++i) {
                if (!maps[i].getName().equals(keyName)) continue;
                cfgType.removeMap(i);
            }
            ListType[] lists = cfgType.getListArray();
            for (int i = 0; i < lists.length; ++i) {
                if (!lists[i].getName().equals(keyName)) continue;
                cfgType.removeList(i);
            }
        } else if (value instanceof String || value instanceof Boolean || value instanceof Number) {
            ItemType[] items = cfgType.getItemArray();
            ItemType theItem = null;
            for (ItemType item : items) {
                if (!keyName.equals(item.getName())) continue;
                theItem = item;
                break;
            }
            if (theItem == null) {
                theItem = cfgType.addNewItem();
                theItem.setName(keyName);
            }
            if (value instanceof String) {
                theItem.setStringValue((String)value);
            } else {
                theItem.setStringValue(value.toString());
            }
        } else if (value instanceof Map) {
            MapType[] maps = cfgType.getMapArray();
            MapType map = null;
            for (MapType m : maps) {
                if (!keyName.equals(m.getName())) continue;
                map = m;
                break;
            }
            if (map == null) {
                map = cfgType.addNewMap();
                map.setName(keyName);
            }
            Map mapValue = (Map)value;
            ArrayList<ItemType> items = new ArrayList<ItemType>();
            for (Object obj : mapValue.keySet()) {
                String itemkeyname = (String)obj;
                ItemType item = map.addNewItem();
                item.setName(itemkeyname);
                Object o = mapValue.get(itemkeyname);
                String s = o != null ? o.toString() : "";
                item.setStringValue(s);
                items.add(item);
            }
            map.setItemArray(items.toArray(new ItemType[items.size()]));
        } else if (value instanceof List) {
            ListType listType = null;
            for (ListType lt : cfgType.getListArray()) {
                if (!lt.getName().equals(keyName)) continue;
                listType = lt;
                break;
            }
            if (listType == null) {
                listType = cfgType.addNewList();
                listType.setName(keyName);
            }
            List listValue = (List)value;
            String[] strings = listValue.toArray(new String[listValue.size()]);
            listType.setListItemArray(strings);
        }
    }

    @Override
    public synchronized void reload() {
        this.parseDoc();
    }

    @Override
    public synchronized Set<String> getKeys() {
        return new HashSet<String>(this.configMap.keySet());
    }

    @Override
    public boolean isFilePresent() {
        return ConfigStoreFarm.getStoreNameSet(this.location).contains(this.configFileName.substring(0, this.configFileName.lastIndexOf(XML_SUFFIX)));
    }

    @Override
    public String getNameCorrectCase() {
        String name = this.configFileName.substring(0, this.configFileName.lastIndexOf(XML_SUFFIX));
        for (String storeName : ConfigStoreFarm.getStoreNameSet(this.location)) {
            if (!storeName.equalsIgnoreCase(name) || storeName.equals(name)) continue;
            return storeName;
        }
        return null;
    }

    private static interface DeferredUpdate {
        public void doIt();
    }
}

