/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.configservice.impl.ConfigStoreRegistry;
import com.pingidentity.configservice.impl.ConfigStoreRegistryEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ConfigStoreRegistryImpl
extends ConfigStoreRegistry {
    private static Map<String, ConfigStoreRegistryEntry> table = new Hashtable<String, ConfigStoreRegistryEntry>();

    ConfigStoreRegistryImpl() {
    }

    @Override
    public synchronized List<String> getKeyList() {
        Set<String> keys = table.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keys);
        Collections.sort(keyList);
        return keyList;
    }

    @Override
    public synchronized ConfigStoreRegistryEntry getEntry(String key) {
        return table.get(key);
    }

    @Override
    public synchronized void registerEntry(Object instance, String configFileName, String name, Object value) {
        ConfigStoreRegistryEntry entry;
        String uri;
        if (value instanceof Map) {
            this.removeMapEntries(configFileName, name);
            Map map = (Map)value;
            for (String itemName : map.keySet()) {
                Object itemValue;
                ConfigStoreRegistryEntry entry2 = new ConfigStoreRegistryEntry(instance, configFileName, ConfigStoreRegistryEntry.VALUE_CATEGORY.MAP, name, itemName, itemValue = map.get(itemName));
                String uri2 = entry2.getURI();
                if (uri2 == null) continue;
                table.put(uri2, entry2);
            }
        } else if (!(value instanceof List) && (uri = (entry = new ConfigStoreRegistryEntry(instance, configFileName, name, value)).getURI()) != null) {
            table.put(uri, entry);
        }
    }

    private synchronized void removeMapEntries(String configFileName, String name) {
        HashSet<String> keys = new HashSet<String>(table.keySet());
        String prefix = ConfigStoreRegistryEntry.makeMapUriPrefix(configFileName, name);
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            table.remove(key);
        }
    }

    public synchronized String toString() {
        Object result = "";
        for (String key : this.getKeyList()) {
            result = (String)result + table.get(key) + "\n";
        }
        return result;
    }
}

