/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.PasswordFile;
import com.pingidentity.hsm.NCipherStarter;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.CoreConfig;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.util.SystemUtil;

public class CoreConfigImpl
implements CoreConfig,
AutoReloadable {
    private static String CFG_KEYSTORENAME_DSIG = "DsigKeystoreName";
    private static String CFG_KEYSTOREPASS_DSIG = "DsigKeystorePassword";
    private static String CFG_KEYSTORETYPE_DSIG = "DsigKeystoreType2";
    private static String CFG_PRIVATEKEYPASSWORDS_DSIG = "DsigPrivateKeyPasswords";
    private static String CFG_HSM_KEYSTORENAME_DSIG = "DsigHSMKeystoreName";
    private static String CFG_HSM_KEYSTOREPASS_DSIG = "DsigHSMKeystorePassword";
    private static String CFG_HSM_KEYSTORETYPE_DSIG = "DsigHSMKeystoreType2";
    private static String CFG_HSM_PRIVATEKEYPASSWORDS_DSIG = "DsigHSMPrivateKeyPasswords";
    private static String CFG_KEYSTORENAME_GENERAL = "GeneralKeystoreName";
    private static String CFG_KEYSTOREPASS_GENERAL = "GeneralKeystorePassword";
    private static String CFG_KEYSTORETYPE_GENERAL = "GeneralKeystoreType2";
    private static String CFG_PRIVATEKEYPASSWORDS_GENERAL = "GeneralPrivateKeyPasswords";
    private static String CFG_HSM_KEYSTORENAME_GENERAL = "GeneralHSMKeystoreName";
    private static String CFG_HSM_KEYSTOREPASS_GENERAL = "GeneralHSMKeystorePassword";
    private static String CFG_HSM_KEYSTORETYPE_GENERAL = "GeneralHSMKeystoreType2";
    private static String CFG_HSM_PRIVATEKEYPASSWORDS_GENERAL = "GeneralHSMPrivateKeyPasswords";
    private static String CFG_KEYSTORENAME_SSL = "SslKeystoreName";
    private static String CFG_KEYSTOREPASS_SSL = "SslKeystorePassword";
    private static String CFG_KEYSTORETYPE_SSL = "SslKeystoreType2";
    private static String CFG_PRIVATEKEYPASSWORDS_SSL = "SslPrivateKeyPasswords";
    private static String CFG_HSM_KEYSTORENAME_SSL = "SslHSMKeystoreName";
    private static String CFG_HSM_KEYSTOREPASS_SSL = "SslHSMKeystorePassword";
    private static String CFG_HSM_KEYSTORETYPE_SSL = "SslHSMKeystoreType2";
    private static String CFG_HSM_PRIVATEKEYPASSWORDS_SSL = "SslHSMPrivateKeyPasswords";
    private static String CFG_KEYSTORENAME_SSL_SERVER = "SslServerKeystoreName";
    private static String CFG_KEYSTOREPASS_SSL_SERVER = "SslServerKeystorePassword";
    private static String CFG_KEYSTORETYPE_SSL_SERVER = "SslServerKeystoreType2";
    private static String CFG_PRIVATEKEYPASSWORDS_SSL_SERVER = "SslServerPrivateKeyPasswords";
    private static String CFG_HSM_KEYSTORENAME_SSL_SERVER = "SslServerHSMKeystoreName";
    private static String CFG_HSM_KEYSTOREPASS_SSL_SERVER = "SslServerHSMKeystorePassword";
    private static String CFG_HSM_KEYSTORETYPE_SSL_SERVER = "SslServerHSMKeystoreType2";
    private static String CFG_HSM_PRIVATEKEYPASSWORDS_SSL_SERVER = "SslServerHSMPrivateKeyPasswords";
    private static String CFG_KEYSTORENAME_TRUST = "TrustKeystoreName";
    private static String CFG_KEYSTOREPASS_TRUST = "TrustKeystorePassword";
    private static String CFG_KEYSTORETYPE_TRUST = "TrustKeystoreType2";
    private static String CFG_HSM_KEYSTORENAME_TRUST = "TrustHSMKeystoreName";
    private static String CFG_HSM_KEYSTOREPASS_TRUST = "TrustHSMKeystorePassword";
    private static String CFG_HSM_KEYSTORETYPE_TRUST = "TrustHSMKeystoreType2";
    private static final String FIPS_KEY = "pf.hsm.mode";
    private static final String NCIPHER_MODE = "ncipher";
    private final Log log = LogFactory.getLog(CoreConfigImpl.class);
    private final ConfigStore cfg = ConfigStoreFarm.getConfig(CoreConfig.class);
    private FieldObfuscator fieldObfuscator = FieldObfuscator.REAL;
    private static final int PASSWORD_LENGTH = 24;
    private Map<String, Boolean> wellKnownPasswordMap = new HashMap<String, Boolean>();

    public CoreConfigImpl() {
        if (!PropertyInfo.isBCFIPSMode() || PropertyInfo.isFipsAllowUnapprovedAlgorithms()) {
            this.wellKnownPasswordMap.put(this.fieldObfuscator.deobfuscate("1fzHIOQ2xKZUCxw6vLN4XHJB3n9paqfAQn55QkD3xhU="), Boolean.TRUE);
            this.wellKnownPasswordMap.put(this.fieldObfuscator.deobfuscate("9oIOkbbb5MOYnoUvJpAGxRGP7cWOsLTT"), Boolean.TRUE);
            this.wellKnownPasswordMap.put(this.fieldObfuscator.deobfuscate("vYusUUluaGnzB8Z+VFu2d7YX1tGYP+9P"), Boolean.TRUE);
            this.wellKnownPasswordMap.put(this.fieldObfuscator.deobfuscate("yUDVMCGo2ru4Yj/CzRy52D4xXEsWJdQH"), Boolean.TRUE);
            this.wellKnownPasswordMap.put(this.fieldObfuscator.deobfuscate("4ulBLKTFobvDrMO4rociZA=="), Boolean.TRUE);
        }
        if (NCIPHER_MODE.equalsIgnoreCase(System.getProperty(FIPS_KEY)) && !NCipherStarter.isIgnorePassphrase()) {
            this.log.debug((Object)"nCipher Mode detected.  Setting keystore passwords to value in hsmpasswd.txt");
            SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
            String hsmPassword = null;
            try {
                hsmPassword = PasswordFile.getAndDeobfuscateHSMPassword(sysDirInfo.getDataDirectory());
            }
            catch (ObfuscationException ex) {
                SystemUtil.hardShutdown("Error occurred de-obfuscating", ex);
            }
            this.setTrustHSMKeystorePassword(hsmPassword);
            this.setDsigHSMKeystorePassword(hsmPassword);
            this.setSslServerHSMKeystorePassword(hsmPassword);
            this.setSslHSMKeystorePassword(hsmPassword);
            this.setGeneralHSMKeystorePassword(hsmPassword);
        }
    }

    @Override
    public void setDsigPrivateKeyPassword(String alias, String password) {
        this.setPrivateKeyPassword(alias, password, this.getCFG_PRIVATEKEYPASSWORDS_DSIG());
    }

    @Override
    public void setDsigHSMPrivateKeyPassword(String alias, String password) {
        this.setPrivateKeyPassword(alias, password, this.getCFG_HSM_PRIVATEKEYPASSWORDS_DSIG());
    }

    @Override
    public void setSslPrivateKeyPassword(String alias, String password) {
        this.setPrivateKeyPassword(alias, password, this.getCFG_PRIVATEKEYPASSWORDS_SSL());
    }

    @Override
    public void setSslServerPrivateKeyPassword(String alias, String password) {
        this.setPrivateKeyPassword(alias, password, this.getCFG_PRIVATEKEYPASSWORDS_SSL_SERVER());
    }

    @Override
    public void setSslServerHSMPrivateKeyPassword(String alias, String password) {
        this.setPrivateKeyPassword(alias, password, this.getCFG_HSM_PRIVATEKEYPASSWORDS_SSL_SERVER());
    }

    @Override
    public void setGeneralPrivateKeyPassword(String alias, String password) {
        this.setPrivateKeyPassword(alias, password, this.getCFG_PRIVATEKEYPASSWORDS_GENERAL());
    }

    public void setPrivateKeyPassword(String alias, String password, String confKey) {
        Map privateKeys = this.cfg.getMapValue(confKey, new HashMap());
        if (password != null) {
            privateKeys.put(alias, this.fieldObfuscator.obfuscate(password));
        } else {
            privateKeys.remove(alias);
        }
        this.cfg.setMapValue(confKey, privateKeys);
    }

    @Override
    public String getDsigKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_KEYSTORENAME_DSIG(), "ping-dsig.jks");
    }

    @Override
    public String getDsigHSMKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_HSM_KEYSTORENAME_DSIG(), "ping-dsig.hsmks");
    }

    @Override
    public String getDsigKeystorePassword() {
        return this.getStorePassword(this.getCFG_KEYSTOREPASS_DSIG());
    }

    @Override
    public String getDsigHSMKeystorePassword() {
        return this.getStorePassword(this.getCFG_HSM_KEYSTOREPASS_DSIG());
    }

    @Override
    public String getOrCreateStrongDsigKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(CFG_KEYSTOREPASS_DSIG);
    }

    @Override
    public String getOrCreateStrongDsigHSMKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(CFG_HSM_KEYSTOREPASS_DSIG);
    }

    @Override
    public void setDsigKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_KEYSTOREPASS_DSIG(), this.fieldObfuscator.obfuscate(password));
    }

    @Override
    public void setDsigHSMKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_HSM_KEYSTOREPASS_DSIG(), this.fieldObfuscator.obfuscate(password));
    }

    @Override
    public String getDsigPrivateKeyPassword(String alias) {
        Map privateKeys;
        try {
            privateKeys = this.cfg.getMapValue(this.getCFG_PRIVATEKEYPASSWORDS_DSIG());
        }
        catch (NoSuchValueException e) {
            throw new ConfigurationException(e);
        }
        return this.fieldObfuscator.deobfuscate((String)privateKeys.get(alias));
    }

    @Override
    public String getDsigHSMPrivateKeyPassword(String alias) {
        Map privateKeys;
        try {
            privateKeys = this.cfg.getMapValue(this.getCFG_HSM_PRIVATEKEYPASSWORDS_DSIG());
        }
        catch (NoSuchValueException e) {
            throw new ConfigurationException(e);
        }
        return this.fieldObfuscator.deobfuscate((String)privateKeys.get(alias));
    }

    @Override
    public String getGeneralKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_KEYSTORENAME_GENERAL(), "ping-general.jks");
    }

    @Override
    public String getGeneralKeystorePassword() {
        return this.getStorePassword(this.getCFG_KEYSTOREPASS_GENERAL());
    }

    @Override
    public String getOrCreateStrongGeneralKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(CFG_KEYSTOREPASS_GENERAL);
    }

    @Override
    public void setGeneralKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_KEYSTOREPASS_GENERAL(), this.fieldObfuscator.obfuscate(password));
    }

    @Override
    public String getGeneralPrivateKeyPassword(String alias) {
        Map privateKeys;
        try {
            privateKeys = this.cfg.getMapValue(this.getCFG_PRIVATEKEYPASSWORDS_GENERAL());
        }
        catch (NoSuchValueException e) {
            throw new ConfigurationException(e);
        }
        return this.fieldObfuscator.deobfuscate((String)privateKeys.get(alias));
    }

    private String getOrMakeStrongKeystorePassword(String storePassName) {
        String storePass = this.getStorePassword(storePassName);
        if (storePass == null || "".equals(storePass) || this.wellKnownPasswordMap.get(storePass) != null) {
            storePass = IDGenerator.rndAlphaNumeric(24);
            this.cfg.setStringValue(storePassName, this.fieldObfuscator.obfuscate(storePass));
        }
        return storePass;
    }

    @Override
    public String getSslKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_KEYSTORENAME_SSL(), "ping-ssl.jks");
    }

    @Override
    public String getSslKeystorePassword() {
        return this.getStorePassword(this.getCFG_KEYSTOREPASS_SSL());
    }

    @Override
    public String getOrCreateStrongSslKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(this.getCFG_KEYSTOREPASS_SSL());
    }

    @Override
    public void setSslKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_KEYSTOREPASS_SSL(), this.fieldObfuscator.obfuscate(password));
    }

    private String getStorePassword(String itemName) {
        String passwd = null;
        String rawPass = this.cfg.getStringValue(itemName, null);
        if (!StringUtils.isEmpty((String)rawPass)) {
            passwd = this.fieldObfuscator.deobfuscate(rawPass);
        } else {
            passwd = IDGenerator.rndAlphaNumeric(24);
            this.cfg.setStringValue(itemName, this.fieldObfuscator.obfuscate(passwd));
        }
        return passwd;
    }

    @Override
    public String getSslPrivateKeyPassword(String alias) {
        Map privateKeys;
        try {
            privateKeys = this.cfg.getMapValue(this.getCFG_PRIVATEKEYPASSWORDS_SSL());
        }
        catch (NoSuchValueException e) {
            throw new ConfigurationException(e);
        }
        return this.fieldObfuscator.deobfuscate((String)privateKeys.get(alias));
    }

    @Override
    public String getSslServerKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_KEYSTORENAME_SSL_SERVER(), "ping-ssl-server.jks");
    }

    @Override
    public String getSslServerHSMKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_HSM_KEYSTORENAME_SSL_SERVER(), "ping-ssl-server.hsmks");
    }

    @Override
    public String getSslServerKeystorePassword() {
        return this.getStorePassword(this.getCFG_KEYSTOREPASS_SSL_SERVER());
    }

    @Override
    public String getSslServerHSMKeystorePassword() {
        return this.getStorePassword(this.getCFG_HSM_KEYSTOREPASS_SSL_SERVER());
    }

    @Override
    public String getOrCreateStrongSslServerKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(this.getCFG_KEYSTOREPASS_SSL_SERVER());
    }

    @Override
    public String getOrCreateStrongSslServerHSMKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(this.getCFG_HSM_KEYSTOREPASS_SSL_SERVER());
    }

    @Override
    public void setSslServerKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_KEYSTOREPASS_SSL_SERVER(), this.fieldObfuscator.obfuscate(password));
    }

    @Override
    public void setSslServerHSMKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_HSM_KEYSTOREPASS_SSL_SERVER(), this.fieldObfuscator.obfuscate(password));
    }

    @Override
    public String getSslServerPrivateKeyPassword(String alias) {
        Map privateKeys;
        try {
            privateKeys = this.cfg.getMapValue(this.getCFG_PRIVATEKEYPASSWORDS_SSL_SERVER());
        }
        catch (NoSuchValueException e) {
            throw new ConfigurationException(e);
        }
        return this.fieldObfuscator.deobfuscate((String)privateKeys.get(alias));
    }

    @Override
    public String getSslServerHSMPrivateKeyPassword(String alias) {
        Map privateKeys;
        try {
            privateKeys = this.cfg.getMapValue(this.getCFG_HSM_PRIVATEKEYPASSWORDS_SSL_SERVER());
        }
        catch (NoSuchValueException e) {
            throw new ConfigurationException(e);
        }
        return this.fieldObfuscator.deobfuscate((String)privateKeys.get(alias));
    }

    @Override
    public String getTrustKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_KEYSTORENAME_SSL_TRUST(), "ping-trust.jks");
    }

    @Override
    public String getTrustKeystorePassword() {
        return this.getStorePassword(this.getCFG_KEYSTOREPASS_SSL_TRUST());
    }

    @Override
    public String getOrCreateStrongTrustKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(this.getCFG_KEYSTOREPASS_SSL_TRUST());
    }

    @Override
    public void setTrustKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_KEYSTOREPASS_SSL_TRUST(), this.fieldObfuscator.obfuscate(password));
    }

    protected String getCFG_KEYSTORENAME_DSIG() {
        return CFG_KEYSTORENAME_DSIG;
    }

    protected String getCFG_HSM_KEYSTORENAME_DSIG() {
        return CFG_HSM_KEYSTORENAME_DSIG;
    }

    protected String getCFG_KEYSTOREPASS_DSIG() {
        return CFG_KEYSTOREPASS_DSIG;
    }

    protected String getCFG_HSM_KEYSTOREPASS_DSIG() {
        return CFG_HSM_KEYSTOREPASS_DSIG;
    }

    protected String getCFG_PRIVATEKEYPASSWORDS_DSIG() {
        return CFG_PRIVATEKEYPASSWORDS_DSIG;
    }

    protected String getCFG_HSM_PRIVATEKEYPASSWORDS_DSIG() {
        return CFG_HSM_PRIVATEKEYPASSWORDS_DSIG;
    }

    protected String getCFG_KEYSTORENAME_GENERAL() {
        return CFG_KEYSTORENAME_GENERAL;
    }

    protected String getCFG_HSM_KEYSTORENAME_GENERAL() {
        return CFG_HSM_KEYSTORENAME_GENERAL;
    }

    protected String getCFG_KEYSTOREPASS_GENERAL() {
        return CFG_KEYSTOREPASS_GENERAL;
    }

    protected String getCFG_HSM_KEYSTOREPASS_GENERAL() {
        return CFG_HSM_KEYSTOREPASS_GENERAL;
    }

    protected String getCFG_PRIVATEKEYPASSWORDS_GENERAL() {
        return CFG_PRIVATEKEYPASSWORDS_GENERAL;
    }

    protected String getCFG_HSM_PRIVATEKEYPASSWORDS_GENERAL() {
        return CFG_HSM_PRIVATEKEYPASSWORDS_GENERAL;
    }

    protected String getCFG_KEYSTORENAME_SSL() {
        return CFG_KEYSTORENAME_SSL;
    }

    protected String getCFG_HSM_KEYSTORENAME_SSL() {
        return CFG_HSM_KEYSTORENAME_SSL;
    }

    protected String getCFG_KEYSTORENAME_SSL_SERVER() {
        return CFG_KEYSTORENAME_SSL_SERVER;
    }

    protected String getCFG_HSM_KEYSTORENAME_SSL_SERVER() {
        return CFG_HSM_KEYSTORENAME_SSL_SERVER;
    }

    protected String getCFG_KEYSTORENAME_SSL_TRUST() {
        return CFG_KEYSTORENAME_TRUST;
    }

    protected String getCFG_HSM_KEYSTORENAME_SSL_TRUST() {
        return CFG_HSM_KEYSTORENAME_TRUST;
    }

    protected String getCFG_KEYSTOREPASS_SSL() {
        return CFG_KEYSTOREPASS_SSL;
    }

    protected String getCFG_HSM_KEYSTOREPASS_SSL() {
        return CFG_HSM_KEYSTOREPASS_SSL;
    }

    protected String getCFG_SSL_KEYSTOREPASS_SSL() {
        return CFG_HSM_KEYSTOREPASS_SSL;
    }

    protected String getCFG_KEYSTOREPASS_SSL_SERVER() {
        return CFG_KEYSTOREPASS_SSL_SERVER;
    }

    protected String getCFG_HSM_KEYSTOREPASS_SSL_SERVER() {
        return CFG_HSM_KEYSTOREPASS_SSL_SERVER;
    }

    protected String getCFG_KEYSTOREPASS_SSL_TRUST() {
        return CFG_KEYSTOREPASS_TRUST;
    }

    protected String getCFG_HSM_KEYSTOREPASS_SSL_TRUST() {
        return CFG_HSM_KEYSTOREPASS_TRUST;
    }

    protected String getCFG_PRIVATEKEYPASSWORDS_SSL() {
        return CFG_PRIVATEKEYPASSWORDS_SSL;
    }

    protected String getCFG_HSM_PRIVATEKEYPASSWORDS_SSL() {
        return CFG_HSM_PRIVATEKEYPASSWORDS_SSL;
    }

    protected String getCFG_PRIVATEKEYPASSWORDS_SSL_SERVER() {
        return CFG_PRIVATEKEYPASSWORDS_SSL_SERVER;
    }

    protected String getCFG_HSM_PRIVATEKEYPASSWORDS_SSL_SERVER() {
        return CFG_HSM_PRIVATEKEYPASSWORDS_SSL_SERVER;
    }

    @Override
    public String getKeyStoreType(String storeFileName) {
        String retType = "default";
        if (storeFileName != null) {
            if (storeFileName.equals(this.getDsigKeystoreName())) {
                retType = this.cfg.getStringValue(CFG_KEYSTORETYPE_DSIG, retType);
            } else if (storeFileName.equals(this.getSslKeystoreName())) {
                retType = this.cfg.getStringValue(CFG_KEYSTORETYPE_SSL, retType);
            } else if (storeFileName.equals(this.getSslServerKeystoreName())) {
                retType = this.cfg.getStringValue(CFG_KEYSTORETYPE_SSL_SERVER, retType);
            } else if (storeFileName.equals(this.getTrustKeystoreName())) {
                retType = this.cfg.getStringValue(CFG_KEYSTORETYPE_TRUST, retType);
            } else if (storeFileName.equals(this.getGeneralKeystoreName())) {
                retType = this.cfg.getStringValue(CFG_KEYSTORETYPE_GENERAL, retType);
            }
            if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
                if (storeFileName.equals(this.getTrustKeystoreName())) {
                    retType = this.cfg.getStringValue(CFG_HSM_KEYSTORETYPE_TRUST, retType);
                } else if (storeFileName.equals(this.getGeneralHSMKeystoreName())) {
                    retType = this.cfg.getStringValue(CFG_HSM_KEYSTORETYPE_GENERAL, retType);
                } else if (storeFileName.equals(this.getSslServerHSMKeystoreName())) {
                    retType = this.cfg.getStringValue(CFG_HSM_KEYSTORETYPE_SSL_SERVER, retType);
                } else if (storeFileName.equals(this.getSslHSMKeystoreName())) {
                    retType = this.cfg.getStringValue(CFG_HSM_KEYSTORETYPE_SSL, retType);
                } else if (storeFileName.equals(this.getDsigHSMKeystoreName())) {
                    retType = this.cfg.getStringValue(CFG_HSM_KEYSTORETYPE_DSIG, retType);
                }
            }
        }
        return retType;
    }

    @Override
    public Set<String> getAliases(String storeFileName) {
        Set aliases = null;
        if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode() && StringUtils.isNotBlank((String)storeFileName)) {
            try {
                if (storeFileName.equals(this.getGeneralHSMKeystoreName())) {
                    Map map = this.cfg.getMapValue(this.getCFG_HSM_PRIVATEKEYPASSWORDS_GENERAL());
                    aliases = map.keySet();
                } else if (storeFileName.equals(this.getSslServerHSMKeystoreName())) {
                    Map map = this.cfg.getMapValue(this.getCFG_HSM_PRIVATEKEYPASSWORDS_SSL_SERVER());
                    aliases = map.keySet();
                } else if (storeFileName.equals(this.getSslHSMKeystoreName())) {
                    Map map = this.cfg.getMapValue(this.getCFG_HSM_PRIVATEKEYPASSWORDS_SSL());
                    aliases = map.keySet();
                } else if (storeFileName.equals(this.getDsigHSMKeystoreName())) {
                    Map map = this.cfg.getMapValue(this.getCFG_HSM_PRIVATEKEYPASSWORDS_DSIG());
                    aliases = map.keySet();
                }
            }
            catch (NoSuchValueException ex) {
                this.log.debug((Object)ex);
            }
        }
        return aliases;
    }

    @Override
    public String getSslHSMKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_HSM_KEYSTORENAME_SSL(), "ping-ssl.hsmks");
    }

    @Override
    public String getSslHSMKeystorePassword() {
        return this.getStorePassword(this.getCFG_HSM_KEYSTOREPASS_SSL());
    }

    @Override
    public String getOrCreateStrongSslHSMKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(this.getCFG_HSM_KEYSTOREPASS_SSL());
    }

    @Override
    public String getSslHSMPrivateKeyPassword(String alias) {
        Map privateKeys;
        try {
            privateKeys = this.cfg.getMapValue(this.getCFG_HSM_PRIVATEKEYPASSWORDS_SSL());
        }
        catch (NoSuchValueException e) {
            throw new ConfigurationException(e);
        }
        return this.fieldObfuscator.deobfuscate((String)privateKeys.get(alias));
    }

    @Override
    public void setSslHSMPrivateKeyPassword(String alias, String password) {
        this.setPrivateKeyPassword(alias, password, this.getCFG_HSM_PRIVATEKEYPASSWORDS_SSL());
    }

    @Override
    public void setSslHSMKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_HSM_KEYSTOREPASS_SSL(), this.fieldObfuscator.obfuscate(password));
    }

    @Override
    public String getGeneralHSMKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_HSM_KEYSTORENAME_GENERAL(), "ping-general.hsmks");
    }

    @Override
    public String getGeneralHSMKeystorePassword() {
        return this.getStorePassword(this.getCFG_HSM_KEYSTOREPASS_GENERAL());
    }

    @Override
    public String getOrCreateStrongGeneralHSMKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(CFG_HSM_KEYSTOREPASS_GENERAL);
    }

    @Override
    public String getGeneralHSMPrivateKeyPassword(String alias) {
        Map privateKeys;
        try {
            privateKeys = this.cfg.getMapValue(this.getCFG_HSM_PRIVATEKEYPASSWORDS_GENERAL());
        }
        catch (NoSuchValueException e) {
            throw new ConfigurationException(e);
        }
        return this.fieldObfuscator.deobfuscate((String)privateKeys.get(alias));
    }

    @Override
    public void setGeneralHSMPrivateKeyPassword(String alias, String password) {
        this.setPrivateKeyPassword(alias, password, this.getCFG_HSM_PRIVATEKEYPASSWORDS_GENERAL());
    }

    @Override
    public void setGeneralHSMKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_HSM_KEYSTOREPASS_GENERAL(), this.fieldObfuscator.obfuscate(password));
    }

    @Override
    public String getTrustHSMKeystoreName() {
        return this.cfg.getStringValue(this.getCFG_HSM_KEYSTORENAME_SSL_TRUST(), "ping-trust.hsmks");
    }

    @Override
    public String getTrustHSMKeystorePassword() {
        return this.getStorePassword(this.getCFG_HSM_KEYSTOREPASS_SSL_TRUST());
    }

    @Override
    public String getOrCreateStrongTrustHSMKeystorePassword() {
        return this.getOrMakeStrongKeystorePassword(this.getCFG_HSM_KEYSTOREPASS_SSL_TRUST());
    }

    @Override
    public void setTrustHSMKeystorePassword(String password) {
        this.cfg.setStringValue(this.getCFG_HSM_KEYSTOREPASS_SSL_TRUST(), this.fieldObfuscator.obfuscate(password));
    }

    @Override
    public KeyStore.PasswordProtection getPasswordForAlias(String keystoreName, String alias) {
        KeyStore.PasswordProtection passwordProtection = null;
        String entryPassword = null;
        if (this.getSslKeystoreName().equals(keystoreName)) {
            entryPassword = this.getSslPrivateKeyPassword(alias);
        } else if (this.getSslServerKeystoreName().equals(keystoreName)) {
            entryPassword = this.getSslServerPrivateKeyPassword(alias);
        } else if (this.getDsigKeystoreName().equals(keystoreName)) {
            entryPassword = this.getDsigPrivateKeyPassword(alias);
        } else if (this.getGeneralKeystoreName().equals(keystoreName)) {
            entryPassword = this.getGeneralPrivateKeyPassword(alias);
        }
        if (StringUtils.isNotBlank((String)entryPassword)) {
            passwordProtection = new KeyStore.PasswordProtection(entryPassword.toCharArray());
        }
        return passwordProtection;
    }
}

