/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.configservice.StreamLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.sourceid.config.ConfigurationException;

public class FileStreamLoader
implements StreamLoader {
    @Override
    public InputStream getInputStream(String directory, String filename) {
        return this.getInputStream(new File(directory, filename));
    }

    @Override
    public InputStream getInputStream(File f) {
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Input file does not exist: " + f, e);
        }
    }

    @Override
    public OutputStream getOutputStream(String directory, String filename) {
        return this.getOutputStream(new File(directory, filename));
    }

    @Override
    public OutputStream getOutputStream(File f) {
        try {
            f.getParentFile().mkdirs();
            if (!f.exists()) {
                f.createNewFile();
            }
            return new FileOutputStream(f);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to create output file: " + f, e);
        }
    }

    @Override
    public boolean streamExists(File f) {
        return f.exists() && f.isFile();
    }
}

