/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.amazonaws.cloudhsm.jce.jni.exception.AddAttributeException;
import com.amazonaws.cloudhsm.jce.provider.attributes.EcParams;
import com.amazonaws.cloudhsm.jce.provider.attributes.KeyAttribute;
import com.amazonaws.cloudhsm.jce.provider.attributes.KeyAttributesMap;
import com.amazonaws.cloudhsm.jce.provider.attributes.KeyAttributesMapBuilder;
import com.amazonaws.cloudhsm.jce.provider.attributes.KeyPairAttributesMap;
import com.amazonaws.cloudhsm.jce.provider.attributes.KeyPairAttributesMapBuilder;
import com.pingidentity.configservice.StreamLoader;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.CertificateServiceImpl;
import com.pingidentity.crypto.JCEManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Destroyable;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.CoreConfig;

public class AWSCloudHSMCertificateServiceImpl
extends CertificateServiceImpl {
    private static final Map<Integer, byte[]> keyLengthToCurveParams = new HashMap<Integer, byte[]>();
    private final CoreConfig coreConfig;

    public AWSCloudHSMCertificateServiceImpl(JCEManager jceManager, CoreConfig coreConfig, SysDirInfo sysDirInfo, StreamLoader streamLoader) {
        super(jceManager, coreConfig, sysDirInfo, streamLoader);
        this.coreConfig = coreConfig;
    }

    @Override
    public X500PrivateCredential createSelfSignedCertAndPrivateKey(String id, String cn, String ou, String o, String l, String st, String c, int validDays, String keyAlgo, int keySize, String sigAlgorithm, Date validFrom, Boolean isHSMProvider, Map<String, String> subjectAlternativeNameMap, CertificateGenerator.CertificateType certificateType) throws GeneralSecurityException, IOException {
        AWSCloudHSMKeyPairWrapper keyPairWrapper = this.generateKeyPairWrapper(id, keyAlgo, keySize, isHSMProvider);
        KeyPair keyPair = keyPairWrapper.getKeyPair();
        X509Certificate x509Certificate = this.createSelfSignedCert(cn, ou, o, l, st, c, validDays, keyPair, sigAlgorithm, validFrom, isHSMProvider, subjectAlternativeNameMap, certificateType);
        if (keyPairWrapper.getAlias() != null) {
            String privateAlias = keyPairWrapper.getAlias();
            return new X500PrivateCredential(x509Certificate, keyPair.getPrivate(), privateAlias);
        }
        return new X500PrivateCredential(x509Certificate, keyPair.getPrivate());
    }

    @Override
    public KeyPair generateKeyPair(String id, String keyAlgorithm, int keySize, Boolean isHSMProvider, CertificateGenerator.CertificateType certificateType) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.generateKeyPairWrapper(id, keyAlgorithm, keySize, isHSMProvider).getKeyPair();
    }

    private AWSCloudHSMKeyPairWrapper generateKeyPairWrapper(String id, String keyAlgorithm, int keySize, Boolean isHSMProvider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (isHSMProvider != null && !isHSMProvider.booleanValue()) {
            KeyPair keyPair = super.generateKeyPair(id, keyAlgorithm, keySize, isHSMProvider, null);
            return new AWSCloudHSMKeyPairWrapper(keyPair, null);
        }
        KeyPair keyPair = null;
        String label = null;
        try {
            String string = label = StringUtils.isNotBlank((String)id) ? id : IDGenerator.rndStr(25, IDGenerator.LOWER_ALPHA_NUMERICS);
            keyPair = "RSA".equals(keyAlgorithm) ? this.generateRSAKeyPair(keySize, label) : this.generateECKeyPair(keySize, label);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Unable to create keypair.  AWS CloudHSM provider not found.", e);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return new AWSCloudHSMKeyPairWrapper(keyPair, label);
    }

    @Override
    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    protected void tryInitializeKeyGenerator(String keyAlgorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen;
        try {
            keyGen = KeyPairGenerator.getInstance(keyAlgorithm, "CloudHSM");
            keyGen.initialize(keySize, this.prng);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Unable to initialize key generator. AWS CloudHSM provider not found.", e);
        }
        try {
            KeyPair tmpKeyPair = keyGen.generateKeyPair();
            if (tmpKeyPair != null) {
                tmpKeyPair.getPrivate().destroy();
                PublicKey publicKey = tmpKeyPair.getPublic();
                if (publicKey instanceof Destroyable) {
                    ((Destroyable)((Object)publicKey)).destroy();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getHSMProviderName() {
        return "CloudHSM";
    }

    @Override
    public KeyStore getDsigHSMKeystore() throws ConfigurationException {
        return this.getCloudHSMKeyStore(this.coreConfig.getDsigHSMKeystoreName(), this.coreConfig.getDsigHSMKeystorePassword());
    }

    @Override
    public KeyStore getSslHSMKeystore() {
        return this.getCloudHSMKeyStore(this.coreConfig.getSslHSMKeystoreName(), this.coreConfig.getSslHSMKeystorePassword());
    }

    @Override
    public KeyStore getGeneralHSMKeystore() {
        return this.getCloudHSMKeyStore(this.coreConfig.getGeneralHSMKeystoreName(), this.coreConfig.getGeneralHSMKeystorePassword());
    }

    @Override
    public KeyStore getTrustHSMKeystore() {
        return super.getTrustKeystore();
    }

    @Override
    public void writeTrustHSMKeystore(KeyStore keystore) {
        super.writeTrustKeystore(keystore);
    }

    @Override
    public KeyStore getSslServerHSMKeystore() {
        return this.getCloudHSMKeyStore(this.coreConfig.getSslServerHSMKeystoreName(), this.coreConfig.getSslServerHSMKeystorePassword());
    }

    @Override
    public Enumeration<String> getAliases(String keystoreName, KeyStore keystore) throws KeyStoreException {
        if ("CloudHSM".equals(keystore.getType()) && StringUtils.isNotBlank((String)keystoreName)) {
            return Collections.enumeration(new HashSet<String>(this.coreConfig.getAliases(keystoreName)));
        }
        return keystore.aliases();
    }

    @Override
    public PrivateKey findPrivateKeyById(String id) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keystore = KeyStore.getInstance("CloudHSM");
        keystore.load(null, null);
        Key key = keystore.getKey(id, null);
        if (key == null) {
            this.log.debug((Object)"Private key not found");
            return null;
        }
        if (!(key instanceof PrivateKey)) {
            this.log.debug((Object)"The key object is not an instance of PrivateKey class");
            return null;
        }
        return (PrivateKey)key;
    }

    private KeyStore getCloudHSMKeyStore(String localKeystoreName, String localKeystorePassword) {
        KeyStore cloudHsmKeyStore = null;
        try {
            cloudHsmKeyStore = KeyStore.getInstance("CloudHSM");
            InputStream storeStream = null;
            try {
                storeStream = this.getKeystoreInputStream(localKeystoreName);
                cloudHsmKeyStore.load(storeStream, localKeystorePassword.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new ConfigurationException("Unable to load keystore: " + localKeystoreName, e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)storeStream);
            }
        }
        catch (KeyStoreException e) {
            this.log.error((Object)"Could not load Cloud HSM keystore.", (Throwable)e);
        }
        return cloudHsmKeyStore;
    }

    private KeyPair generateRSAKeyPair(int keySizeInBits, String label) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, AddAttributeException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", "CloudHSM");
        KeyAttributesMap publicKeyAttrsMap = new KeyAttributesMap();
        publicKeyAttrsMap.put(KeyAttribute.LABEL, (Object)(label + ":public"));
        publicKeyAttrsMap.put(KeyAttribute.MODULUS_BITS, (Object)keySizeInBits);
        publicKeyAttrsMap.put(KeyAttribute.PUBLIC_EXPONENT, (Object)new BigInteger("65537").toByteArray());
        KeyAttributesMap privateKeyAttrsMap = new KeyAttributesMapBuilder().put(KeyAttribute.LABEL, (Object)label).put(KeyAttribute.EXTRACTABLE, (Object)false).build();
        KeyPairAttributesMap keyPairSpec = new KeyPairAttributesMapBuilder().withPublic(publicKeyAttrsMap).withPrivate(privateKeyAttrsMap).build();
        keyPairGen.initialize((AlgorithmParameterSpec)keyPairSpec);
        return keyPairGen.generateKeyPair();
    }

    private KeyPair generateECKeyPair(int keySizeInBits, String label) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, AddAttributeException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("EC", "CloudHSM");
        KeyAttributesMap publicKeyAttrsMap = new KeyAttributesMap();
        publicKeyAttrsMap.put(KeyAttribute.LABEL, (Object)(label + ":public"));
        publicKeyAttrsMap.put(KeyAttribute.EC_PARAMS, (Object)keyLengthToCurveParams.get(keySizeInBits));
        KeyAttributesMap privateKeyAttrsMap = new KeyAttributesMapBuilder().put(KeyAttribute.LABEL, (Object)label).put(KeyAttribute.EXTRACTABLE, (Object)false).put(KeyAttribute.DERIVE, (Object)true).build();
        KeyPairAttributesMap keyPairSpec = new KeyPairAttributesMapBuilder().withPublic(publicKeyAttrsMap).withPrivate(privateKeyAttrsMap).build();
        keyPairGen.initialize((AlgorithmParameterSpec)keyPairSpec);
        return keyPairGen.generateKeyPair();
    }

    static {
        keyLengthToCurveParams.put(256, EcParams.EC_CURVE_PRIME256);
        keyLengthToCurveParams.put(384, EcParams.EC_CURVE_PRIME384);
        keyLengthToCurveParams.put(521, EcParams.EC_CURVE_SECP521);
    }

    private static class AWSCloudHSMKeyPairWrapper {
        private final KeyPair keyPair;
        private final String alias;

        public AWSCloudHSMKeyPairWrapper(KeyPair keyPair, String alias) {
            this.keyPair = keyPair;
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }
    }
}

