/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.JCEManagerBase;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.config.CoreConfig;
import org.sourceid.config.GlobalRegistry;

public class AWSCloudHSMJCEManager
extends JCEManagerBase {
    public static final String AWS_KEYSTORE_TYPE = "CloudHSM";
    private static final CoreConfig coreConfig = GlobalRegistry.getService(CoreConfig.class);
    private static final Set<String> CERT_STORES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(coreConfig.getTrustKeystoreName(), coreConfig.getTrustHSMKeystoreName(), coreConfig.getDsigKeystoreName(), coreConfig.getSslServerKeystoreName(), coreConfig.getGeneralKeystoreName(), coreConfig.getSslKeystoreName())));

    @Override
    public String getKeystoreType(String keystoreFilename) {
        if (CERT_STORES.contains(keystoreFilename)) {
            return KeyStore.getDefaultType();
        }
        return AWS_KEYSTORE_TYPE;
    }

    @Override
    public String getKeystoreType() {
        return AWS_KEYSTORE_TYPE;
    }

    @Override
    public boolean isEnforceFIPSKeySizes() {
        return true;
    }

    @Override
    public boolean allowLinkAndStoreKeys() {
        return true;
    }

    @Override
    protected String getConfigName() {
        return "com.pingidentity.crypto.AWSCloudHSMJCEManager";
    }
}

