/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.amazonaws.cloudhsm.jce.jni.exception.AddAttributeException;
import com.amazonaws.cloudhsm.jce.provider.attributes.KeyAttribute;
import com.amazonaws.cloudhsm.jce.provider.attributes.KeyAttributesMap;
import com.amazonaws.cloudhsm.jce.provider.attributes.KeyAttributesMapBuilder;
import com.amazonaws.cloudhsm.jce.provider.attributes.KeyType;
import com.pingidentity.crypto.PkCert;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSCloudHSMUtil {
    static final Log log = LogFactory.getLog(AWSCloudHSMUtil.class);

    public static void deletePkCert(PkCert cert) throws KeyStoreException {
        if (cert != null) {
            try {
                log.debug((Object)("Deleting key with cert alias " + cert.getAlias()));
                Key toDelete = AWSCloudHSMUtil.getKey(cert.getAlias());
                if (toDelete != null) {
                    ((Destroyable)((Object)toDelete)).destroy();
                }
            }
            catch (DestroyFailedException e) {
                throw new KeyStoreException("Could not delete key: " + cert.getAlias());
            }
        }
    }

    public static Key getKey(String alias) {
        try {
            KeyStore keystore = KeyStore.getInstance("CloudHSM");
            keystore.load(null, null);
            return keystore.getKey(alias, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            log.debug((Object)("Could not find key with alias " + alias), (Throwable)e);
            return null;
        }
    }

    public static void importPkCert(KeyStore keystore, PkCert cert, String passPhrase) throws KeyStoreException {
        try {
            Key keyOnCloudHSM = AWSCloudHSMUtil.getKey(cert.getAlias());
            if (keyOnCloudHSM == null) {
                PrivateKey privateKey = cert.getPrivateKey();
                if (privateKey instanceof RSAPrivateKey) {
                    keyOnCloudHSM = AWSCloudHSMUtil.importRsaKey(cert.getPrivateKey(), cert.getAlias());
                } else if (privateKey instanceof ECPrivateKey) {
                    keyOnCloudHSM = AWSCloudHSMUtil.importEcKey(cert.getPrivateKey(), cert.getAlias());
                }
            }
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(passPhrase.toCharArray());
            KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry((PrivateKey)keyOnCloudHSM, cert.getChain());
            keystore.setEntry(cert.getAlias(), entry, passwordProtection);
        }
        catch (AddAttributeException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new KeyStoreException("Could not import key: " + cert.getAlias(), e);
        }
    }

    private static Key importRsaKey(Key key, String keyLabel) throws AddAttributeException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        if (!(key instanceof RSAPrivateCrtKey)) {
            return null;
        }
        RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
        KeyAttributesMap keySpec = new KeyAttributesMapBuilder().put(KeyAttribute.MODULUS, (Object)rsaKey.getModulus().toByteArray()).put(KeyAttribute.PUBLIC_EXPONENT, (Object)rsaKey.getPublicExponent().toByteArray()).put(KeyAttribute.PRIVATE_EXPONENT, (Object)rsaKey.getPrivateExponent().toByteArray()).put(KeyAttribute.PRIME_P, (Object)rsaKey.getPrimeP().toByteArray()).put(KeyAttribute.PRIME_Q, (Object)rsaKey.getPrimeQ().toByteArray()).put(KeyAttribute.PRIME_EXPONENT_P, (Object)rsaKey.getPrimeExponentP().toByteArray()).put(KeyAttribute.PRIME_EXPONENT_Q, (Object)rsaKey.getPrimeExponentQ().toByteArray()).put(KeyAttribute.CRT_COEFFICIENT, (Object)rsaKey.getCrtCoefficient().toByteArray()).put(KeyAttribute.KEY_TYPE, (Object)KeyType.RSA).put(KeyAttribute.LABEL, (Object)keyLabel).put(KeyAttribute.EXTRACTABLE, (Object)false).build();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "CloudHSM");
        return keyFactory.generatePrivate((KeySpec)keySpec);
    }

    private static Key importEcKey(Key key, String keyLabel) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, AddAttributeException {
        if (!(key instanceof ECPrivateKey)) {
            return null;
        }
        ECPrivateKey ecKey = (ECPrivateKey)key;
        KeyAttributesMap keySpec = new KeyAttributesMapBuilder().put(KeyAttribute.EC_PARAMS, (Object)ecKey.getParams()).put(KeyAttribute.VALUE, (Object)ecKey.getS().toByteArray()).put(KeyAttribute.LABEL, (Object)keyLabel).put(KeyAttribute.EXTRACTABLE, (Object)false).put(KeyAttribute.DERIVE, (Object)true).build();
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "CloudHSM");
        return keyFactory.generatePrivate((KeySpec)keySpec);
    }
}

