/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.configservice.StreamLoader;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.CertificateServiceImpl;
import com.pingidentity.crypto.JCEManager;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.config.CoreConfig;

public class BCFIPSCertificateServiceImpl
extends CertificateServiceImpl {
    private static final String PROVIDER = "BCFIPS";
    private static final Map<Integer, String> keyLengthToCurveNames = new HashMap<Integer, String>();
    private static final SecureRandom sr;

    public BCFIPSCertificateServiceImpl(JCEManager jceManager, CoreConfig coreConfig, SysDirInfo sysDirInfo, StreamLoader streamLoader) {
        super(jceManager, coreConfig, sysDirInfo, streamLoader);
    }

    @Override
    public KeyPair generateKeyPair(String id, String keyAlgorithm, int keySize, Boolean isHSMProvider, CertificateGenerator.CertificateType certificateType) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (isHSMProvider != null && !isHSMProvider.booleanValue()) {
            return super.generateKeyPair(id, keyAlgorithm, keySize, false, null);
        }
        KeyPair keyPair = null;
        try {
            keyPair = "RSA".equals(keyAlgorithm) ? this.generateRSAKeyPair(keySize) : this.generateECKeyPair(keySize);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Unable to create keypair.  Bouncy Castle FIPS provider not found.", e);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return keyPair;
    }

    @Override
    protected void tryInitializeKeyGenerator(String keyAlgorithm, int keySize) throws NoSuchAlgorithmException {
        if (PropertyInfo.isHSMHybrid() && "RSA".equalsIgnoreCase(keyAlgorithm) && keySize < 2048) {
            throw new NoSuchAlgorithmException();
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyAlgorithm, PROVIDER);
            keyGen.initialize(keySize, sr);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Unable to initialize key generator. Bouncy Castle FIPS provider not found.", e);
        }
        catch (AssertionError e) {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    public String getHSMProviderName() {
        return PROVIDER;
    }

    private KeyPair generateRSAKeyPair(int keySizeInBits) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", PROVIDER);
        RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(keySizeInBits, RSAKeyGenParameterSpec.F4);
        keyPairGen.initialize(spec);
        return keyPairGen.generateKeyPair();
    }

    @Override
    public PrivateKey findPrivateKeyById(String id) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new UnsupportedOperationException("method is not implemented for BCFIPS Provider");
    }

    private KeyPair generateECKeyPair(int keySizeInBits) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("EC", PROVIDER);
        keyPairGen.initialize(new ECGenParameterSpec(keyLengthToCurveNames.get(keySizeInBits)));
        return keyPairGen.generateKeyPair();
    }

    static {
        keyLengthToCurveNames.put(256, "secp256r1");
        keyLengthToCurveNames.put(384, "secp384r1");
        keyLengthToCurveNames.put(521, "secp521r1");
        try {
            sr = SecureRandom.getInstance("DEFAULT", PROVIDER);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException("Unable to initialize key generator. Bouncy Castle FIPS provider not found.", e);
        }
    }
}

