/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.JCEManagerBase;
import com.pingidentity.crypto.PkCert;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.config.CoreConfig;
import org.sourceid.config.GlobalRegistry;

public class BCFIPSJCEManager
extends JCEManagerBase {
    public static final String BC_FIPS_KEYSTORE_TYPE = "BCFKS";
    private static final CoreConfig coreConfig = GlobalRegistry.getService(CoreConfig.class);
    private static final Set<String> CERT_STORES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(coreConfig.getTrustKeystoreName(), coreConfig.getDsigKeystoreName(), coreConfig.getSslServerKeystoreName(), coreConfig.getGeneralKeystoreName(), coreConfig.getSslKeystoreName())));

    @Override
    public boolean allowPrivateKeyExport() {
        return true;
    }

    @Override
    public String getKeystoreType(String keystoreFilename) {
        if (CERT_STORES.contains(keystoreFilename)) {
            return KeyStore.getDefaultType();
        }
        return BC_FIPS_KEYSTORE_TYPE;
    }

    @Override
    public String getKeystoreType() {
        return BC_FIPS_KEYSTORE_TYPE;
    }

    @Override
    protected String getConfigName() {
        return "com.pingidentity.crypto.BCFIPSJCEManager";
    }

    @Override
    public String getLegacyEncryptionAlgorithm() {
        if (PropertyInfo.isFipsAllowUnapprovedAlgorithms()) {
            return "Blowfish";
        }
        return "AES";
    }

    @Override
    public boolean isEnforceFIPSKeySizes() {
        return true;
    }

    @Override
    public boolean isUseLegacyRsaSsaPssAlgorithmNames(PkCert pkCert) {
        return false;
    }

    @Override
    public boolean allowLinkAndStoreKeys() {
        return false;
    }
}

