/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.OCSPCheckerSupport;
import com.pingidentity.crypto.RevocationChecker;
import com.pingidentity.crypto.RevocationCheckerConstants;
import com.pingidentity.crypto.RevokedCertException;
import com.pingidentity.crypto.TaggedCertificate;
import com.pingidentity.pingcommons.util.Closer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CRLDistributionPointExtensionRevocationChecker
implements RevocationChecker,
RevocationCheckerConstants {
    private final ConcurrentMap<String, CRLHolder> crlCache = new ConcurrentHashMap<String, CRLHolder>();
    private final ConcurrentMap<String, Object> crlCacheLocks = new ConcurrentHashMap<String, Object>();
    private final BouncyCastleFipsProvider bouncyCastleFipsProvider = new BouncyCastleFipsProvider();
    private final Log log = LogFactory.getLog(this.getClass());
    protected final ConfigStore config = ConfigStoreFarm.getConfig("revocation-checking-config");
    static final String CRL_DIST_POINT_OID = "2.5.29.31";
    static final String LDAP = "ldap";
    static final String HTTP = "http";

    @Override
    public void check(X509Certificate[] chain) throws RevokedCertException {
        if (chain == null) {
            return;
        }
        for (int idx = 0; idx < chain.length; ++idx) {
            X509Certificate x509Certificate = chain[idx];
            int next = idx + 1;
            X509Certificate issuer = chain.length > next ? chain[next] : null;
            this.check(x509Certificate, issuer);
        }
    }

    @Override
    public void check(X509Certificate certificate, X509Certificate issuer) throws RevokedCertException {
        List dpsWithUrls;
        boolean crlEnabled = this.config.getBooleanValue("crl-enable", true);
        if (!crlEnabled) {
            return;
        }
        if (CertificateHelper.isSelfSigned(certificate)) {
            return;
        }
        try {
            CRLDistPoint crlDistPoint = CRLDistPoint.getInstance((Object)this.getExtensionValue(certificate, CRL_DIST_POINT_OID));
            if (crlDistPoint == null) {
                return;
            }
            DistributionPoint[] distributionPoints = crlDistPoint.getDistributionPoints();
            dpsWithUrls = Arrays.stream(distributionPoints).map(dp -> this.getDistributionPointAndUrls((DistributionPoint)dp)).filter(dpWithUrl -> !dpWithUrl.getUrls().isEmpty()).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            this.log.error((Object)("Error extracting distribution points from certificate " + certificate.getSubjectDN()), (Throwable)e);
            return;
        }
        if (dpsWithUrls.isEmpty()) {
            return;
        }
        this.log.debug((Object)("Checking revocation status of certificate " + certificate.getSubjectDN()));
        boolean foundCompleteCrl = false;
        for (DistributionPointAndUrls dpWithUrls : dpsWithUrls) {
            CRLHolder crlHolder = this.getCrlInfo(dpWithUrls, certificate, issuer);
            if (crlHolder.onlyContainsAttributeCerts() || crlHolder.onlyContainsUserCerts() && certificate.getBasicConstraints() != -1 || crlHolder.onlyContainsCaCerts() && certificate.getBasicConstraints() == -1) {
                this.log.debug((Object)("Flags indicate CRL found at " + crlHolder.getLocation() + " does not apply to certificate " + certificate.getSubjectDN()));
                continue;
            }
            X509CRL crl = crlHolder.getCrl();
            if (crl == null) continue;
            boolean revoked = crl.isRevoked(certificate);
            if (revoked) {
                String msg = "Certificate " + certificate.getSubjectDN() + " has been revoked as indicated by CRL found at " + crlHolder.getLocation();
                this.log.info((Object)msg);
                throw new RevokedCertException(msg);
            }
            if (crlHolder.hasAllReasons()) {
                foundCompleteCrl = true;
                break;
            }
            this.log.debug((Object)("CRL found at " + crlHolder.getLocation() + " covers only some reasons"));
        }
        if (!foundCompleteCrl && this.config.getBooleanValue("treat-non-retrievable-crl-as-revoked", false)) {
            String message = "Failed to retrieve CRL for certificate " + certificate.getSubjectDN();
            this.log.info((Object)message);
            throw new CRLNonRetrievableException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CRLHolder getCrlInfo(DistributionPointAndUrls dpWithUrls, X509Certificate certificate, X509Certificate issuer) {
        String firstUrl = dpWithUrls.getUrls().get(0);
        this.crlCacheLocks.putIfAbsent(firstUrl, new Object());
        Object v = this.crlCacheLocks.get(firstUrl);
        synchronized (v) {
            CRLHolder crlHolder;
            block16: {
                if (this.crlCache.containsKey(firstUrl)) {
                    crlHolder = (CRLHolder)this.crlCache.get(firstUrl);
                    if (crlHolder.isExpired()) {
                        this.log.debug((Object)("Removing CRL cache entry for " + crlHolder.getLocation() + " because a new update should be available."));
                        this.crlCache.remove(firstUrl);
                        break block16;
                    } else {
                        if (crlHolder.getCrl() == null) {
                            this.log.debug((Object)("Reusing empty CRL cache entry for " + crlHolder.getLocation() + ", next update at " + crlHolder.getExpiresAt()));
                        } else {
                            this.log.debug((Object)("Reusing CRL cache entry for " + crlHolder.getLocation() + ", next update at " + crlHolder.getExpiresAt()));
                        }
                        return crlHolder;
                    }
                }
                this.log.debug((Object)("No cache entry found for " + firstUrl));
            }
            crlHolder = null;
            for (String url : dpWithUrls.getUrls()) {
                try {
                    crlHolder = this.resolveCrl(url);
                    break;
                }
                catch (IOException | GeneralSecurityException | NamingException e) {
                    this.log.error((Object)("Unable to get CRL from " + url), (Throwable)e);
                }
            }
            if (crlHolder == null) {
                return this.cacheFailedCrlResolve(firstUrl);
            }
            if (crlHolder.isExpired()) {
                Instant nextCheck = Instant.now().plus(Duration.ofMinutes(this.config.getIntValue("next-retry-minutes-when-next-update-is-in-the-past", 60)));
                this.log.warn((Object)("Freshly retrieved CRL has a next-update date in the past (" + crlHolder.getExpiresAt() + "), will not recheck until " + nextCheck));
                crlHolder = new CRLHolder(null, firstUrl, nextCheck);
                this.crlCache.put(firstUrl, crlHolder);
                return crlHolder;
            }
            try {
                if (this.config.getBooleanValue("verify-crl-signature", true)) {
                    this.checkCrlSignature(crlHolder, certificate, issuer);
                }
                if (this.config.getBooleanValue("crl-verify-issuing-distribution-point", true)) {
                    crlHolder = this.checkIssuingDistributionPoint(dpWithUrls.getDistributionPoint(), crlHolder);
                }
            }
            catch (GeneralSecurityException e) {
                this.log.error((Object)("Unable to verify CRL from " + crlHolder.getLocation()), (Throwable)e);
                return this.cacheFailedCrlResolve(firstUrl);
            }
            this.crlCache.put(firstUrl, crlHolder);
            return crlHolder;
        }
    }

    String extractUrl(String rawExtString, String protocol) {
        int index = rawExtString.toLowerCase().indexOf(protocol);
        return rawExtString.substring(index);
    }

    boolean isHttpUrl(String url) {
        return StringUtils.startsWithIgnoreCase((String)url, (String)HTTP);
    }

    boolean isLdapUrl(String url) {
        return StringUtils.startsWithIgnoreCase((String)url, (String)LDAP);
    }

    private CRLHolder cacheFailedCrlResolve(String location) {
        Instant expiresAt = Instant.now().plus(Duration.ofMinutes(this.config.getIntValue("next-retry-minutes-when-resolve-failed", 1440)));
        CRLHolder crlHolder = new CRLHolder(null, location, expiresAt);
        this.log.debug((Object)("Put null entry in to cache for " + location + " until " + expiresAt));
        this.crlCache.put(location, crlHolder);
        return crlHolder;
    }

    private CRLHolder resolveCrl(String url) throws NamingException, IOException, GeneralSecurityException {
        CRLHolder crlHolder;
        if (this.isLdapUrl(url)) {
            this.log.debug((Object)("Trying to retrieve CRL from " + url));
            crlHolder = this.ldapResolve(url);
        } else if (this.isHttpUrl(url)) {
            this.log.debug((Object)("Trying to retrieve CRL from " + url));
            crlHolder = this.httpResolve(url);
        } else {
            throw new IOException("Unable to get CRL from " + url + ", only LDAP and HTTP are supported");
        }
        if (this.log.isDebugEnabled()) {
            if (crlHolder.getCrl().getTBSCertList().length < 8192) {
                this.log.debug((Object)("CRL obtained from " + crlHolder.getLocation() + ": " + crlHolder.getCrl()));
            } else {
                this.log.debug((Object)("CRL obtained from " + crlHolder.getLocation() + ", the list is too big to be logged"));
            }
        }
        return crlHolder;
    }

    private CRLHolder httpResolve(String rawExtString) throws IOException, GeneralSecurityException {
        URLConnection urlConn;
        String httpString = this.extractUrl(rawExtString, HTTP);
        URL url = new URL(httpString);
        String proxyHost = this.config.getStringValue("proxy-host", null);
        int proxyPort = this.config.getIntValue("proxy-port", 0);
        if (proxyHost != null && !"".equals(proxyHost) && proxyPort > 0) {
            InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPort);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, sockAddr);
            urlConn = url.openConnection(proxy);
        } else {
            urlConn = url.openConnection();
        }
        OCSPCheckerSupport.disableRevocationChecking(urlConn);
        int connectionTimeoutSecs = this.config.getIntValue("crl-retrieval-connection-timeout-secs", 30);
        int readTimeoutSecs = this.config.getIntValue("crl-retrieval-read-timeout-secs", 30);
        urlConn.setConnectTimeout(1000 * connectionTimeoutSecs);
        urlConn.setReadTimeout(1000 * readTimeoutSecs);
        Object content = urlConn.getContent();
        InputStream is = (InputStream)content;
        return this.parseCrl(is, httpString);
    }

    private CRLHolder ldapResolve(String rawExtString) throws NamingException, GeneralSecurityException {
        String ldapUrl = this.extractUrl(rawExtString, LDAP);
        InitialDirContext dirctx = new InitialDirContext();
        NamingEnumeration<SearchResult> namingEnum = dirctx.search(ldapUrl, "", null);
        while (namingEnum.hasMore()) {
            SearchResult searchResult = namingEnum.next();
            Attributes attributes = searchResult.getAttributes();
            NamingEnumeration<? extends Attribute> allAttrs = attributes.getAll();
            while (allAttrs.hasMore()) {
                Attribute attribute = allAttrs.next();
                Object o = attribute.get();
                if (!(o instanceof byte[])) continue;
                byte[] bytes = (byte[])o;
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                return this.parseCrl(bais, ldapUrl);
            }
        }
        throw new GeneralSecurityException("Unable to get CRL from LDAP " + ldapUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CRLHolder parseCrl(InputStream inputStream, String location) throws CertificateException, CRLException {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509", (Provider)this.bouncyCastleFipsProvider);
            X509CRL x509CRL = (X509CRL)certFactory.generateCRL(inputStream);
            CRLHolder cRLHolder = new CRLHolder(x509CRL, location, x509CRL.getNextUpdate().toInstant());
            return cRLHolder;
        }
        finally {
            Closer.close((Closeable)inputStream);
        }
    }

    Map<String, CRLHolder> getCrlCache() {
        return this.crlCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCrlSignature(CRLHolder crlHolder, X509Certificate certificate, X509Certificate issuer) throws GeneralSecurityException {
        X500Principal issuerPrincipal;
        X509CRL crl = crlHolder.getCrl();
        ArrayList<TaggedCertificate> candidateVerificationCerts = new ArrayList<TaggedCertificate>();
        X500Principal crlIssuerPrincipal = crl.getIssuerX500Principal();
        if (!crlIssuerPrincipal.equals(issuerPrincipal = certificate.getIssuerX500Principal())) {
            if (!this.config.getBooleanValue("crl-issuer-allow-any-trust-anchor", false)) throw new GeneralSecurityException("Unable to verify CRL signature because the issuer of the CRL (" + crlIssuerPrincipal + ") is not the issuer of the cert (" + issuerPrincipal + ")");
            this.log.debug((Object)("CRL issuer (" + crlIssuerPrincipal + ") does not match certificate issuer (" + issuerPrincipal + ")"));
            Set<TrustAnchor> trustAnchors = MgmtFactory.getTrustedCAsManager().getTrustAnchorsByDN(crlIssuerPrincipal);
            if (trustAnchors.isEmpty()) {
                throw new GeneralSecurityException("No trust anchors found matching CRL issuer " + crlIssuerPrincipal);
            }
            candidateVerificationCerts.addAll(trustAnchors.stream().map(anchor -> new TaggedCertificate(anchor.getTrustedCert(), "CRL issuer from trust anchors")).collect(Collectors.toList()));
        } else if (issuer != null) {
            if (!OCSPCheckerSupport.isValidIssuer(certificate, issuer)) {
                throw new GeneralSecurityException("The provided issuer (" + issuer.getSubjectDN() + ") is invalid or did not issue the cert (" + certificate.getSubjectDN() + ")");
            }
            candidateVerificationCerts.add(new TaggedCertificate(issuer, "issuer certificate (provided)"));
        } else {
            issuer = OCSPCheckerSupport.getIssuer(certificate);
            if (issuer == null) {
                throw new GeneralSecurityException("Unable to verify CRL signature because the issuer of the certificate (" + certificate.getIssuerDN() + ") was not found in trust anchors");
            }
            candidateVerificationCerts.add(new TaggedCertificate(issuer, "issuer certificate"));
        }
        boolean signatureVerified = false;
        for (TaggedCertificate candidate : candidateVerificationCerts) {
            try {
                crl.verify(candidate.getCertificate().getPublicKey());
                this.log.debug((Object)("Signature verified with " + candidate.getTag()));
                return;
            }
            catch (GeneralSecurityException e) {
                this.log.debug((Object)("Failed to verify CRL signature with " + candidate.getTag() + ": " + e.getMessage()));
            }
        }
        if (signatureVerified) return;
        throw new GeneralSecurityException("Invalid CRL signature");
    }

    private CRLHolder checkIssuingDistributionPoint(DistributionPoint dp, CRLHolder crlHolder) throws GeneralSecurityException {
        try {
            IssuingDistributionPoint idp;
            if (dp.getReasons() != null) {
                this.log.debug((Object)"Certificate distribution point indicates only some reasons are covered by the CRL");
            }
            if ((idp = IssuingDistributionPoint.getInstance((Object)this.getExtensionValue(crlHolder.getCrl(), "2.5.29.28"))) != null) {
                if (idp.getOnlySomeReasons() != null) {
                    this.log.debug((Object)"CRL issuing distribution point indicates only some reasons are covered by the CRL");
                }
                List<GeneralName> idpGeneralNames = this.getDistributionPointNames(idp.getDistributionPoint());
                List<GeneralName> dpGeneralNames = this.getDistributionPointNames(dp.getDistributionPoint());
                if (!idpGeneralNames.stream().anyMatch(idpGeneralName -> dpGeneralNames.contains(idpGeneralName))) {
                    throw new GeneralSecurityException("No match between issuing distribution point names and distribution point names");
                }
                this.log.debug((Object)"Found match between issuing distribution point names and distribution point names");
                boolean hasAllReasons = dp.getReasons() == null && idp.getOnlySomeReasons() == null;
                return new CRLHolder(crlHolder, hasAllReasons, idp.onlyContainsAttributeCerts(), idp.onlyContainsCACerts(), idp.onlyContainsUserCerts());
            }
            if (dp.getReasons() != null) {
                return new CRLHolder(crlHolder, false, false, false, false);
            }
            return crlHolder;
        }
        catch (RuntimeException e) {
            throw new GeneralSecurityException("Unexpected error checking CRL issuing distribution point", e);
        }
    }

    private DistributionPointAndUrls getDistributionPointAndUrls(DistributionPoint distributionPoint) {
        ArrayList<String> urls = new ArrayList<String>();
        for (GeneralName generalName : this.getDistributionPointNames(distributionPoint.getDistributionPoint())) {
            if (generalName.getTagNo() != 6) continue;
            String url = DERIA5String.getInstance((Object)generalName.getName()).getString();
            urls.add(url);
        }
        return new DistributionPointAndUrls(distributionPoint, urls);
    }

    private List<GeneralName> getDistributionPointNames(DistributionPointName dpName) {
        if (dpName == null) {
            return Collections.emptyList();
        }
        if (dpName.getType() == 0) {
            GeneralName[] generalNames = GeneralNames.getInstance((Object)dpName.getName()).getNames();
            return Arrays.asList(generalNames);
        }
        return Collections.emptyList();
    }

    protected ASN1Primitive getExtensionValue(X509Extension ext, String oid) {
        byte[] bytes = ext.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return this.getASN1Primitive(oid, bytes);
    }

    private ASN1Primitive getASN1Primitive(String oid, byte[] ext) {
        try {
            ASN1OctetString octs = ASN1OctetString.getInstance((Object)ext);
            return ASN1Primitive.fromByteArray((byte[])octs.getOctets());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error processing extension " + oid, e);
        }
    }

    static class CRLNonRetrievableException
    extends RevokedCertException {
        private static final long serialVersionUID = -6015904884952113969L;

        public CRLNonRetrievableException(String message) {
            super(message);
        }
    }

    static class CRLHolder {
        private final X509CRL crl;
        private final Instant expiresAt;
        private final String location;
        private final boolean hasAllReasons;
        private final boolean onlyContainsAttributeCerts;
        private final boolean onlyContainsCaCerts;
        private final boolean onlyContainsUserCerts;

        public CRLHolder(X509CRL crl, String location, Instant expiresAt) {
            this.crl = crl;
            this.location = location;
            this.expiresAt = expiresAt;
            this.hasAllReasons = true;
            this.onlyContainsAttributeCerts = false;
            this.onlyContainsCaCerts = false;
            this.onlyContainsUserCerts = false;
        }

        public CRLHolder(CRLHolder copyFrom, boolean hasAllReasons, boolean onlyContainsAttributeCerts, boolean onlyContainsCaCerts, boolean onlyContainsUserCerts) {
            this.crl = copyFrom.crl;
            this.location = copyFrom.location;
            this.expiresAt = copyFrom.expiresAt;
            this.hasAllReasons = hasAllReasons;
            this.onlyContainsAttributeCerts = onlyContainsAttributeCerts;
            this.onlyContainsCaCerts = onlyContainsCaCerts;
            this.onlyContainsUserCerts = onlyContainsUserCerts;
        }

        public X509CRL getCrl() {
            return this.crl;
        }

        public Instant getExpiresAt() {
            return this.expiresAt;
        }

        public boolean isExpired() {
            return this.expiresAt.isBefore(Instant.now());
        }

        public String getLocation() {
            return this.location;
        }

        public boolean hasAllReasons() {
            return this.hasAllReasons;
        }

        public boolean onlyContainsAttributeCerts() {
            return this.onlyContainsAttributeCerts;
        }

        public boolean onlyContainsCaCerts() {
            return this.onlyContainsCaCerts;
        }

        public boolean onlyContainsUserCerts() {
            return this.onlyContainsUserCerts;
        }
    }

    static class DistributionPointAndUrls {
        private final DistributionPoint distributionPoint;
        private final List<String> urls;

        public DistributionPointAndUrls(DistributionPoint distributionPoint, List<String> urls) {
            this.distributionPoint = distributionPoint;
            this.urls = urls;
        }

        public DistributionPoint getDistributionPoint() {
            return this.distributionPoint;
        }

        public List<String> getUrls() {
            return this.urls;
        }
    }
}

