/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.HostAddressUtils;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.KeyAlgorithmInfo;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.pingcommons.crypto.CertificateUtil;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import com.pingidentity.pingcommons.crypto.LenientDNSName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.sourceid.saml20.domain.mgmt.impl.TrustedCAsManagerImpl;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import sun.net.util.IPAddressUtil;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;

public class CertificateGeneratorImpl
implements CertificateGenerator {
    private static final String CACERTS_FILE = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
    private static final String SERVER_AUTH_KEY_USAGE_OID = "1.3.6.1.5.5.7.3.1";
    private static volatile Map<String, KeyAlgorithmInfo> keyAlgorithmInfos;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected SecureRandom prng = SecurityProviderUtil.getSecureRandom();
    private Set<X509Certificate> javaTrustedCaCerts;
    private KeyStore javaTrustedCasKeystore;

    @Override
    public List<String> getSupportedSubjectAlternativeNameTypes() {
        ArrayList<String> supportedSubjectAlternativeNameTypes = new ArrayList<String>();
        for (SupportedSubjectAlternativeNameType supportedType : SupportedSubjectAlternativeNameType.values()) {
            supportedSubjectAlternativeNameTypes.add(supportedType.getNameTypeString());
        }
        Collections.sort(supportedSubjectAlternativeNameTypes);
        return supportedSubjectAlternativeNameTypes;
    }

    @Override
    public boolean isValidSubjectAlternativeNameTypeValuePair(String nameTypeString, String nameValueString) {
        try {
            SupportedSubjectAlternativeNameType type = SupportedSubjectAlternativeNameType.get(nameTypeString);
            return type.isValidNameValue(nameValueString);
        }
        catch (IOException exception) {
            return false;
        }
    }

    @Override
    public Map<String, String> resolveSubjectAlternativeNameTypeFromValues(List<String> subjectAlternativeNameValues) throws IOException {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        if (subjectAlternativeNameValues != null) {
            for (String nameValue : subjectAlternativeNameValues) {
                nameMap.put(nameValue, SupportedSubjectAlternativeNameType.inferTypeFromNameValue(nameValue).getNameTypeString());
            }
        }
        return nameMap;
    }

    @Override
    public KeyPair generateLocalRsaKeyPair(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", SecurityProviderUtil.getSunRsaSignProviderOrEquivalent());
        generator.initialize(keySize, this.prng);
        return generator.generateKeyPair();
    }

    @Override
    public KeyPair generateLocalEcKeyPair(ECParameterSpec spec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("EC", SecurityProviderUtil.getSunECProviderOrEquivalent());
        generator.initialize(spec, this.prng);
        return generator.generateKeyPair();
    }

    @Override
    public boolean isLocalEcKeyPairGenerationAvailable() {
        try {
            KeyPairGenerator.getInstance("EC", SecurityProviderUtil.getSunECProviderOrEquivalent());
            return true;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            return false;
        }
    }

    @Override
    public int getMaxValidDays() {
        return 36500;
    }

    protected List<String> getPreferredSignatureAlgorithms(String keyAlgorithm) {
        switch (keyAlgorithm) {
            case "RSA": {
                return Collections.singletonList("SHA256withRSA");
            }
            case "EC": {
                return Collections.singletonList("SHA256withECDSA");
            }
        }
        return Collections.emptyList();
    }

    protected Map<String, KeyAlgorithmInfo> loadKeyAlgorithmInfos() {
        List<String> preferredECSignatureAlgorithms;
        List<String> preferredRSASignatureAlgorithms;
        List<String> candidateRSASignatureAlgorithms;
        KeyAlgorithmInfo rsaInfo;
        LinkedHashMap<String, KeyAlgorithmInfo> loadedKeyAlgorithmInfos = new LinkedHashMap<String, KeyAlgorithmInfo>();
        List<Integer> candidateRSAKeySizes = Arrays.asList(1024, 2048, 4096);
        List<Integer> defaultRSAKeySizes = Arrays.asList(2048, 1024);
        if (this.enforceFIPSKeySizes()) {
            candidateRSAKeySizes = Arrays.asList(2048, 4096);
            defaultRSAKeySizes = Collections.singletonList(2048);
        }
        if ((rsaInfo = this.makeKeyAlgorithmInfo("RSA", candidateRSAKeySizes, defaultRSAKeySizes, candidateRSASignatureAlgorithms = Arrays.asList("SHA256withRSA", "SHA384withRSA", "SHA512withRSA"), preferredRSASignatureAlgorithms = this.getPreferredSignatureAlgorithms("RSA"))) != null) {
            loadedKeyAlgorithmInfos.put("RSA", rsaInfo);
        }
        List<Integer> candidateECKeySizes = Arrays.asList(256, 384, 521);
        List<Integer> defaultECKeySizes = Collections.singletonList(256);
        List<String> candidateECSignatureAlgorithms = Arrays.asList("SHA256withECDSA", "SHA384withECDSA", "SHA512withECDSA");
        KeyAlgorithmInfo ecInfo = this.makeKeyAlgorithmInfo("EC", candidateECKeySizes, defaultECKeySizes, candidateECSignatureAlgorithms, preferredECSignatureAlgorithms = this.getPreferredSignatureAlgorithms("EC"));
        if (ecInfo != null) {
            loadedKeyAlgorithmInfos.put("EC", ecInfo);
        }
        return loadedKeyAlgorithmInfos;
    }

    protected boolean enforceFIPSKeySizes() {
        return false;
    }

    protected KeyAlgorithmInfo makeKeyAlgorithmInfo(String keyAlgorithm, Collection<Integer> candidateKeySizes, Collection<Integer> defaultKeySizes, Collection<String> candidateSignatureAlgorithms, List<String> preferredSignatureAlgorithms) {
        Collection<Integer> keySizes = this.getAvailableKeySizes(keyAlgorithm, candidateKeySizes);
        Collection<String> signatureAlgorithms = this.getAvailableSignatureAlgorithms(candidateSignatureAlgorithms);
        if (keySizes.isEmpty() || signatureAlgorithms.isEmpty()) {
            this.log.info((Object)("Not adding key algorithm " + keyAlgorithm + " because available key sizes or signature algorithms is empty"));
            return null;
        }
        Integer defaultKeySize = null;
        String defaultSignatureAlgorithm = null;
        for (Integer keySize : defaultKeySizes) {
            if (!keySizes.contains(keySize)) continue;
            defaultKeySize = keySize;
            break;
        }
        if (defaultKeySize == null) {
            defaultKeySize = keySizes.iterator().next();
        }
        for (String preferredSigAlg : preferredSignatureAlgorithms) {
            if (signatureAlgorithms.contains(preferredSigAlg)) {
                defaultSignatureAlgorithm = preferredSigAlg;
                break;
            }
            this.log.warn((Object)("Preferred signature algorithm " + preferredSigAlg + " is not available"));
        }
        if (defaultSignatureAlgorithm == null) {
            defaultSignatureAlgorithm = signatureAlgorithms.iterator().next();
        }
        this.log.info((Object)("Selected " + defaultKeySize + " as default key size for " + keyAlgorithm));
        this.log.info((Object)("Selected " + defaultSignatureAlgorithm + " as default signature algorithm for " + keyAlgorithm));
        return new KeyAlgorithmInfo(keyAlgorithm, keySizes, defaultKeySize, signatureAlgorithms, defaultSignatureAlgorithm);
    }

    @Override
    public Collection<String> getAvailableKeyAlgorithms() {
        return this.getKeyAlgorithmInfos().keySet();
    }

    @Override
    public KeyAlgorithmInfo getKeyAlgorithmInfo(String keyAlgorithm) {
        return this.getKeyAlgorithmInfos().get(keyAlgorithm);
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public Map<String, KeyAlgorithmInfo> getKeyAlgorithmInfos() {
        if (keyAlgorithmInfos == null) {
            keyAlgorithmInfos = Collections.unmodifiableMap(this.loadKeyAlgorithmInfos());
        }
        return keyAlgorithmInfos;
    }

    protected Collection<String> getAvailableSignatureAlgorithms(Collection<String> candidates) {
        ArrayList<String> result = new ArrayList<String>();
        for (String candidateAlgo : candidates) {
            try {
                Signature.getInstance(candidateAlgo);
                result.add(candidateAlgo);
                this.log.info((Object)("Signature algorithm " + candidateAlgo + " is supported"));
            }
            catch (Exception e) {
                this.log.info((Object)("Signature algorithm " + candidateAlgo + " not supported"));
            }
        }
        return result;
    }

    protected Collection<Integer> getAvailableKeySizes(String keyAlgorithm, Collection<Integer> candidates) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int candidateSize : candidates) {
            try {
                this.tryInitializeKeyGenerator(keyAlgorithm, candidateSize);
                result.add(candidateSize);
                this.log.info((Object)(keyAlgorithm + " key size " + candidateSize + " is supported"));
            }
            catch (Exception e) {
                this.log.info((Object)(keyAlgorithm + " key size " + candidateSize + " not supported"));
            }
        }
        return result;
    }

    protected void tryInitializeKeyGenerator(String keyAlgorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyAlgorithm);
        keyGen.initialize(keySize, this.prng);
    }

    @Override
    public X500PrivateCredential createSelfSignedCertAndPrivateKey(String cn, String ou, String o, String l, String st, String c, int validDays, String keyAlgo, int keySize) throws GeneralSecurityException, IOException {
        return this.createSelfSignedCertAndPrivateKey(cn, ou, o, l, st, c, validDays, keyAlgo, keySize, null, null);
    }

    @Override
    public X500PrivateCredential createSelfSignedCertAndPrivateKey(String cn, String ou, String o, String l, String st, String c, int validDays, String keyAlgo, int keySize, String sigAlgorithm, Date validFrom) throws GeneralSecurityException, IOException {
        return this.createSelfSignedCertAndPrivateKey(cn, ou, o, l, st, c, validDays, keyAlgo, keySize, sigAlgorithm, validFrom, null);
    }

    @Override
    public X500PrivateCredential createSelfSignedCertAndPrivateKey(String cn, String ou, String o, String l, String st, String c, int validDays, String keyAlgo, int keySize, String sigAlgorithm, Date validFrom, Boolean isHSMProvider) throws GeneralSecurityException, IOException {
        KeyPair keyPair = this.generateKeyPair(keyAlgo, keySize, isHSMProvider);
        X509Certificate x509Certificate = this.createSelfSignedCert(cn, ou, o, l, st, c, validDays, keyPair, sigAlgorithm, validFrom, isHSMProvider);
        return new X500PrivateCredential(x509Certificate, keyPair.getPrivate());
    }

    @Override
    public X500PrivateCredential createSelfSignedCertAndPrivateKey(String id, String cn, String ou, String o, String l, String st, String c, int validDays, String keyAlgo, int keySize, String sigAlgorithm, Date validFrom, Boolean isHSMProvider, Map<String, String> subjectAlternativeNameMap, CertificateGenerator.CertificateType certificateType) throws GeneralSecurityException, IOException {
        KeyPair keyPair = this.generateKeyPair(id, keyAlgo, keySize, isHSMProvider, certificateType);
        X509Certificate x509Certificate = this.createSelfSignedCert(cn, ou, o, l, st, c, validDays, keyPair, sigAlgorithm, validFrom, isHSMProvider, subjectAlternativeNameMap, certificateType);
        return new X500PrivateCredential(x509Certificate, keyPair.getPrivate());
    }

    public KeyPair generateKeyPair(String keyAlgorithm, int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.generateKeyPair(keyAlgorithm, keySize, null);
    }

    public KeyPair generateKeyPair(String keyAlgorithm, int keySize, Boolean isHSMProvider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.generateKeyPair(null, keyAlgorithm, keySize, isHSMProvider, null);
    }

    public KeyPair generateKeyPair(String id, String keyAlgorithm, int keySize, Boolean isHSMProvider, CertificateGenerator.CertificateType certificateType) throws NoSuchAlgorithmException, NoSuchProviderException {
        String provider = null;
        if (keyAlgorithm.equalsIgnoreCase("RSA")) {
            provider = SecurityProviderUtil.getSunRsaSignProviderOrEquivalent();
        } else if (keyAlgorithm.equalsIgnoreCase("EC")) {
            provider = SecurityProviderUtil.getSunECProviderOrEquivalent();
        }
        KeyPairGenerator keyGen = provider != null ? KeyPairGenerator.getInstance(keyAlgorithm, provider) : KeyPairGenerator.getInstance(keyAlgorithm);
        keyGen.initialize(keySize, this.prng);
        return keyGen.generateKeyPair();
    }

    public X509Certificate createSelfSignedCert(X500Name name, Date from, Date to, KeyPair keyPair, String sigAlgorithm, Boolean isHSMProvider, Map<String, String> subjectAlternativeNameMap, CertificateGenerator.CertificateType certificateType) throws GeneralSecurityException, IOException {
        String keyAlgorithm = this.getKeyAlgorithm(keyPair);
        String signingAlgorithm = sigAlgorithm;
        if (sigAlgorithm == null) {
            KeyAlgorithmInfo info = this.getKeyAlgorithmInfo(keyAlgorithm);
            if (info == null) {
                throw new GeneralSecurityException("Unable to create signature for key algorithm " + keyAlgorithm);
            }
            signingAlgorithm = info.getDefaultSignatureAlgorithm();
        }
        CertificateExtensions extensions = null;
        if (CertificateGenerator.CertificateType.sslServerCerts.equals((Object)certificateType)) {
            extensions = new CertificateExtensions();
            Vector<ObjectIdentifier> oids = new Vector<ObjectIdentifier>();
            oids.add(this.createObjectIdentifierInstance(SERVER_AUTH_KEY_USAGE_OID));
            ExtendedKeyUsageExtension keyUsageExtension = new ExtendedKeyUsageExtension((Boolean)false, oids);
            try {
                Class<CertificateExtensions> certificateExtensionsClazz = CertificateExtensions.class;
                Method setExtension = certificateExtensionsClazz.getMethod("setExtension", String.class, sun.security.x509.Extension.class);
                setExtension.invoke((Object)extensions, "ExtendedKeyUsage", keyUsageExtension);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                extensions.set("ExtendedKeyUsage", keyUsageExtension);
            }
        }
        if (!subjectAlternativeNameMap.isEmpty()) {
            if (extensions == null) {
                extensions = new CertificateExtensions();
            }
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = new SubjectAlternativeNameExtension((Boolean)false, SupportedSubjectAlternativeNameType.buildGeneralNames(subjectAlternativeNameMap));
            try {
                Class<CertificateExtensions> certificateExtensionsClazz = CertificateExtensions.class;
                Method setExtension = certificateExtensionsClazz.getMethod("setExtension", String.class, sun.security.x509.Extension.class);
                setExtension.invoke((Object)extensions, PKIXExtensions.SubjectAlternativeName_Id.toString(), subjectAlternativeNameExtension);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                extensions.set(PKIXExtensions.SubjectAlternativeName_Id.toString(), subjectAlternativeNameExtension);
            }
        }
        String hsmProviderName = SecurityProviderUtil.getHSMProviderName(isHSMProvider);
        return CertificateUtil.createSelfSignedCert((X500Name)name, (Date)from, (Date)to, (KeyPair)keyPair, (String)signingAlgorithm, (CertificateExtensions)extensions, (String)hsmProviderName);
    }

    protected String getKeyAlgorithm(KeyPair keyPair) {
        return keyPair.getPrivate().getAlgorithm();
    }

    @Override
    public X509Certificate createSelfSignedCert(String cn, String ou, String o, String l, String st, String c, int validDays, KeyPair keyPair) throws GeneralSecurityException, IOException {
        return this.createSelfSignedCert(cn, ou, o, l, st, c, validDays, keyPair, null, null);
    }

    @Override
    public X509Certificate createSelfSignedCert(String cn, String ou, String o, String l, String st, String c, int validDays, KeyPair keyPair, String sigAlgorithm, Date validFrom) throws GeneralSecurityException, IOException {
        return this.createSelfSignedCert(cn, ou, o, l, st, c, validDays, keyPair, sigAlgorithm, validFrom, null);
    }

    @Override
    public X509Certificate createSelfSignedCert(String cn, String ou, String o, String l, String st, String c, int validDays, KeyPair keyPair, String sigAlgorithm, Date validFrom, Boolean isHSMProvider) throws GeneralSecurityException, IOException {
        return this.createSelfSignedCert(cn, ou, o, l, st, c, validDays, keyPair, sigAlgorithm, validFrom, isHSMProvider, Collections.emptyMap(), null);
    }

    @Override
    public X509Certificate createSelfSignedCert(String cn, String ou, String o, String l, String st, String c, int validDays, KeyPair keyPair, String sigAlgorithm, Date validFrom, Boolean isHSMProvider, Map<String, String> subjectAlternativeNameMap, CertificateGenerator.CertificateType certificateType) throws GeneralSecurityException, IOException {
        X500Name name = CertificateUtil.buildX500Name((String)cn, (String)ou, (String)o, (String)l, (String)st, (String)c);
        if (validFrom == null) {
            validFrom = new Date();
        }
        Calendar to = Calendar.getInstance();
        to.setTime(new Date());
        to.add(5, validDays);
        return this.createSelfSignedCert(name, validFrom, to.getTime(), keyPair, sigAlgorithm, isHSMProvider, subjectAlternativeNameMap, certificateType);
    }

    private PKCS10CertificationRequest getCertificateSigningRequest(X509Certificate cert, ContentSigner signer) throws CertificateEncodingException {
        JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(cert);
        JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(certHolder.getSubject(), cert.getPublicKey());
        Extension subjectAltNameExtension = certHolder.getExtension(Extension.subjectAlternativeName);
        if (subjectAltNameExtension != null) {
            requestBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)new Extensions(subjectAltNameExtension));
        }
        return requestBuilder.build(signer);
    }

    @Override
    public String encodeCSR(PrivateKey key, X509Certificate cert, Boolean isHSMProvider) throws GeneralSecurityException, IOException {
        ContentSigner signer;
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(cert.getSigAlgName());
        String providerName = SecurityProviderUtil.getHSMProviderName(isHSMProvider);
        if (providerName != null) {
            signerBuilder.setProvider(providerName);
        }
        try {
            signer = signerBuilder.build(key);
        }
        catch (OperatorCreationException e) {
            throw new GeneralSecurityException("Unexpected error creating content signer", e);
        }
        PKCS10CertificationRequest request = this.getCertificateSigningRequest(cert, signer);
        String pemRequest = new String(Base64.encodeBase64((byte[])request.getEncoded(), (boolean)true), StandardCharsets.UTF_8);
        pemRequest = pemRequest.replace("\r\n", "\n");
        StringWriter buff = new StringWriter();
        try (PrintWriter out = new PrintWriter(buff);){
            out.print("-----BEGIN NEW CERTIFICATE REQUEST-----\n");
            out.print(pemRequest);
            out.print("-----END NEW CERTIFICATE REQUEST-----\n");
        }
        return buff.toString();
    }

    @Override
    public X509Certificate[] decodeCSRReply(InputStream replyInputStream, Collection<X509Certificate> trustedCerts) throws GeneralSecurityException {
        return CertificateUtil.decodeCSRReply((InputStream)replyInputStream, trustedCerts);
    }

    @Override
    public synchronized Set<X509Certificate> getJavaTrustedCaCerts() throws GeneralSecurityException, IOException {
        if (this.javaTrustedCaCerts != null) {
            return this.javaTrustedCaCerts;
        }
        KeyStore caCertsKeystore = this.getCacertsKeystore();
        if (caCertsKeystore == null) {
            this.javaTrustedCaCerts = Collections.emptySet();
        } else {
            this.javaTrustedCaCerts = this.getCerts(caCertsKeystore);
            this.javaTrustedCaCerts = Collections.unmodifiableSet(this.javaTrustedCaCerts);
            this.log.info((Object)("Loaded " + this.javaTrustedCaCerts.size() + " trust anchors from " + CACERTS_FILE));
            Log trustedCasLog = LogFactory.getLog(TrustedCAsManagerImpl.class);
            if (trustedCasLog.isDebugEnabled()) {
                trustedCasLog.debug((Object)"Loading JVM CA certificates:");
                for (X509Certificate cert : this.javaTrustedCaCerts) {
                    trustedCasLog.debug((Object)("SubjectDN: " + cert.getSubjectX500Principal()));
                    trustedCasLog.debug((Object)(" SHA256: " + HashUtil.hashToHexString((byte[])cert.getEncoded(), (HashAlgorithm)HashAlgorithm.SHA256)));
                }
            }
        }
        return this.javaTrustedCaCerts;
    }

    protected Set<X509Certificate> getCerts(KeyStore ks) throws KeyStoreException {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (!ks.isCertificateEntry(alias)) continue;
            Certificate certificate = ks.getCertificate(alias);
            try {
                certs.add((X509Certificate)certificate);
            }
            catch (ClassCastException cce) {
                this.log.error((Object)(certificate + " is not X509. "), (Throwable)cce);
            }
        }
        return certs;
    }

    @Override
    public synchronized KeyStore getCacertsKeystore() throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException {
        if (this.javaTrustedCasKeystore != null) {
            return this.javaTrustedCasKeystore;
        }
        this.javaTrustedCasKeystore = this.loadCaCertsKeyStore();
        return this.javaTrustedCasKeystore;
    }

    protected synchronized KeyStore loadCaCertsKeyStore() throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException {
        File caKeystoreFile = new File(CACERTS_FILE);
        if (!caKeystoreFile.exists()) {
            this.log.warn((Object)("Unable to load JVM CA certificates. Not found: " + caKeystoreFile.getCanonicalPath()));
            return null;
        }
        this.log.debug((Object)("Loading " + caKeystoreFile.getCanonicalPath()));
        KeyStore caKeystore = KeyStore.getInstance(KeyStore.getDefaultType(), "SUN");
        try (FileInputStream in = new FileInputStream(caKeystoreFile);){
            caKeystore.load(in, null);
        }
        return caKeystore;
    }

    private ObjectIdentifier createObjectIdentifierInstance(String oid) {
        Class<ObjectIdentifier> clazz = ObjectIdentifier.class;
        try {
            Method of = clazz.getMethod("of", String.class);
            Object invoke = of.invoke(null, oid);
            if (invoke instanceof ObjectIdentifier) {
                return (ObjectIdentifier)invoke;
            }
            String msg = "ObjectIdentifier.of() method invocation return value type is incorrect";
            throw new ProcessRuntimeException(msg);
        }
        catch (NoSuchMethodException ignored) {
            try {
                return (ObjectIdentifier)clazz.getConstructor(String.class).newInstance(oid);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ProcessRuntimeException("Unable to create a new instance of ObjectIdentifier");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ProcessRuntimeException("Unexpected exception invoking method ObjectIdentifier.of()", e);
        }
    }

    private static enum SupportedSubjectAlternativeNameType {
        IP_ADDRESS("IP Address"){

            @Override
            public GeneralName getGeneralName(String nameValue) throws IOException {
                if (IPAddressUtil.isIPv4LiteralAddress(nameValue) || IPAddressUtil.isIPv6LiteralAddress(nameValue)) {
                    return new GeneralName(new IPAddressName(nameValue));
                }
                throw new IOException("IP Address subject alternative name must be IPv4 or IPv6 address literal");
            }
        }
        ,
        DNS_NAME("DNS Name"){

            @Override
            public GeneralName getGeneralName(String nameValue) throws IOException {
                if (HostAddressUtils.isValidDomainName(nameValue)) {
                    return new GeneralName((GeneralNameInterface)new LenientDNSName(nameValue, LenientDNSName.ValidationMode.BASIC));
                }
                throw new IOException("DNS Name subject alternative name must be a valid domain name");
            }
        };

        private final String nameType;

        private SupportedSubjectAlternativeNameType(String nameType) {
            this.nameType = nameType;
        }

        static SupportedSubjectAlternativeNameType get(String nameTypeString) throws IOException {
            for (SupportedSubjectAlternativeNameType type : SupportedSubjectAlternativeNameType.values()) {
                if (!type.nameType.equals(nameTypeString)) continue;
                return type;
            }
            throw new IOException(nameTypeString + " is not a valid subject alternative name type");
        }

        static SupportedSubjectAlternativeNameType inferTypeFromNameValue(String nameValue) throws IOException {
            for (SupportedSubjectAlternativeNameType type : SupportedSubjectAlternativeNameType.values()) {
                if (!type.isValidNameValue(nameValue)) continue;
                return type;
            }
            throw new IOException("Invalid/unsupported subject alternative name value.");
        }

        static GeneralNames buildGeneralNames(Map<String, String> subjectAlternativeNameMap) throws IOException {
            GeneralNames generalNames = new GeneralNames();
            for (Map.Entry<String, String> entry : subjectAlternativeNameMap.entrySet()) {
                generalNames.add(SupportedSubjectAlternativeNameType.get(entry.getValue()).getGeneralName(entry.getKey()));
            }
            return generalNames;
        }

        public String getNameTypeString() {
            return this.nameType;
        }

        abstract GeneralName getGeneralName(String var1) throws IOException;

        boolean isValidNameValue(String nameValue) {
            try {
                this.getGeneralName(nameValue);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }
}

